/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 13.11.2019
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.person.compositeDto;

import java.util.ArrayList;
import java.util.List;

import at.cdes.api.joinDto.OrganisationPersonJoin;

public class OrganisationPersonDeleteInfo {
    
    
    private OrganisationPersonJoin organisationPersonJoin;
    private boolean deletePermission;
    private boolean inUse;
    private List<String> inUseHints;
    private boolean mainParticipationInUse;
    private List<List<String>> mainParticipationsInUseHints = new ArrayList<List<String>>();
    
    public OrganisationPersonDeleteInfo(OrganisationPersonJoin organisationPersonJoin) {
        this.organisationPersonJoin = organisationPersonJoin;
    }
    
    public OrganisationPersonJoin getOrganisationPersonJoin() {
        return this.organisationPersonJoin;
    }
    public void setOrganisationPersonJoin(OrganisationPersonJoin organisationPersonJoin) {
        this.organisationPersonJoin = organisationPersonJoin;
    }
    public boolean isDeletePermission() {
        return this.deletePermission;
    }
    public void setDeletePermission(boolean deletePermission) {
        this.deletePermission = deletePermission;
    }
    public boolean isInUse() {
        return this.inUse;
    }
    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }
    public List<String> getInUseHints() {
        return this.inUseHints;
    }
    public void setInUseHints(List<String> inUseHints) {
        this.inUseHints = inUseHints;
    }
    public boolean isMainParticipationInUse() {
        return this.mainParticipationInUse;
    }
    public void setMainParticipationInUse(boolean mainParticipationInUse) {
        this.mainParticipationInUse = mainParticipationInUse;
    }
    public List<List<String>> getMainParticipationsInUseHints() {
        return this.mainParticipationsInUseHints;
    }
    public void setMainParticipationsInUseHints(List<List<String>> mainParticipationsInUseHints) {
        this.mainParticipationsInUseHints = mainParticipationsInUseHints;
    }
    public void addMainParticipationInUseHint(List<String> hint) {
        this.mainParticipationsInUseHints.add(hint);
        this.mainParticipationInUse = true;
    }
}
