/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 11.04.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.compositeDto;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.Signature;

public class PlotTaskItemInfo {
    private PlottOrderItem plotOrderItem;
    private DocumentVersion documentVersion;
    private Document document;
    private DocumentRelease documentRelease;
    private PlottProperties plotProperties;
    private OrderAddress deliveryAddress;
    private Country deliveryCountry;
    private ProjectParticipant initiatorParticipant;
    private Person initiatorPerson;
    private ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased;
    private ReviewCycleNode reviewCycleNode;   
    private OrderStep receivedStep;
    private Person receivedPerson;
    
    // Currently not actually used, but here for better debug 
    // possibilities regarding determination of previewSupportDocumentVersion
    private DocumentVersion firstVersion;
    private DocumentVersion otherVersion;
    private DocumentVersion asBuiltFirstVersion;
    
    private DocumentVersion previewSupportDocumentVersion; 
    
    
    public PlottOrderItem getPlotOrderItem() {
        return this.plotOrderItem;
    }
    public void setPlotOrderItem(PlottOrderItem plotOrderItem) {
        this.plotOrderItem = plotOrderItem;
    }
    public DocumentVersion getDocumentVersion() {
        return this.documentVersion;
    }
    public void setDocumentVersion(DocumentVersion documentVersion) {
        this.documentVersion = documentVersion;
    }
    public Document getDocument() {
        return this.document;
    }
    public void setDocument(Document document) {
        this.document = document;
    }
    public DocumentRelease getDocumentRelease() {
        return this.documentRelease;
    }
    public void setDocumentRelease(DocumentRelease documentRelease) {
        this.documentRelease = documentRelease;
    }
    public PlottProperties getPlotProperties() {
        return this.plotProperties;
    }
    public void setPlotProperties(PlottProperties plotProperties) {
        this.plotProperties = plotProperties;
    }
    public OrderAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }
    public void setDeliveryAddress(OrderAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }
    public Country getDeliveryCountry() {
        return this.deliveryCountry;
    }
    public void setDeliveryCountry(Country deliveryCountry) {
        this.deliveryCountry = deliveryCountry;
    }
    public ProjectParticipant getInitiatorParticipant() {
        return this.initiatorParticipant;
    }
    public void setInitiatorParticipant(ProjectParticipant initiatorParticipant) {
        this.initiatorParticipant = initiatorParticipant;
    }
    public Person getInitiatorPerson() {
        return this.initiatorPerson;
    }
    public void setInitiatorPerson(Person initiatorPerson) {
        this.initiatorPerson = initiatorPerson;
    }
    public ReviewCycleNodeInstanceReleased getReviewCycleNodeInstanceReleased() {
        return this.reviewCycleNodeInstanceReleased;
    }
    public void setReviewCycleNodeInstanceReleased(ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased) {
        this.reviewCycleNodeInstanceReleased = reviewCycleNodeInstanceReleased;
    }
    public ReviewCycleNode getReviewCycleNode() {
        return this.reviewCycleNode;
    }
    public void setReviewCycleNode(ReviewCycleNode reviewCycleNode) {
        this.reviewCycleNode = reviewCycleNode;
    }
    public OrderStep getReceivedStep() {
        return this.receivedStep;
    }
    public void setReceivedStep(OrderStep receivedStep) {
        this.receivedStep = receivedStep;
    }
    public Person getReceivedPerson() {
        return this.receivedPerson;
    }
    public void setReceivedPerson(Person receivedPerson) {
        this.receivedPerson = receivedPerson;
    }
    public DocumentVersion getFirstVersion() {
        return this.firstVersion;
    }
    public void setFirstVersion(DocumentVersion firstVersion) {
        this.firstVersion = firstVersion;
    }
    public DocumentVersion getOtherVersion() {
        return this.otherVersion;
    }
    public void setOtherVersion(DocumentVersion otherVersion) {
        this.otherVersion = otherVersion;
    }
    public DocumentVersion getAsBuiltFirstVersion() {
        return this.asBuiltFirstVersion;
    }
    public void setAsBuiltFirstVersion(DocumentVersion asBuiltFirstVersion) {
        this.asBuiltFirstVersion = asBuiltFirstVersion;
    }
    public DocumentVersion getPreviewSupportDocumentVersion() {
        return this.previewSupportDocumentVersion;
    }
    public void setPreviewSupportDocumentVersion(DocumentVersion previewSupportDocumentVersion) {
        this.previewSupportDocumentVersion = previewSupportDocumentVersion;
    }
}
