/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.03.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.compositeDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.SiteType;
import at.cdes.api.dto.WorkflowToken;
import at.cdes.api.joinDto.PlanningNotificationOrderJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;

public class PlanningNotificationOrderInfo {

    private PlanningNotificationOrderJoin orderJoin;
    private List<ProjectJoin> projectJoins;
    private List<PlanningNotificationOrderReferenceInfo> referenceInfos;
    private List<PlanningNotificationTextMetaInformation> baulosMetaInformations;
    private List<PlanningNotificationOrderTag> tags;
    private List<SiteType> siteTypes;
    private List<String> allowedProjectActions;
    private Set<String> globalActions;
    
    /** True if and only if in the Workflow corresponding to the orderJoin, at least one WorkflowToken 
     *  connected with WorkflowNodePosition, WorkflowNode and Workflow via ownerPositionId exists.
     *  
     *  Currently only set by 
     *  
     *  at.cdes.impl.service.PlanningNotificationServiceImpl.getPlanningNotificationOrderJoin(Long)
     *  
     *  ... not by the code returning multiple orderJoins for a list.
     */
    private Boolean workflowInitialized;
    
    // Joins contains WorkflowNode and WorkflowNodeTemplate
    private List<WorkflowNodeJoin> workflowNodeJoins;
    
    // Joins contain WorkflowNodePosition, ProjectParticipation, ProjectParticipant, OrganisationPerson, Organisation and Person
    // (but mostly only a few attributes, maybe just the id)
    private Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions;
    
    private Map<Long, List<WorkflowToken>> workflowNodePositionIdToInitiatorTokens;
    private Map<Long, List<WorkflowToken>> workflowNodePositionIdToOwnerTokens;
    
    private Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose;
    
    private Map<Long, Boolean> workflowNodeInitiatorPositionIdToHasResults;
    private Map<Long, Boolean> initiatorPositionIdToHasFreigabeResults;
    
    public PlanningNotificationOrderJoin getOrderJoin() {
        return this.orderJoin;
    }
    public void setOrderJoin(PlanningNotificationOrderJoin orderJoin) {
        this.orderJoin = orderJoin;
    }
    public List<ProjectJoin> getProjectJoins() {
        return this.projectJoins;
    }
    public void setProjectJoins(List<ProjectJoin> projectJoins) {
        this.projectJoins = projectJoins;
    }
    public List<PlanningNotificationOrderReferenceInfo> getReferenceInfos() {
        return this.referenceInfos;
    }
    public void setReferenceInfos(List<PlanningNotificationOrderReferenceInfo> referenceInfos) {
        this.referenceInfos = referenceInfos;
    }
    public List<PlanningNotificationTextMetaInformation> getBaulosMetaInformations() {
        return this.baulosMetaInformations;
    }
    public void setBaulosMetaInformations(List<PlanningNotificationTextMetaInformation> baulosMetaInformations) {
        this.baulosMetaInformations = baulosMetaInformations;
    }
    public List<PlanningNotificationOrderTag> getTags() {
        return this.tags;
    }
    public void setTags(List<PlanningNotificationOrderTag> tags) {
        this.tags = tags;
    }
    public List<SiteType> getSiteTypes() {
        return this.siteTypes;
    }
    public void setSiteTypes(List<SiteType> siteTypes) {
        this.siteTypes = siteTypes;
    }
    public List<WorkflowNodeJoin> getWorkflowNodeJoins() {
        return this.workflowNodeJoins;
    }
    public void setWorkflowNodeJoins(List<WorkflowNodeJoin> workflowNodeJoins) {
        this.workflowNodeJoins = workflowNodeJoins;
    }
    public Map<Long, List<WorkflowNodeJoin>> getWorkflowNodeIdToPositions() {
        return this.workflowNodeIdToPositions;
    }
    public void setWorkflowNodeIdToPositions(Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions) {
        this.workflowNodeIdToPositions = workflowNodeIdToPositions;
    }
    public Map<Long, List<WorkflowToken>> getWorkflowNodePositionIdToInitiatorTokens() {
        return this.workflowNodePositionIdToInitiatorTokens;
    }
    public void setWorkflowNodePositionIdToInitiatorTokens(Map<Long, List<WorkflowToken>> workflowNodePositionIdToInitiatorTokens) {
        this.workflowNodePositionIdToInitiatorTokens = workflowNodePositionIdToInitiatorTokens;
    }    
    public Map<Long, List<WorkflowToken>> getWorkflowNodePositionIdToOwnerTokens() {
        return this.workflowNodePositionIdToOwnerTokens;
    }
    public void setWorkflowNodePositionIdToOwnerTokens(Map<Long, List<WorkflowToken>> workflowNodePositionIdToOwnerTokens) {
        this.workflowNodePositionIdToOwnerTokens = workflowNodePositionIdToOwnerTokens;
    }
    public Map<Long, List<PlanningNotificationTextMetaInformation>> getWorkflowNodePositionIdToBaulose() {
        return this.workflowNodePositionIdToBaulose;
    }
    public void setWorkflowNodePositionIdToBaulose(Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose) {
        this.workflowNodePositionIdToBaulose = workflowNodePositionIdToBaulose;
    }
    public Boolean isWorkflowInitialized() {
        return this.workflowInitialized;
    }
    public void setWorkflowInitialized(Boolean workflowInitialized) {
        this.workflowInitialized = workflowInitialized;
    }
    public List<String> getAllowedProjectActions() {
        return this.allowedProjectActions;
    }
    public void setAllowedProjectActions(List<String> allowedProjectActions) {
        this.allowedProjectActions = allowedProjectActions;
    }   
    
    public Map<Long, Boolean> getWorkflowNodeInitiatorPositionIdToHasResults() {
        return this.workflowNodeInitiatorPositionIdToHasResults;
    }
    public void setWorkflowNodeInitiatorPositionIdToHasResults(Map<Long, Boolean> workflowNodeInitiatorPositionIdToHasResults) {
        this.workflowNodeInitiatorPositionIdToHasResults = workflowNodeInitiatorPositionIdToHasResults;
    }
    public Map<Long, Boolean> getInitiatorPositionIdToHasFreigabeResults() {
        return this.initiatorPositionIdToHasFreigabeResults;
    }
    public void setInitiatorPositionIdToHasFreigabeResults(Map<Long, Boolean> initiatorPositionIdToHasFreigabeResults) {
        this.initiatorPositionIdToHasFreigabeResults = initiatorPositionIdToHasFreigabeResults;
    }
    public Set<String> getGlobalActions() {
        return this.globalActions;
    }
    public void setGlobalActions(Set<String> globalActions) {
        this.globalActions = globalActions;
    }
}
