/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotPaperQuality {
    LASER_80 ("Laserplot 80g/m2"),
    LASER_90 ("Laserplot 90g/m2"),
    INKJET_80 ("Tintenstrahlplot 80g/m2"),
    INKJET_90 ("Tintenstrahlplot 90g/m2");
    
    private final String value;

    private PlotPaperQuality(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlotPaperQuality getByValue(String value) {
        if (LASER_80.getValue().equals(value)) {
            return LASER_80;
        } else if (LASER_90.getValue().equals(value)) {
            return LASER_90;
        } else if (INKJET_80.getValue().equals(value)) {
            return INKJET_80;
        } else if (INKJET_90.getValue().equals(value)) {
            return INKJET_90;            
        } else {
            return null;
        }
    }    
}
