/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.11.2021
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.task.voc;

public enum TaskDeputyMode {
    
    MAIN_PARTICIPANT ("MainParticipant"),
    DEPUTY ("Deputy");
    
    private final String value;
    
    private TaskDeputyMode(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return this.value;
    }    
    
    public static TaskDeputyMode getByValue(String value) {
        if (MAIN_PARTICIPANT.getValue().equals(value)) {
            return MAIN_PARTICIPANT;
        } else if (DEPUTY.getValue().equals(value)) {
            return DEPUTY;
        } else {
            return null;
        }
    }    
}
