/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.11.2021
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.task.voc;

public enum TaskSearchMode {
    
    OWN ("Own"),
    DONE ("Done"),
    LATE ("Belated"),
    BATCH ("BatchSignatures");  
    
    private final String value;
    
    private TaskSearchMode(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return this.value;
    }    
    
    public static TaskSearchMode getByValue(String value) {
        if (OWN.getValue().equals(value)) {
            return OWN;
        } else if (DONE.getValue().equals(value)) {
            return DONE;
        } else if (LATE.getValue().equals(value)) {
            return LATE;
        } else if (BATCH.getValue().equals(value)) {
            return BATCH;            
        } else {
            return null;
        }
    }
}
