/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 19.07.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.planning.voc;

public enum PlanningNotificationReportFileType {
    PDF ("pdf"),
    PDF_LIST ("pdf_list"),
    XLS ("xls");
    
    private final String value;
    
    private PlanningNotificationReportFileType(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return this.value;
    }    
    
    public static PlanningNotificationReportFileType getByValue(String value) {
        if (value == PDF.getValue()) {
            return PDF;
        } else if (value == PDF_LIST.getValue()) {
            return PDF_LIST;
        } else if (value == XLS.getValue()) {
            return XLS;
        } else {
            return null;
        }
    }
}
