/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 07.04.2023
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCyclePositionType;
import at.cdes.api.joinDto.ListenerJoin;

public class NodeInstanceInfo {
    
    private ReviewCycleNodeInstance nodeInstance;
    private ReviewCycleNode node;
    private ReviewCyclePositionType positionType;
    private boolean isEndNode;
    private List<NodePositionInfo> nodePositionInfos = new ArrayList<NodePositionInfo>();
    //private List<ListenerJoin> plotOrderListenerJoins = new ArrayList<ListenerJoin>();
    //private List<ListenerJoin> notificationListenerJoins = new ArrayList<ListenerJoin>();
    private List<InstanceListenerInfo> listenerInfos = new ArrayList<InstanceListenerInfo>();
    private List<ListenerJoin> listenerJoins = new ArrayList<ListenerJoin>();
    
    // Review matrix
    private List<Realm> realms;
    private List<ParticipationStringInfo> participationStringInfos;
    private Map<Long, Set<Long>> realmIdToSelectedParticipationIds;    

    public ReviewCycleNodeInstance getNodeInstance() {
        return this.nodeInstance;
    }
    public void setNodeInstance(ReviewCycleNodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
    }
    public ReviewCyclePositionType getPositionType() {
        return this.positionType;
    }
    public void setPositionType(ReviewCyclePositionType positionType) {
        this.positionType = positionType;
    }
    public ReviewCycleNode getNode() {
        return this.node;
    }
    public void setNode(ReviewCycleNode node) {
        this.node = node;
    }
    public boolean isEndNode() {
        return this.isEndNode;
    }
    public void setEndNode(boolean isEndNode) {
        this.isEndNode = isEndNode;
    }
    public List<NodePositionInfo> getNodePositionInfos() {
        return this.nodePositionInfos;
    }
    public void setNodePositionInfos(List<NodePositionInfo> nodePositionInfos) {
        this.nodePositionInfos = nodePositionInfos;
    }
    public void addNodePositionInfo(NodePositionInfo nodePositionInfo) {
        this.nodePositionInfos.add(nodePositionInfo);
    }
    /*
    public List<ListenerJoin> getPlotOrderListenerJoins() {
        return this.plotOrderListenerJoins;
    }
    public void setPlotOrderListenerJoins(List<ListenerJoin> plotOrderListenerJoins) {
        this.plotOrderListenerJoins = plotOrderListenerJoins;
    }
    public List<ListenerJoin> getNotificationListenerJoins() {
        return this.notificationListenerJoins;
    }
    public void setNotificationListenerJoins(List<ListenerJoin> notificationListenerJoins) {
        this.notificationListenerJoins = notificationListenerJoins;
    }*/
    public List<ListenerJoin> getListenerJoins() {
        return this.listenerJoins;
    }
    public List<InstanceListenerInfo> getListenerInfos() {
        return this.listenerInfos;
    }
    public void setListenerInfos(List<InstanceListenerInfo> listenerInfos) {
        this.listenerInfos = listenerInfos;
    }
    public void setListenerJoins(List<ListenerJoin> listenerJoins) {
        this.listenerJoins = listenerJoins;
    }
    public List<Realm> getRealms() {
        return this.realms;
    }
    public void setRealms(List<Realm> realms) {
        this.realms = realms;
    }
    public List<ParticipationStringInfo> getParticipationStringInfos() {
        return this.participationStringInfos;
    }
    public List<ParticipationStringInfo> getParticipationStringInfosRestrictedToPositions() {
        Set<Long> nodePositionParticipationIds = new HashSet<Long>();
        for (NodePositionInfo nodePositionInfo : nodePositionInfos) {
            nodePositionParticipationIds.add(nodePositionInfo.getProjectParticipation().getId());
        }        
        List<ParticipationStringInfo> filteredInfos = new ArrayList<ParticipationStringInfo>();
        for (ParticipationStringInfo participationStringInfo : this.participationStringInfos) {
            if (nodePositionParticipationIds.contains(participationStringInfo.getParticipationId())) {
                filteredInfos.add(participationStringInfo);
            }
        }
        return filteredInfos;
    }
    public void setParticipationStringInfos(List<ParticipationStringInfo> participationStringInfos) {                
        this.participationStringInfos = participationStringInfos;
    }
    public Map<Long, Set<Long>> getRealmIdToSelectedParticipationIds() {
        return this.realmIdToSelectedParticipationIds;
    }
    public void setRealmIdToSelectedParticipationIds(Map<Long, Set<Long>> realmIdToSelectedParticipationIds) {
        this.realmIdToSelectedParticipationIds = realmIdToSelectedParticipationIds;
    }
}
