/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotMargin {
    NO_FOLD ("Nicht falten"),
    FOLD_20MM_EDGE ("Falten mit 20mm Heftrand"),
    FOLD_WITHOUT_EDGE ("Falten ohne Heftrand");
    
    private final String value;

    private PlotMargin(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlotMargin getByValue(String value) {
        if (NO_FOLD.getValue().equals(value)) {
            return NO_FOLD;
        } else if (FOLD_20MM_EDGE.getValue().equals(value)) {
            return FOLD_20MM_EDGE;
        } else if (FOLD_WITHOUT_EDGE.getValue().equals(value)) {
            return FOLD_WITHOUT_EDGE;
        } else {
            return null;
        }
    }
}
