/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 03.02.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.compositeDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.UniqueDocumentInfo;
import at.cdes.api.joinDto.ObjectPlannerWithObject;

public class ObjectPlannerNewDocumentInfo {
    
    private List<ObjectPlannerWithObject> objectPlannersWithObjects;
    
    // objectId --> (documentId --> key based on document uniqueness scheme (see CodeHelper))
    private Map<Long, Map<Long, UniqueDocumentInfo>> objectIdToDocumentKeys;
    private Map<Long, Map<Long, UniqueDocumentInfo>> objectPlannerIdToDocumentKeys;
    private Map<Long, Set<String>> objectPlannerIdToAllowedActions;
    
    public void setObjectPlannersWithObjects(List<ObjectPlannerWithObject> objectPlannersWithObjects) {
        this.objectPlannersWithObjects = objectPlannersWithObjects;
    }
    public List<ObjectPlannerWithObject> getObjectPlannersWithObjects() {
        return this.objectPlannersWithObjects;
    }
    
    public Map<Long, Map<Long, UniqueDocumentInfo>> getObjectIdToDocumentKeys() {
        return this.objectIdToDocumentKeys;
    }
    public void setObjectIdToDocumentKeys(Map<Long, Map<Long, UniqueDocumentInfo>> objectIdToDocumentKeys) {
        this.objectIdToDocumentKeys = objectIdToDocumentKeys;
    }
    public Map<Long, Set<String>> getObjectPlannerIdToAllowedActions() {
        return this.objectPlannerIdToAllowedActions;
    }
    public void setObjectPlannerIdToAllowedActions(Map<Long, Set<String>> objectPlannerIdToAllowedActions) {
        this.objectPlannerIdToAllowedActions = objectPlannerIdToAllowedActions;
    }
    public Map<Long, Map<Long, UniqueDocumentInfo>> getObjectPlannerIdToDocumentKeys() {
        return this.objectPlannerIdToDocumentKeys;
    }
    public void setObjectPlannerIdToDocumentKeys(Map<Long, Map<Long, UniqueDocumentInfo>> objectPlannerIdToDocumentKeys) {
        this.objectPlannerIdToDocumentKeys = objectPlannerIdToDocumentKeys;
    }
}
