/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 21.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.review.compositeDto.ReviewCycleNodeInstanceReleasedInfo;

public class DocumentListOtherVersionCellResultInfo {
    
    private ReviewCycle cycle;
    private ReviewCycleCell cell;
    private ReviewCycleCellResult cellResult;
    private List<DocumentListOtherVersionNodeResultInfo> nodeResultInfos; // Sorted by position ASC
    
    // ============ Cycle ========
    public void setReviewCycle(ReviewCycle reviewCycle) {
        this.cycle = reviewCycle;
    }
    
    public Long getCycleEmptyNodeResultOptionId() {
        return this.cycle.getEmptyNodeResultOptionId();
    }
    
    public Long getCycleDocumentVersionDeletedOptionId() {
        return this.cycle.getDocumentVersionDeletedOptionId();
    }
    
    public Long getCycleDocumentVersionInvalidationResultOptionId() {
        return this.cycle.getDocumentVersionInvalidationResultOptionId();
    }

    // ============ Cell ==========
    public void setReviewCycleCell(ReviewCycleCell reviewCycleCell) {
        this.cell = reviewCycleCell;
    }
    
    public Long getCellId() {
        return this.cell.getId();
    }
    
    public String getCellSvgColor() {
        return this.cell.getSvgColor();
    }
    
    // ========= CellResult =======
    public void setCellResult(ReviewCycleCellResult cellResult) {
        this.cellResult = cellResult;
    }
    
    public Long getCellResultId() {
        return this.cellResult.getId();
    }
    
    public Double getCellResultArrivalDate() {
        return this.cellResult.getArrivalDate();
    }
    
    public Double getCellResultDepartureDate() {
        return this.cellResult.getDepartureDate();
    }
    
    public boolean isCellResultFinished() {
        return this.cellResult.isFinished() != null && this.cellResult.isFinished().booleanValue();
    }
    
    public Long getCellResultNextCellId() {
        return this.cellResult.getNextReviewCycleCellId();
    }
    
    public Long getCellResultPreviousCellId() {
        return this.cellResult.getPreviousReviewCycleCellId();
    }
    
    public Long getCellResultDocumentVersionId() {
        return this.cellResult.getDocumentVersionId();
    }
    
    // ======= NodeResults ========
    
    public void setNodeResultInfos(List<DocumentListOtherVersionNodeResultInfo> nodeResultInfos) {
        this.nodeResultInfos = nodeResultInfos;
        
        Collections.sort(this.nodeResultInfos, new Comparator<DocumentListOtherVersionNodeResultInfo>() {
            public int compare(DocumentListOtherVersionNodeResultInfo o1, DocumentListOtherVersionNodeResultInfo o2) {
                Integer positionOne = o1.getNodePosition();
                Integer positionTwo = o2.getNodePosition();
                return positionOne - positionTwo;
            }
        });        
    }
    
    public List<DocumentListOtherVersionNodeResultInfo> getAllNodeResultInfos() {
        // TODO code in at.cdes.bo.data.cycle.cell.ReviewCycleCellResultImpl.getReviewCycleNodeResultsSortedByPosition(boolean) ?
        return this.nodeResultInfos;
    }
    
    public DocumentListOtherVersionNodeResultInfo getNodeResultInfoByNodeId(Long nodeId) {
        for (DocumentListOtherVersionNodeResultInfo currInfo : this.nodeResultInfos) {
            if (currInfo.getNodeId().longValue() == nodeId.longValue()) {
                return currInfo;
            }
        }
        return null;
    }
    
    public DocumentListOtherVersionNodeResultInfo getNodeResultInfoByNodeInstanceReleasedId(Long nodeInstanceReleasedId) {
        for (DocumentListOtherVersionNodeResultInfo currInfo : this.nodeResultInfos) {
            Long currNodeInstanceReleasedId = currInfo.getNodeInstanceReleasedId();
            if (currNodeInstanceReleasedId.longValue() == nodeInstanceReleasedId.longValue()) {
                return currInfo;
            }
        }
        return null;
    }
}
