/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 04.01.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;

import org.clazzes.util.lang.Pair;

import at.cdes.api.compositeDto.PersonCertificates;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonSearchModel;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.util.MainUiInfo;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.person.compositeDto.OrganisationPersonDeleteInfo;
import at.cdes.api.person.compositeDto.PasswordRequirements;
import at.cdes.api.person.compositeDto.PersonEditInfo;
import at.cdes.api.person.compositeDto.PersonInfo;
import at.cdes.api.person.compositeDto.PersonOwnEditInfo;
import at.cdes.api.person.compositeDto.PersonSearchInfo;

public interface PersonService {
    
    public boolean mayInvalidateUserLoginAndCertificates(Long organisationPersonId, Long personId);
    public PersonCertificates invalidateUserLoginAndCertificates(Long organisationPersonId, Long personId);
    
    public PersonSearchInfo getPersonSearchInfo(Long organisationPersonId, Long networkId);
    public PersonInfo getPersonJoins(PersonSearchModel searchModel);
    public PersonEditInfo getPersonEditInfo(Long organisationPersonId, Long personId);
    public PersonOwnEditInfo getPersonOwnEditInfo();
    
    public List<OrganisationPersonJoin> getSimilarPersons(Long organisationPersonId, Person person);
    public OrganisationPerson saveOrganisationPerson(Long organisationPersonId, OrganisationPerson organisationPerson);
    
    /** Saves or updates the given Person with her OrganisationPersons.  
     *  Creates, updates or deletes instances as appropriate and given 
     *  by the ids of the passed instances.  id == null means 'create 
     *  a new instance with these fields', id != null means 'update 
     *  that instance'.
     *  
     *  Expects all OrganisationPersons of the given Person to be passed.
     *  If an OrganisationPerson of the Person exists on database, but not
     *  in the passed List, deletion of the OrganisationPerson on database
     *  will be attempted.  Deletion (and in consequence the whole call to
     *  this method) may fail if instances in other tables we cannot or don´t 
     *  want to delete refer to the deletion candidate OrganisationPerson.
     *  
     *  The given PersonVariables will only be considered when creating a 
     *  new Person, and will be ignored in the Update case.
     *  
     *  For all passed instances (Persons, OrganisationPersons, PersonVariables),
     *  only selected fields will be considered.  Fields like login or password
     *  will be left unchanged regardless of the values passed to this method.
     *  
     *  If the flag fetchNewPersonEditInfo is true, this method returns the
     *  result of method getPersonEditInfo called after all database changes.
     *  The OrganisationPersonJoins in that PersonEditInfo are guaranteed to have
     *  the same order as the OrganisationPersons passed to this method.
     *  This is to allow edit widgets to update their state properly.
     * 
     * @param organisationPersonId id of the OrganisationPerson calling this method.
     * @param person new Person state, only selected fields will be considered
     * @param personVariables new PersonVariables, considered only in creation, and
     *                        only selected fields will be considered
     * @param existingPersonId Id of existing person where the given OrganisationPersons will be
     *                        attached, person and personVariables will be ignored in that case
     * @param organisationPersons new OrganisationPersons, only selected fields will
     *                            be considered.
     * @param fetchNewPersonEditInfo wether getPersonEditInfo should be called 
     *                               afterwards to return the new state
     * @return PersonEditInfo with the updated state, and with OrganisationPersonJoins
     *              in the same order as the passed OrganisationPersons if desired
     *              by flag fetchNewPersonEditInfo, null otherwise.
     */
    public PersonEditInfo saveOrUpdatePersonAndOrganisationPersons(Long organisationPersonId, Person person, PersonVariables personVariables, 
                                                                   Long existingPersonId, List<OrganisationPerson> organisationPersons, boolean fetchNewPersonEditInfo);
    
    /** Returns a List of OrganisationPersonJoins corresponding
     *  to the given Person which block deleting the Person.
     *  An OrganisationPerson blocks deletion if
     *  (1) non-deletable instances refer to it
     *  (2) permission deletePerson for an appropriate network is missing.
     *  
     *  The returned list contains all OrganisationPersonJoins where
     *  deletion is *not* possible, together with a Boolean flag indicating
     *  why.  Case (1) above is represented by true, case (2) by false.
     *  
     *  If the returned list is empty, the Person can be deleted.
     *  If the returned list is non-empty with only true values (case (1)), 
     *  the Person can be invalidated.
     *  Otherwise, deletion isn't possible at all due to lack of privileges.
     * 
     * @param organisationPersonId OrganisationPerson executing this method
     * @param personId person id as described
     * @return all OrganisationPersonJoins for OrganisationPersons that
     *         can *not* be deleted.
     */
    public List<OrganisationPersonDeleteInfo> getPersonDeleteInfo(Long organisationPersonId, Long personId);
    
    public String getPersonAdditonalInfo(Long personId);
    
    public void deletePerson(Long organisationPersonId, Long personId);
    public void undeletePerson(Long organisationPersonId, Long personId);
    public void invalidatePerson(Long organisationPersonId, Long personId);
    
    public List<OrganisationPersonJoin> getOrganisationPersonJoins(Long askingOrganisationPersonId, 
                                                                   List<Long> organisationPersonIds);
    
    public String triggerExportPersonList(PersonSearchModel searchModel, Boolean showDetails, Map<String, Double> columnToWidth, 
                                          List<Pair<String, Boolean>> sortColumns);    

    public MainUiInfo getMainUiInfo(String tabSessionId);
    public void updateContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId, Long subProjectId);
    public void updatePnContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId);

    /* Appararently unused, outcommenting it to avoid implementing security check. */
    //public List<OrganisationPersonSelectionJoin> getByOrganisation(Long organisationId);
    
    public boolean openBuekTasksByDefault();
    
    public Person getOwnPerson();
    public PasswordRequirements getPasswordRequirements();
    public boolean isOldPasswordReused(String password);
    
    public void changePersonPasswordAndSecurityQuestion(String newPassword, String oldPassword, String question, String answer);    
    public void updateOwnPersonData(Person newPerson, PersonVariables newPersonVariables, List<OrganisationPersonJoin> newOrganisationPersonJoins);
}
