/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 15.05.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.mime;

import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;


/** This interface is essentially a copy of at.cdes.bo.mime.MimeSource.  The only difference is, 
 *  that this interface does not contain any methods with at.cdes.service.visit.MimeDataProvider
 *  in the signature.  Those parameters are assumed to be null.
 */
public interface VisitlessMimeSource {
    public String getActionName();
    public boolean isEditable();
    public Object getDestinationObject(Object[] parameters);
    default public String getDocumentVersionFileName(Object[] parameters, String mimeType, boolean longName) {
		return null;
	}
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException;    
}
