/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 04.10.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.Set;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.role.RoleActionEditInfo;
import at.cdes.api.dto.role.RoleEditInfo;
import at.cdes.api.dto.role.RolePageInfo;

public interface RoleService {
    public RolePageInfo getRolesByNetwork(Long organisationPersonId, Long networkId);
    
    /** Returns data and dropdown information for editing Roles. Two modes:
     *  roleId == null ==> add a new role in the given network
     *  roleId != null ==> edit an existing role, networkId will be ignored
     * @param organisationPersonId
     * @param roleId
     * @param networkId
     * @return
     */
    public RoleEditInfo getRoleEditInfo(Long organisationPersonId, Long roleId, Long networkId);
    
    public RoleActionEditInfo getActionEditInfoByRoleId(Long organisationPersonId, Long roleId);
    
    public void saveRole(Long organisationPersonId, CdesRole role);
    
    public void saveRoleActions(Long organisationPersonId, Long roleId, Set<Long> permittedActionIds);
    
    public String deleteRole(Long organisationPersonId, Long roleId);
}
