/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import at.cdes.api.document.compositeDto.PlanUploadCommentSaveInfo;
import at.cdes.api.document.compositeDto.PlanUploadPreviousCommentInfo;
import at.cdes.api.document.compositeDto.ReviewCycleStatementInfo;
import at.cdes.api.document.compositeDto.ReviewCycleStatementSaveInfo;
import at.cdes.api.document.compositeDto.ReviewMatrixInfo;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Label;
import at.cdes.api.dto.LabelContent;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.joinDto.ObjectPlannerReleaseObjectJoin;
import at.cdes.api.result.SaveResult;
import at.cdes.api.review.compositeDto.InstanceInfo;
import at.cdes.api.review.compositeDto.InstanceUpdateInfo;
import at.cdes.api.review.compositeDto.LabelContentDocTypeInfo;
import at.cdes.api.review.compositeDto.LabelContentInfo;
import at.cdes.api.review.compositeDto.LabelInfo;
import at.cdes.api.review.compositeDto.LabelPageInfo;
import at.cdes.api.review.compositeDto.LabelTextField;
import at.cdes.api.review.compositeDto.ReviewData;
import at.cdes.api.review.compositeDto.ReviewSaveInfo;

public interface ReviewService {
    public List<String> signUpload(UUID temporaryDocumentVersionId, Set<Long> documentReferenceIdsToDelete, Long organisationPersonId, 
                             Long destinationId, String comment, String password, Integer previewRotation, String versionPartA, String versionPartB, 
                             List<ReviewCycleStatementSaveInfo> statements, 
                             List<PlanUploadCommentSaveInfo> comments,
                             Map<Long, Map<Long, Boolean>> realmIdToAttachedParticipationIdToSelected);

    public ReviewCycleStatementInfo getStatementInfosForEntry(Long taskId, Long reviewCycleCellId);
    public ReviewCycleStatementInfo getStatementInfosForConnection(Long taskId, Long reviewCycleCellConnectionId);

    public LabelPageInfo getLabelPageInfo(Long organisationPersonId, Long networkId);
    public LabelInfo getLabelInfo(Long organisationPersonId, Long labelId);
    public List<LabelInfo> getLabelInfos(Long organisationPersonId, Long organisationId);
    public void saveLabel(Long organisationPersonId, Label label);
    public LabelContentDocTypeInfo getLabelContentDocTypeJoins(Long organisationPersonId, 
                                                                     Long networkId, Long labelContentId);
    public void saveLabelContentDocTypes(Long organisationPersonId, Long labelContentId,
                                         List<Long> documentTypeIds);
    public LabelContentInfo getLabelContentInfo(Long organisationPersonId, Long labelContentId, Long labelId);
    public void saveLabelContent(Long organisationPersonId, LabelContent labelContent, 
                                 List<LabelTextField> labelTextFields,
                                 byte[] pdfFile, String pdfFileName,
                                 byte[] originalFile, String originalFileName);
    public void deleteLabel(Long organisationPersonId, Long labelId);
    public void deleteLabelContent(Long organisationPersonId, Long labelContentId);
    public boolean copyLabel(Long organisationPersonId, Long labelId);

    public ReviewMatrixInfo getReviewMatrixInfo(Long organisationPersonId, Long documentId, Long documentVersionId, Long reviewCycleCellId);

    public List<ReviewCycle> getReviewCyclesByNetwork(Long networkId);

    public ReviewData saveReview(ReviewSaveInfo saveInfo, Long taskId, Long organisationPersonId, boolean override);

    public ReviewData saveReviewToSignatureFolder(ReviewSaveInfo saveInfo, Long taskId, Long organisationPersonId, boolean override);

    public ReviewData moveToSignatureFolder(Long taskId, Long organisationPersonId);

    public void signReviews(List<Long> taskIds, Long organisationPersonId, String password);
    public ReviewData signReview(Long taskId, Long organisationPersonId, String password);

    public void saveReviewCycleCellChangeComment(Long organisationPersonId, Long documentVersionTaskId,
                                                 List<PlanUploadCommentSaveInfo> comments);
    public ReviewData saveAndSignReview(ReviewSaveInfo saveInfo, Long taskId, Long organisationPersonId, String password, boolean override);

    public PlanUploadPreviousCommentInfo getPreviousCommentInfo(Long selectCellConnectionTaskId, Long organisationPersonId);

    public ReviewData getReviewData(Long taskId, Long organisationPersonId, boolean override);
    
    public InstanceInfo getInstanceInfo(Long organisationPersonId, Long instanceId);
    public String triggerExportInstanceInfo(Long loginOrganisationPersonId, Long instanceId);
    
    public ReviewCycleInstance copyReviewCycleInstance(Long organisationPersonId, Long instanceId);
    public InstanceInfo getNewInstanceInfo(Long organisationPersonId, Long subProjectId);
    
    public SaveResult createInstance(Long organisationPersonId, ReviewCycleInstance instance);
    public String updateInstance(Long organisationPersonId, InstanceUpdateInfo instanceUpdateInfo);
    public void setObjectPlannerInstance(Long organisationPersonId, Long objectPlannerId, Long instanceId);
    public boolean addCellInstance(Long organisationPersonId, Long instanceId, Long cellId);  
    public ReviewCycleCellResult generateCellAndNodeResult(DocumentVersion documentVersion, ObjectPlannerReleaseObjectJoin objectJoin, ReviewCycleInstanceReleased reviewCycleInstance);
    
}
