/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 25.12.2014
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;

import at.cdes.api.compositeDto.CertificateSearchResult;
import at.cdes.api.dto.Ca;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateSearchModel;
import at.cdes.api.dto.Network;
import at.cdes.api.joinDto.CertificateJoin;

public interface CertificateService {

    public List<Ca> getValidUserCas (Long organisationPersonId, Long certificateRequestId);

    public CertificateSearchResult getCertificateJoin( Long organisationPersonId, CertificateSearchModel searchModel);

    public CertificateJoin getCertificateJoinForOrganisationPersonPerson(Long organisationPersonId, Long personId);

    public void deleteCertificateRequest(Long certificateRequestId, Long organisationPersonId);

    public List<Network> getNetworksForInvitation(Long organisationPersonId);

    /** Renews the given certificate by (1) invalidating it, and (2) creating a new, valid, certificate.
     *
     * @param certificateId
     * @param userCaId
     * @param password
     * @param organisationPersonId
     * @return List of CertificateJoins of size 2, at index zero, the new state of the old, now invalidated, certificate is returned,
     *        at index one the new certificate
     */
    public List<CertificateJoin> renewCertificate(Long certificateId, // bar
                                                  // foo
                                                  Long userCaId, String password, Long organisationPersonId);

    public Certificate invalidateCertificate(Long certificateId, Long organisationPersonId);

    public Certificate unlockCertificate(Long certificateId, Long organisationPersonId);

    public void sendCertificateConfirmation(Long certificateRequestId, Long certificateOrganisationPersonId, Long contextOrganisationPersonId);

    public void sendCertificateInvitationMail(Long organisationPersonId, Long certificateId, Long certificateRequestId, int type);

    public void inviteAndSendAllPerMail(Long invitedOrganisationPersonId, Long networkId, Long inviterOrganisationPersonId);

    public boolean isBroadcastUserPolicyButtonAvailable(Long organisationPersonId);
    public void broadcastUserPolicy(Long organisationPersonId);

    /**
     *
     * @param certificateRequestId
     * @param caId
     * @param signerId the id of the OrganisationPerson signing the certificate
     * @param password
     */
    public void signCertificateRequest(Long certificateRequestId, Long caId, Long signerId, String password);

    public void signCertificateRequestDirectly(Long certificateId, Long organisationPersonId, Long caId, Long signerId, String password);

    public void declareCertificateRequestPdfUploaded(Long organisationPersonId, Long certificateRequestId);
    
    public void extendChangePassword(Long certificateId, Long organisationPersonId);

}
