/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.10.2017
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.guiService;

import at.cdes.api.document.compositeDto.OriginalDocumentOrderPageInfo;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.clazzes.util.lang.Pair;

import at.cdes.api.document.ManualNotFoundResolution;
import at.cdes.api.document.compositeDto.AnlagentypFileInfo;
import at.cdes.api.document.compositeDto.ArchiveCreateData;
import at.cdes.api.document.compositeDto.DocumentCompareData;
import at.cdes.api.document.compositeDto.DocumentListData;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.document.compositeDto.DocumentOrDocumentRelease;
import at.cdes.api.document.compositeDto.DocumentPageInfo;
import at.cdes.api.document.compositeDto.DocumentUploadInfo;
import at.cdes.api.document.compositeDto.OriginalDocumentOrderInfo;
import at.cdes.api.document.compositeDto.RequestOriginalDocumentData;
import at.cdes.api.document.compositeDto.ReviewProtocolData;
import at.cdes.api.document.compositeDto.SeekLabelResult;
import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.document.searchModel.OriginalDocumentOrderSearchModel;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.review.compositeDto.ReviewData;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.joinDto.DestinationConnectionJoin;

public interface DocumentService {

    public DocumentPageInfo getDocumentPageInfo(Long organisationPersonId, Long subProjectId);
    public DocumentListData getDocumentListSmallJoin(DocumentSearchModel searchModel);
    public DocumentListData getDocumentListAsBuiltJoin(DocumentSearchModel searchModel);
    public List<String> insertCopiesOfAsBuiltDocumentVersions(List<Long> documentVersionIds, Long subProjectId, Long organisationPersonId, String password, boolean onlyDocumentReference);
    public DocumentListData getDocumentListJoin(DocumentSearchModel searchModel);
    public DocumentListData getDocumentListJoinForArchive(DocumentSearchModel searchModel);
    public DocumentListData getDocumentListJoinForXls(DocumentSearchModel searchModel);
    public DocumentListData getDocumentListJoinForVersionId(Long organisationPersonId, Long documentVersionId);
    public String triggerExportDocumentPage(DocumentSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns);
    public String triggerExportDocumentPageXls(DocumentSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns);
    public void invalidateDocumentVersion(Long organisationPersonId, Long documentVersionId, 
                                          String password, String comment, Long resultOptionId,
                                          boolean reactivateLastReleasedVersion, Boolean authorized);
    public void deleteDocumentVersion(Long organisationPersonId, Long documentVersionId);

    public ReviewProtocolData getReviewProtocolData(Long organisationPersonId, Long documentVersionId);
    public String triggerExportReviewProtocol(Long organisationPersonId, Long documentVersionId);

    /* DO NOT USE THESE FUNCTIONS.     DON`T DO IT.    THEY ARE NOT RELIABLE AND POTENTIALLY DANGEROUS.
    public Boolean deleteDocumentVersion(Long organisationPersonId, Long documentVersionId);
    public Boolean deleteNodeResult(Long organisationPersonId, Long reviewCycleNodeResultId);
    public Boolean deletePositionResult(Long organisationPersonId, Long reviewCyclePositionResultId);
    public Boolean moveNodeResultToNextNode(Long organisationPersonId, Long nodeResultId);
    public Boolean insertCreateMissingTasks(Long organisationPersonId, Long nodeResultId);
    */

    public DocumentCompareData getDocumentCompareData(Long organisationPersonId, Long documentVersionId);
    public RequestOriginalDocumentData getRequestOriginalDocumentData(Long organisationPersonId, Long documentVersionId, Long projectId);
    public void requestOriginalDocumentForOwnOrganisationPerson(Long organisationPersonId, Long documentVersionId, String comment);
    public void requestOriginalDocumentForOrganisations(Long organisationPersonId, Long documentVersionId, List<Long> organisationIds, String comment);
    public void deleteOriginalOrder(Long organisationPersonId, Long originalDocumentOrderId);

    public ArchiveCreateData getArchiveCreateData(DocumentSearchModel documentSearchModel);
    public String triggerExportDocumentVersionArchive(DocumentSearchModel searchModel, int archiveFileFormat, int archiveScope, boolean doIncludeReviewHistory);

    public void registerMspExportJob(Long organisationPersonId, Long projectId, String anlagentypTempFileName,
                                     Map<Long, List<String>> objectPlannerIdToAnlagentypen, String mspPath, List<Long> documentVersionIds);
    public void performDocumentExportToMsp();
    public AnlagentypFileInfo readAndCheckAnlagentypFile(Long organisationPersonId, String fileName);

    public List<DocumentVersion> getFormerVersions(Long organisationPersonId, Long documentVersionId);

    public OriginalDocumentOrderPageInfo getOriginalDocumentOrderPageInfo(Long organisationPersonId, Long subProjectId);
    public List<OriginalDocumentOrderInfo> getOriginalDocumentOrders(Long organisationPersonId, OriginalDocumentOrderSearchModel searchModel);

    public void signProvideOriginalDocumentOrder(Long organisationPersonId, String password, String comment, Long originalDocumentOrderId, Boolean accepted, byte[] data, String fileName);

    public List<ReviewCycleCell> getDestinations(Long organisationPersonId, Long documentId, Long subProjectId);

    public List<DestinationConnectionJoin> getDestinationConnections(Long organisationPersonId, Long documentVersionId);

    public DocumentOrDocumentRelease getLatestReleasedVersion(Long documentId);

    public DocumentUploadInfo getUploadInfo(Long organisationPersonId, Long documentId, Long taskId, /* NULLABLE */ Long reviewCycleCellId);

    public DocumentUploadInfo getUploadInfoForVersion(Long organisationPersonId, Long documentVersionId, Long taskId, /* NULLABLE */ Long reviewCycleCellId, Long reviewCycleCellConnectionId);

    public void uploadTemporayDocumentVersion(UUID id, Long organisationPersonId, String fileName, String planNumber, String versionPartA, String versionPartB, Long unreleasedDocumentId, Long taskId, byte[] data);

    public void deleteTemporaryDocumentVersion(UUID id);

    public SeekLabelResult seekLabel(UUID temporaryDocumentVersionId, ManualNotFoundResolution manualNotFoundResolution);

    // returns a temporary id that is only useful in connection with the temporaryDocumentVersionId
    public Long uploadDocumentReference(UUID temporaryDocumentVersionId, DocumentReference ref, /* OPTIONAL */ byte[] data);

    public void deleteDocumentReference(UUID temporaryDocumentVersionId, Long id);

    public void editDocumentReference(UUID temporaryDocumentVersionId, Long id, DocumentReference newRef);
    public boolean isTemporaryDocumentVersionComplete(Long organisationPersonId, UUID temporaryDocumentVersionId);    

    public void editDocumentReferenceData(UUID temporaryDocumentVersionId, Long id, DocumentReference newRef, /* OPTIONAL */ byte[] data);

    // returns the filename in the temporary repository.
    public String uploadTemporaryAttachment(UUID attachmentId, String originalFileName, byte[] data);

    public void deleteTemporaryAttachment(UUID attachmentId);
}
