/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 13.04.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.compositeDto;

import at.cdes.api.dto.PlanningNotificationOrder;

public class PlanningNotificationOrderImportLine {

    private Long workflowEntityId;
    private Long serialNumber;
    private Integer lineNumber;
    private String message;
    private Boolean error;
    private PlanningNotificationOrderInfo planningNotificationOrderInfo;
    
    public PlanningNotificationOrderImportLine() {
        
    }
    
    public PlanningNotificationOrderImportLine(Long workflowEntityId, Long serialNumber, Integer lineNumber, String message, Boolean error) {
        this.workflowEntityId = workflowEntityId;
        this.serialNumber = serialNumber;
        this.lineNumber = lineNumber;
        this.message = message;
        this.error = error;
    }
    
    public Long getWorkflowEntityId() {
        return this.workflowEntityId;
    }

    public void setWorkflowEntityId(Long workflowEntityId) {
        this.workflowEntityId = workflowEntityId;
    }

    public Long getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }
    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }
    public String getMessage() {
        return this.message;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    public Boolean getError() {
        return this.error;
    }
    public void setError(Boolean error) {
        this.error = error;
    }
    
    
    public PlanningNotificationOrderInfo getPlanningNotificationOrderInfo() {
        return this.planningNotificationOrderInfo;
    }

    public void setPlanningNotificationOrderInfo(PlanningNotificationOrderInfo planningNotificationOrderInfo) {
        this.planningNotificationOrderInfo = planningNotificationOrderInfo;
    }

    public static PlanningNotificationOrderImportLine constructError(Integer lineNumber, String message) {
        return new PlanningNotificationOrderImportLine(null, null, lineNumber, message, true);
    }
}
