/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 02.01.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.certificate;

import at.cdes.api.dto.Ca;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.joinDto.OrganisationPersonJoin;

public interface CertificateGenerator {
    
    public String generateChallenge();
    public void renewCertificate(Certificate oldCertificate, Certificate newCertificate, Ca certificateAuthority, String password, Long signerId, int years);
    public void signCertificateRequest(Certificate certificate, CertificateRequest certificateRequest, Ca ca, String password, Long signerId, int years);
    public Certificate generateDirectCertificate(OrganisationPersonJoin opJoin,byte[] privateKey);
    public Certificate signCertificateDirectly(Certificate certificate, Ca ca, 
                                               String password, Long signerId, int years, Certificate oldCertificate);    
    public Certificate generateCertificate(CertificateRequest invitation, OrganisationPersonJoin requester, String password);
    public Certificate changePassword(String newPassword, String oldPassword, Certificate cert);    
}
