/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 21.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentListRelease;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ReviewCycleCellConnectionResult;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleEntryResult;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.review.compositeDto.AttachedNodePositionInfo;
import at.cdes.api.review.compositeDto.ReviewCycleCellInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInstanceReleasedInfo;
import at.cdes.api.voc.DocumentVersionStatus;

/** Represents one row of the DocumentList.
 */
public class DocumentListRow {
    
    private String key;
    private Document document;
    private DocumentRelease documentRelease;
    private DocumentListRelease documentListRelease;
    private DocumentVersion documentVersion;
    private ObjectPlanner objectPlanner;
    private ObjectPlannerRelease objectPlannerRelease;
    private Object object;
    private ObjectRelease objectRelease;
    private ObjectListRelease objectListRelease;
    private ObjectType objectReleaseObjectType;
    private SubProject subProject;
    private Project project;
    private Long reviewCycleInstanceId;
    private Long reviewCycleId;
    private ReviewCycleNodeInstance reviewCycleNodeInstance;
    private ReviewCycleInstanceReleasedInfo instanceReleasedInfo;
    private ReviewCyclePositionResult latestPositionResult;
    private ReviewCycleNodeResult latestNodeResult;
    
    private DocumentVersion previewSupportDocumentVersion;
    private DocumentVersion revisedDocumentVersion;
    private boolean selected;
    private boolean alreadyCopied;
    private boolean duplicatedName;
    private boolean hasValidLabel;
    
    /** Currently only filled if queried by documentVersionId.
     */
    private List<DocumentReference> documentReferences;
    
    /** Currently only filled if queried by documentVersionId.
     */    
    private List<ReviewCycleResultOption> invalidateOptions;  
    
    private boolean showDeleteNotAvailableHint;
    private boolean showAsBuiltHint;
    private boolean showNoneHint;
    private Set<Long> invalidateOptionIdsWithReactivationOption;
    
    private ReviewCycleCellConnectionResult cellConnectionResult;
    private ReviewCycleEntryResult entryResult;
    private List<StatementResultInfo> statementResultInfos;
    private ProjectParticipant plannerParticipant;
    private Organisation plannerOrganisation;
    private Person plannerPerson;
    private Person plannerMainPerson;
    private ReviewCycleCellResult destCellResult;
    
    // Sorted by uploaded ASC
    private List<DocumentListOtherVersionInfo> otherVersionInfos;
    private boolean isReleasedVersionOfRevision;
    private Map<Long, DocumentListOtherVersionInfo> idToOtherVersionInfo;
    private Map<Long, DocumentListOtherVersionCellResultInfo> idToCellResultInfo;
    
    private List<AttachedNodePositionInfo> attachedNodePositionInfos;
    
    // See at.cdes.impl.reviewCycle.SmallReviewCycleSvgRenderer.evalPopupDocumentVersionStatus(XMLStreamWriter, DocumentListRow, ReviewCycleInfo)
    private int openPositionCount = 0;
    private int signedPositionResultCount = 0;
    private Set<String> openPositionParticipationStrings = new HashSet<String>();
    
    public void setKey(String key) {
        this.key = key;
    }
    
    // ======= Document ==========
    public void setDocument(Document document) {
        this.document = document;
    }    
    
    public Document getDocument() {
        return this.document;
    }
    
    public Long getDocumentId() {
        return this.document != null ? this.document.getId() : null;
    }
    
    public String getDocumentName() {
        return this.document != null ? this.document.getName() : null;
    }    
    
    public String getDocumentContent() {
        return this.document != null ? this.document.getContent() : null;
    }
    
    public boolean getDocumentHasDocumentVersions() {
        return this.document != null && this.document.getHasDocumentVersions() != null && this.document.getHasDocumentVersions().booleanValue();
    }
    
    public Double getDocumentStartDate() {
        return this.document != null ? this.document.getStartDate() : null;
    }
    
    public Double getDocumentEndDate() {
        return this.document != null ? this.document.getEndDate() : null;
    }    
    
    // ==== DocumentRelease ======
    
    public void setDocumentRelease(DocumentRelease documentRelease) {
        this.documentRelease = documentRelease;
    }
    
    public boolean hasDocumentRelease() {
        return this.getDocumentReleaseId() != null;
    }
    
    public DocumentRelease getDocumentRelease() {
        return this.documentRelease;
    }
    
    public Long getDocumentReleaseId() {
        return this.documentRelease != null ? this.documentRelease.getId() : null;
    }
    
    public String getDocumentReleaseName() {
        return this.documentRelease != null ? this.documentRelease.getName() : null;
    }    
    
    public String getDocumentReleaseContent() {
        return this.documentRelease != null ? this.documentRelease.getContent() : null;
    }
    
    public Double getDocumentReleaseStartDate() {
        return this.documentRelease != null ? this.documentRelease.getStartDate() : null;
    }
    
    public Double getDocumentReleaseEndDate() {
        return this.documentRelease != null ? this.documentRelease.getEndDate() : null;
    }
    
    // ===== DocumentListRelease ======
    
    public void setDocumentListRelease(DocumentListRelease documentListRelease) {
        this.documentListRelease = documentListRelease;
    }
    
    public Long getDocumentListReleaseId() {
        return this.documentListRelease.getId();
    }
    
    // ==== DocumentVersion ======
    public void setDocumentVersion(DocumentVersion documentVersion) {
        this.documentVersion = documentVersion;
    }
    
    public boolean hasDocumentVersion() {
        return this.getDocumentVersionId() != null;
    }
    
    public DocumentVersion getDocumentVersion() {
        return this.documentVersion;
    }
    
    public Long getDocumentVersionId() {
        return this.documentVersion != null ? this.documentVersion.getId() : null;
    }
    
    public String getDocumentVersionName() {
        return this.documentVersion != null ? this.documentVersion.getName() : null;
    }
    
    public String getDocumentVersionAlternativeName() {
        return this.documentVersion != null ? this.documentVersion.getAlternativeName() : null;
    }
    
    public DocumentVersionStatus getDocumentVersionStatus() {
        return this.documentVersion != null ? DocumentVersionStatus.getByValue(this.documentVersion.getStatus()) : null;
    }
    
    public Double getDocumentVersionUploaded() {
        return this.documentVersion != null ? this.documentVersion.getUploaded() : null;
    }
    
    public boolean isInAction() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.INREVIEW || status == DocumentVersionStatus.INVALIDATEDVERSION
                || status == DocumentVersionStatus.RELEASEDNEGATIV || status == DocumentVersionStatus.DELETED;
    }
    
    public boolean isDeleted() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.DELETED;
    }    
    
    public boolean isInvalidated() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.INVALIDATEDVERSION;
    }
    
    public boolean isInvalidatedAll() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.INVALIDATEDALL;        
    }
    
    public boolean isPrereviewed() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.PREREVIEWED;        
    }
    
    public boolean isReleasedPositivOrNegativ() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.RELEASEDPOSITIV
                || status == DocumentVersionStatus.RELEASEDNEGATIV;
    }
    
    public boolean isReleasedPositive() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.RELEASEDPOSITIV;        
    }
    
    public boolean isReleasedNegativ() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return status == DocumentVersionStatus.RELEASEDNEGATIV;        
    }
    
    public boolean isInvalidatedOrDeleted() {
        DocumentVersionStatus status = this.getDocumentVersionStatus();
        return (status == DocumentVersionStatus.INVALIDATEDVERSION 
                || status == DocumentVersionStatus.INVALIDATEDALL 
                || status == DocumentVersionStatus.DELETED 
                || status == DocumentVersionStatus.ABORTED);
    }    
    
    // ================= ObjectPlanner ===========
    
    public void setObjectPlanner(ObjectPlanner objectPlanner) {
        this.objectPlanner = objectPlanner;
    }
    
    public Long getObjectPlannerId() {
        return this.objectPlanner.getId();
    }
    
    public boolean isObjectPlannerInactive() {
        return this.objectPlanner.isInactive() != null && this.objectPlanner.isInactive().booleanValue();
    }
    
    // ============ ObjectPlannerRelease =========   
    
    public void setObjectPlannerRelease(ObjectPlannerRelease objectPlannerRelease) {
        this.objectPlannerRelease = objectPlannerRelease;
    }
    
    public Long getObjectPlannerReleaseId() {
        return this.objectPlannerRelease != null ? this.objectPlannerRelease.getId() : null;
    }    
    
    public String getObjectPlannerReleaseCode() {
        return this.objectPlannerRelease != null ? this.objectPlannerRelease.getCode() : null;
    }
    
    public String getObjectPlannerReleaseArea() {
        return this.objectPlannerRelease != null ? this.objectPlannerRelease.getArea() : null;
    }    
    
    // =================== Object ================
    
    public void setObject(Object object) {
        this.object = object;
    }
    
    // ================ ObjectRelease ============
    
    public void setObjectRelease(ObjectRelease objectRelease) {
        this.objectRelease = objectRelease;
    }
    
    public void setObjectReleaseObjectType(ObjectType objectType) {
        this.objectReleaseObjectType = objectType;
    }
    
    public String getObjectReleaseObjectTypeCode() {
        return this.objectReleaseObjectType != null ? this.objectReleaseObjectType.getCode() : null;
    }
    
    public String getObjectReleaseCode() {
        return this.objectRelease != null ? this.objectRelease.getCode() : null;
    }
    
    public String getObjectReleaseName() {
        return this.objectRelease != null ? this.objectRelease.getName() : null;
    }
    
    // ============= ObjectListRelease =============
    
    public void setObjectListRelease(ObjectListRelease objectListRelease) {
        this.objectListRelease = objectListRelease;
    }
    
    public Long getObjectListReleaseId() {
        return this.objectListRelease.getId();
    }    
    
    // =========== SubProject ===============
    public void setSubProject(SubProject subProject) {
        this.subProject = subProject;
    }
    
    public Long getSubProjectId() {
        return this.subProject.getId();
    }
    
    // ============ Project =================
    
    public void setProject(Project project) {
        this.project = project;
    }
    
    public Long getProjectId() {
        return this.project.getId();
    }
    
    public boolean isUsePDCStartDateForTasks() {
        return this.project != null && this.project.isUsePDCStartDateForTasks() != null && this.project.isUsePDCStartDateForTasks().booleanValue();
    }
    
    // ==== ReviewCycleInstanceReleased, infos =====
    
    public void setInstanceReleasedInfo(ReviewCycleInstanceReleasedInfo instanceReleasedInfo) {
        this.instanceReleasedInfo = instanceReleasedInfo;
    }
    
    public ReviewCycleInstanceReleasedInfo getInstanceReleasedInfo() {
        return this.instanceReleasedInfo;
    }
    
    public String getReviewCycleInstanceReleasedName() {
        return this.instanceReleasedInfo.getInstanceReleasedName();
    }
    
    public Integer getReviewCycleInstanceReleasedDuration() {
        return this.instanceReleasedInfo.getInstanceReleasedDuration();
    }
    
    public Integer getReviewCycleInstanceReleasedDurationMin() {
        return this.instanceReleasedInfo.getInstanceReleasedDurationMin();
    }
    
    public Integer getReviewCycleInstanceReleasedDurationPre() {
        return this.instanceReleasedInfo.getInstanceReleasedDurationPre();
    }
    
    // ========== ReviewCycleNodeResult =============
    
    public void setLatestNodeResult(ReviewCycleNodeResult latestNodeResult) {
        this.latestNodeResult = latestNodeResult;
    }
    
    public boolean hasLatestNodeResult() {
        return this.latestNodeResult != null && this.latestNodeResult.getId() != null;
    }
    
    public Double getLatestNodeResultArrivalDate() {
        return this.latestNodeResult != null ? this.latestNodeResult.getArrivalDate() : null;
    }
    
    public Long getLatestNodeResultNodeId() {
        return this.latestNodeResult != null ? this.latestNodeResult.getReviewCycleNodeId() : null;
    }
    
    // ======== ReviewCyclePositionResult ===========
    
    public void setLatestPositionResult(ReviewCyclePositionResult latestPositionResult) {
        this.latestPositionResult = latestPositionResult;
    }
    
    public boolean hasLatestPositionResult() {
        return this.latestPositionResult != null && this.latestPositionResult.getId() != null;
    }
    
    public Double getLatestPositionResultResultDate() {
        return this.hasLatestPositionResult() ? this.latestPositionResult.getResultDate() : null;
    }
    
    public Long getLatestPositionResultResultOptionId() {
        return this.hasLatestPositionResult() ? this.latestPositionResult.getReviewCycleResultOptionId() : null;
    }
    
    // ============ PreviewSupportDocumentVersion =========
    
    public void setPreviewSupportDocumentVersion(DocumentVersion previewSupportDocumentVersion) {
        this.previewSupportDocumentVersion = previewSupportDocumentVersion;
    }
    
    public void setRevisedDocumentVersion(DocumentVersion revisedDocumentVersion) {
        this.revisedDocumentVersion = revisedDocumentVersion;
    }
    
    public DocumentVersionStatus getRevisedDocumentVersionStatus() {
        return DocumentVersionStatus.getByValue(this.revisedDocumentVersion.getStatus());
    }
    
    // ============ ReviewCycleNodeInstance ===============
    
    public void setReviewCycleNodeInstance(ReviewCycleNodeInstance nodeInstance) {
        this.reviewCycleNodeInstance = nodeInstance;
    }
    
    public Long getReviewCycleNodeInstanceCellInstanceId() {
        return this.reviewCycleNodeInstance != null ? this.reviewCycleNodeInstance.getReviewCycleCellInstanceId() : null;
    }
    
    public Long getReviewCycleNodeInstanceNodeId() {
        return this.reviewCycleNodeInstance != null ? this.reviewCycleNodeInstance.getReviewCycleNodeId() : null;
    }
    
    // ============================= DocumentReferences ============================================
    
    public void setDocumentReferences(List<DocumentReference> documentReferences) {
        this.documentReferences = documentReferences;
    }
    
    // ============================ Invalidate-ReviewCycleResultOptions ============================
    
    public void setInvalidateOptions(List<ReviewCycleResultOption> invalidateOptions) {
        this.invalidateOptions = invalidateOptions;
    }
    
    public boolean hasInvalidateOption(Long optionId) {
        return this.getInvalidateOption(optionId) != null;
    }
    
    public ReviewCycleResultOption getInvalidateOption(Long optionId) {
        for (ReviewCycleResultOption option : invalidateOptions) {
            if (option.getId().longValue() == optionId.longValue()) {
                return option;
            }
        }
        return null;
    }    
    
    public void setShowDeleteNotAvailableHint(boolean showDeleteNotAvailableHint) {
        this.showDeleteNotAvailableHint = showDeleteNotAvailableHint;
    }

    public void setShowAsBuiltHint(boolean showAsBuiltHint) {
        this.showAsBuiltHint = showAsBuiltHint;
    }

    public void setShowNoneHint(boolean showNoneHint) {
        this.showNoneHint = showNoneHint;
    }    
    
    public void setInvalidateOptionIdsWithReactivationOption(Set<Long> invalidateOptionIdsWithReactivationOption) {
        this.invalidateOptionIdsWithReactivationOption =
                invalidateOptionIdsWithReactivationOption;
    }
    
    // =========== Planner (from ReviewCycleCellConnectionResult and ReviewCycleEntryResult) =======   

    public void setCellConnectionResult(ReviewCycleCellConnectionResult cellConnectionResult) {
        this.cellConnectionResult = cellConnectionResult;
    }
    
    public void setEntryResult(ReviewCycleEntryResult entryResult) {
        this.entryResult = entryResult;
    }
    
    public void setPlannerParticipant(ProjectParticipant plannerParticipant) {
        this.plannerParticipant = plannerParticipant;
    }

    public void setPlannerOrganisation(Organisation plannerOrganisation) {
        this.plannerOrganisation = plannerOrganisation;
    }

    public void setPlannerPerson(Person plannerPerson) {
        this.plannerPerson = plannerPerson;
    }

    public void setPlannerMainPerson(Person plannerMainPerson) {
        this.plannerMainPerson = plannerMainPerson;
    }
    
    public void setDestCellResult(ReviewCycleCellResult cellResult) {
        this.destCellResult = cellResult;
    }
    
    public boolean hasCellConnectionResult() {
        return this.cellConnectionResult != null && this.cellConnectionResult.getId() != null;
    }
    
    public Long getCellConnectionResultSourceDocumentVersionId() {
        return this.cellConnectionResult != null ? this.cellConnectionResult.getSourceDocumentVersionId() : null;
    }
    
    public Double getCellConnectionResultResultDate() {
        return this.cellConnectionResult != null ? this.cellConnectionResult.getResultDate() : null;
    }
    
    public String getCellConnectionResultComment() {
        return this.cellConnectionResult != null ? this.cellConnectionResult.getComment() : null;
    }
    
    public boolean hasEntryResult() {
        return this.entryResult != null && this.entryResult.getId() != null;
    }
    
    public Long getEntryResultDocumentVersionId() {
        return this.entryResult != null ? this.entryResult.getDocumentVersionId() : null;
    }
    
    public String getEntryResultComment() {
        return this.entryResult != null ? this.entryResult.getComment() : null;
    }
    
    public Double getEntryResultResultDate() {
        return this.entryResult != null ? this.entryResult.getResultDate() : null;
    }
    
    public Boolean isPlannerMainParticipant() {
        if (this.plannerParticipant == null) {
            return null;
        } else {
            return this.plannerParticipant.getMainParticipantFlag() != null && this.plannerParticipant.getMainParticipantFlag().booleanValue();
        }
    }
    
    public String getPlannerOrganisationName() {
        return this.plannerOrganisation != null ? this.plannerOrganisation.getName() : null;
    }
    
    public String getPlannerPersonGivenName() {
        return this.plannerPerson != null ? this.plannerPerson.getGivenName() : null;
    }
    
    public String getPlannerPersonSurName() {
        return this.plannerPerson != null ? this.plannerPerson.getSurName() : null;
    }
    
    public String getPlannerMainPersonGivenName() {
        return this.plannerMainPerson != null ? this.plannerMainPerson.getGivenName() : null;
    }
    
    public String getPlannerMainPersonSurName() {
        return this.plannerMainPerson != null ? this.plannerMainPerson.getSurName() : null;
    }    
    
    public Long getDestCellResultCellId() {
        return this.destCellResult != null ? this.destCellResult.getReviewCycleCellId() : null;
    }
    
    public void setStatementResultInfos(List<StatementResultInfo> statementResultInfos) {
        this.statementResultInfos = statementResultInfos;
    }
    
    // ==== DocumentListOtherVersionInfo =====
    
    public void setIsReleasedVersionOfRevision(boolean isReleasedVersionOfRevision) {
        this.isReleasedVersionOfRevision = isReleasedVersionOfRevision;
    }
    
    public boolean getIsReleasedVersionOfRevision() {
        return this.isReleasedVersionOfRevision;
    }
    
    public void setOtherVersionInfos(List<DocumentListOtherVersionInfo> otherVersionInfos) {
        this.otherVersionInfos = otherVersionInfos;
        
        Collections.sort(this.otherVersionInfos, new Comparator<DocumentListOtherVersionInfo>() {
            public int compare(DocumentListOtherVersionInfo o1, DocumentListOtherVersionInfo o2) {
                Double uploadedOne = o1.getDocumentVersionUploaded();
                Double uploadedTwo = o2.getDocumentVersionUploaded();
                if (Math.abs(uploadedOne - uploadedTwo) < 1e-9) {
                    return 0;                    
                } else if (uploadedOne < uploadedTwo) {
                    return -1;
                } else {
                    return 1;
                }
            }
        });
        
        this.idToOtherVersionInfo = new HashMap<Long, DocumentListOtherVersionInfo>();
        this.idToCellResultInfo = new HashMap<Long, DocumentListOtherVersionCellResultInfo>();
        for (DocumentListOtherVersionInfo otherVersionInfo : otherVersionInfos) {
            Long documentVersionId = otherVersionInfo.getDocumentVersionId();
            this.idToOtherVersionInfo.put(documentVersionId, otherVersionInfo);
            for (DocumentListOtherVersionCellResultInfo cellResultInfo : otherVersionInfo.getCellResultInfos()) {
                Long cellResultId = cellResultInfo.getCellResultId();
                this.idToCellResultInfo.put(cellResultId, cellResultInfo);
            }
        }
    }       

    public DocumentListOtherVersionInfo getLastOtherVersionInfo() {
        return this.otherVersionInfos.size() > 0 ? this.otherVersionInfos.get(this.otherVersionInfos.size() - 1) : null;              
    }
    
    public DocumentListOtherVersionInfo getOtherVersionInfoById(Long documentVersionId) {
        if (documentVersionId != null) {
            for (DocumentListOtherVersionInfo otherVersionInfo : this.otherVersionInfos) {
                Long candidateId = otherVersionInfo.getDocumentVersionId();
                if (candidateId != null && candidateId.longValue() == documentVersionId.longValue()) {
                    return otherVersionInfo;
                }
            }    
        }
        
        return null;
    }
    
    public boolean isLastVersion() {
        return this.isLastOtherVersionId(this.getDocumentVersionId());
    }
    
    public boolean isLastOtherVersionId(Long documentVersionId) {
        DocumentListOtherVersionInfo lastVersionInfo = this.getLastOtherVersionInfo();
        if (lastVersionInfo != null) {
            Long reactivatedVersionId = lastVersionInfo.getDocumentVersionReactivatedVersionId();
            if (reactivatedVersionId != null) {
                lastVersionInfo = this.getOtherVersionInfoById(reactivatedVersionId);
            }
            if (lastVersionInfo != null) {
                return lastVersionInfo.getDocumentVersionId().longValue() == documentVersionId.longValue();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    // ==== DocumentListOtherVersionCellResultInfo ====
    
    public int getAllOtherVersionsCellResultCount() {
        int count = 0;
        for (DocumentListOtherVersionInfo otherVersionInfo : this.otherVersionInfos) {
            count += otherVersionInfo.getCellResultCount();
        }
        return count;
    }
    
    public List<DocumentListOtherVersionCellResultInfo> getAllCellResultInfos() {
        List<DocumentListOtherVersionCellResultInfo> cellResultInfos = new ArrayList<DocumentListOtherVersionCellResultInfo>();
        for (DocumentListOtherVersionInfo otherVersionInfo : this.otherVersionInfos) {
            cellResultInfos.addAll(otherVersionInfo.getCellResultInfos());
        }
        return cellResultInfos;
    }
    
    public DocumentListOtherVersionCellResultInfo getFirstOtherVersionActualCellResultInfo() {
        List<DocumentListOtherVersionCellResultInfo> cellResultInfos = this.getAllCellResultInfos();
        if (cellResultInfos.size() == 0) {
            return null; 
        } else {
            return cellResultInfos.get(0);
        }        
    }
    
    public DocumentListOtherVersionCellResultInfo getLastOtherVersionActualCellResultInfo() {
        List<DocumentListOtherVersionCellResultInfo> cellResultInfos = this.getAllCellResultInfos();
        if (cellResultInfos.size() == 0) {
            return null; 
        } else {
            return cellResultInfos.get(cellResultInfos.size() - 1);
        }
    }
    
    public boolean hasCellResults() {
        return !this.idToCellResultInfo.isEmpty();
    }
    
    public DocumentListOtherVersionCellResultInfo getByCellResultId(Long cellResultId) {
        return this.idToCellResultInfo.get(cellResultId);
    }
    
    public DocumentListOtherVersionNodeResultInfo getNodeResultInfoForNode(Long nodeId) {
        for (DocumentListOtherVersionCellResultInfo cellResultInfo : this.idToCellResultInfo.values()) {
            DocumentListOtherVersionNodeResultInfo nodeResultInfo = cellResultInfo.getNodeResultInfoByNodeId(nodeId);
            if (nodeResultInfo != null) {
                return nodeResultInfo;
            }
        }
        return null;
    }
    
    public Long getNodeResultIdForNode(Long nodeId) {
        DocumentListOtherVersionNodeResultInfo nodeResultInfo = this.getNodeResultInfoForNode(nodeId);
        return nodeResultInfo != null ? nodeResultInfo.getNodeResultId() : null;
    }
    
    public DocumentListOtherVersionNodeResultInfo getOwnNodeResultInfoForInstanceReleased(Long nodeInstanceReleasedId) {
        DocumentListOtherVersionInfo ownVersionInfo = this.getOtherVersionInfoById(this.getDocumentVersionId());
        if (ownVersionInfo != null) {
            return ownVersionInfo.getNodeResultInfoByNodeInstanceReleasedId(nodeInstanceReleasedId);
        }
        return null;
    }
    
    // ==== ReviewCycleInstanceReleased =====
    
    public ReviewCycleCellInstanceReleasedInfo getCellInstanceReleasedInfoByCellId(Long cellId) {
        return this.instanceReleasedInfo.getByCellId(cellId);
    }
    
    public ReviewCycleCellInstanceReleasedInfo getCellInstanceReleasedInfoByCellInstanceId(Long cellInstanceId) {
        return this.instanceReleasedInfo.getByCellInstanceId(cellInstanceId);
    }
    
    public List<ReviewCycleCellInstanceReleasedInfo> getAllCellInstanceReleasedInfos() {
        return this.instanceReleasedInfo.getAllCellInstanceReleasedInfos();
    }
    
    // ======== AttachedNodePositionInfos =======
    
    public void setAttachedNodePositionInfos(List<AttachedNodePositionInfo> attachedNodePositionInfos) {
        this.attachedNodePositionInfos = attachedNodePositionInfos;
    }
    
    public List<AttachedNodePositionInfo> getAttachedNodePositionInfos() {
        return this.attachedNodePositionInfos;
    }
    
    public String getRefString() {
        if (this.getDocumentVersionId() != null) {
            return this.getDocumentVersionName();
        } else {
            return this.getDocumentName();
        }
    }
    
    
    public void incrementOpenPositionCount() {
        this.openPositionCount++;
    }
    
    public void setSignedPositionResultCount(int signedPositionResultCount) {
        this.signedPositionResultCount = signedPositionResultCount;
    }
    
    public void incrementSignedPositionResultCount() {
        this.signedPositionResultCount++;
    }
    
    public int getOpenPositionCount() {
        return this.openPositionCount;
    }
    
    public int getSignedPositionResultCount() {
        return this.signedPositionResultCount;
    }
    
    public void registerOpenPositionParticipationString(String s) {
        this.openPositionParticipationStrings.add(s);
    }
    
    public Set<String> getOpenPositionParticipationStrings() {
        return this.openPositionParticipationStrings;
    }

    public boolean hasOpenPositionParticipationString(String s) {
        return this.openPositionParticipationStrings.contains(s);
    }

	public boolean isSelected() {
		return this.selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}

	public boolean isAlreadyCopied() {
		return this.alreadyCopied;
	}

	public void setAlreadyCopied(boolean alreadyCopied) {
		this.alreadyCopied = alreadyCopied;
	}

	public boolean isDuplicatedName() {
		return this.duplicatedName;
	}

	public void setDuplicatedName(boolean duplicatedName) {
		this.duplicatedName = duplicatedName;
	}

	public boolean isHasValidLabel() {
		return this.hasValidLabel;
	}

	public void setHasValidLabel(boolean hasValidLabel) {
		this.hasValidLabel = hasValidLabel;
	}

	public Long getReviewCycleInstanceId() {
		return this.reviewCycleInstanceId;
	}

	public void setReviewCycleInstanceId(Long reviewCycleInstanceId) {
		this.reviewCycleInstanceId = reviewCycleInstanceId;
	}

	public Long getReviewCycleId() {
		return this.reviewCycleId;
	}

	public void setReviewCycleId(Long reviewCycleId) {
		this.reviewCycleId = reviewCycleId;
	}
}
