/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */
package at.cdes.api.document.compositeDto;

public enum LabelStatus {
    OUTSIDE(-3),
    IGNORED(-2),
    UNKNOWN(-1),
    PERFECT(0),
    GOOD(1),
    DOUBTFUL(2),
    BAD(3),
    NOT_FOUND(4),
    PENDING (1000)
    ;


    private int value;

    private LabelStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LabelStatus fromValue(int value) {
        for (LabelStatus status: values()) {
            if (status.value == value) {
                return status;
            }
        }
        return null;
    }
}
