package at.cdes.api.guiService;
/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 19.11.2014
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

import java.util.List;

import at.cdes.api.compositeDto.PlanDeliverJoinCompositeDto;
import at.cdes.api.compositeDto.PlanDeliverSaveResult;
import at.cdes.api.compositeDto.PlanDeliverSearchData;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.PlanDeliverSearchModel;
import at.cdes.api.joinDto.DocumentListReleaseVersion;
import at.cdes.api.result.ResultSummary;



public interface PlanDeliverService {
    
    public List<DocumentListReleaseVersion> getDocumentListReleaseVersions(Long organisationPersonId, Long subProjectId);
    public PlanDeliverSearchData getPlanDeliverSearchData(Long organisationPersonId, Long subProjectId);
    public List<String> getPlanDeliverReleaseData(Long subProjectId);
    
    public PlanDeliverJoinCompositeDto getPlanDeliverUnreleasedJoin(PlanDeliverSearchModel searchModel);
    public PlanDeliverJoinCompositeDto getPlanDeliverReleasedJoin(PlanDeliverSearchModel searchModel);
    
    public PlanDeliverJoinCompositeDto insertDocuments(List<Document> documents, Long organisationPersonId, Long subProjectId, Long projectId, Long networkId);
    
    public PlanDeliverSaveResult savePlanDeliverCatalogue(List<Document> documents, List<Long> documentIdsToDelete, Long organisationPersonId, 
                                         Long subProjectId, Long projectId, Long networkId);
    
    public ResultSummary releasePlanDeliverCatalogue(Long organisationPersonId, Long projectId, Long subProjectId, String password, boolean updateAllDocuments);
    
    public void deleteDocument(Long organisationPersonId, Long documentId);
}
