/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.04.2017
 *
 * Author: wglas/ev-i
 * 
 ***********************************************************/

package at.cdes.api.service;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.clazzes.util.lang.Pair;

import at.cdes.api.dto.msp.MspFieldValue;
import at.cdes.api.dto.msp.MspItem;
import at.cdes.api.dto.msp.MspList;
import at.cdes.api.dto.msp.MspListField;
import at.cdes.api.dto.msp.MspResult;
import at.cdes.api.dto.msp.MspTerm;
import at.cdes.api.voc.msp.MspCheckInType;

/**
 * Remote interface for accessing Microsoft Sharepoint
 */
public interface MspService {

    List<MspItem> getProjects(); 
    
    /**
     * @param path The path of the keyURl of the project.
     * @return A hierarchical list of folders in the project.
     */
    List<MspItem> getProjectFolders(String projectPath);
    
    /**
     * @param path The path of the project to search within.
     * @param guid The GUID of the folder to search.
     * @param metaTagKeys An optional list of meta tag keys. If a key is prefixed with a hyphen,
     *              the infamous MSP prefix 'nnn;#' is removed from the received values.
     * @return A list of document MSP items.
     */
    List<MspItem> getFolderDocuments(String path, String guid, List<String> metaTagKeys);
    
    List<MspListField> getListFields(String projectPath, String listName);
    
    /**
     * Caution: This method may not be called from the web interface, because
     * an InputStream instance may not be serialized to JSON.
     * 
     * @param path The path aka the full URL of an MSP document as returned by
     *             {@link MspItem#getPath()}.
     * @return An input stream, which implicitly closes the triggered HTTP request.
     */
    InputStream readDocumentContent(String path);
    
    public MspList getListInfo(String projectPath, String listId);
    
    /**
     * 
     * @param projectPath path of the key url of the project, e.g. /projekte/PEJ305 
     * @param listName e.g. Rechte und Pflichten
     * @param items
     */
    public List<MspResult> addListItems(String projectPath, String listName, List<Map<String, String>> items);
    public List<MspResult> updateListItems(String projectPath, String listName, List<Map<String, String>> items);
    public void updateListItemRest(String projectPath, String listItemEntityTypeFullName, String listId, String itemId, Map<String, String> attributeToValue);
    public List<MspResult> callUpdateListItems(String projectPath, String listName,
                                               List<Map<String, String>> newItems,
                                               List<Map<String, String>> updateItems,
                                               List<Map<String, String>> deleteItems);
    
    public void processBatchData(String projectPath, String listName,
                                    List<Map<String, String>> newItems,
                                    List<Map<String, String>> updateItems,
                                    List<Map<String, String>> deleteItems);    
    
    
    public MspResult copyIntoItems(String sourceUrl, String destPath, InputStream dataStream, List<MspFieldValue> fieldValues);
    public Boolean checkInFile(String projectPath, String fileUrl, String comment, MspCheckInType checkInType);
    
    public String getProjectPathForListUrl(String listUrl);
    public Pair<String, String> getIdsForList(String listUrl);
    public Pair<String, String> getIdsForListItem(String url);
    public void getListCollection();
    
    /** Returns all data items of the given list.  Only the specified attributes are returned.
     */
    public List<Map<String, String>> getListData(String projectPath, String listName, String... attributes);
    
    public List<Map<String, String>> getListDataByListAndAttributeRest(String projectPath, String listId, 
                                                                       String attributeName, String attributeValue, String... attributes);

    /** Returns all data items of the given list, that match the given attributeNameToValue query map.
     *  The map translates into a query "WHERE attributeOne = valueOne AND ... AND attributeN = valueN.
     *  Only the specified attributes are returned.
     */
    public List<Map<String, String>> getListDataByStringAttributes(String projectPath, String listName, Map<String, String> attributeNameToValue, String... attributes); 
    
    public List<Map<String, String>> getListDataByMultipleAttributeValues(String projectPath, String listName, String attributeName, 
                                                                          List<String> searchedValues, String... attributes); 
    
    
    
    /** Calls https://msdn.microsoft.com/en-us/library/microsoft.sharepoint.taxonomy.webservices.taxonomyclientservice.getchildtermsintermset(v=office.14).aspx
     *  
     * @param termStoreId sspId in terms of sharepoint
     * @param termSetId termSetId in terms of sharepoint
     * @param languageId lcid in terms of sharepoint
     */
    public List<MspTerm> getChildTermsInTermSet(String projectPath, String termStoreId, String termSetId, Integer languageId);
    public List<MspTerm> getChildTermsInTerm(String projectPath, String termStoreId, String termSetId, String termId, Integer languageId);
    public List<MspTerm> getTermsById(String projectPath, Integer languageId, Integer resultCollectionSize, String termIds);
    public List<MspTerm> getTermsByLabel(String projectPath, Integer languageId, Integer resultCollectionSize, String label);
    public Map<String, MspTerm> getLabelToTerm(String projectPath, MspListField listField, Integer languageId);
    
    
    public String getTaxonomyMultiString(String projectPath, MspListField mspListField, Set<String> labels);
    public String getTaxonomyMultiStringGivenTerms(String projectPath, Map<String, MspTerm> labelToTerm, Set<String> labels);
    
    public String getPropertyFromGlobalPropertyBagRest(String attributeName);
    
    public String triggerExportPlanningNotificationOrdersToMsp(Long organisationPersonId, Long networkId, String mspProjectPath, List<Long> workflowEntityIds);
    public String triggerExportPlanningNotificationReportToMsp(Long organisationPersonId, String jobId, String mspDestUrl);
    public String triggerExportDocumentsToMspNow();
    
    public String getRelativeMspUrl(String absoluteMspUrl);
    public String getAbsoluteMspUrl(String relativeMspUrl);
    
    // base64 streaming API
    // commons codec
}
