/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.12.2016
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.sec;

import org.clazzes.util.sec.DomainPrincipal;

public class CdesChallengeLoginPrincipal implements DomainPrincipal {
    
    public static final String CDES_CHALLENGE_DOMAIN = "CDESChallenge";
    
    private String userName;
    private String prettyName;
    
    public CdesChallengeLoginPrincipal(String userName, String prettyName) {
        this.userName = userName;
        this.prettyName = prettyName;
    }    

    public String getName() {
        return CDES_CHALLENGE_DOMAIN + "/" + this.getUserName();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getDomain() {
        return null;
    }

    public String getEMailAddress() {
        return null;
    }
}
