/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */
package at.cdes.api.voc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ValueEnumHelper {
    private static final Map<Class<?>, Map<?, ?>> cache = Collections.synchronizedMap(new WeakHashMap<Class<?>, Map<?, ?>>());

    public static <T, E extends Enum<E> & ValueEnum<T>> E fromValue(Class<E> clazz, T value) {
        assert clazz.isEnum();

        Map<T, E> cachedValues = (Map<T, E>) cache.get(clazz);

        if (cachedValues == null) {
            cachedValues = new HashMap<T, E>();
            for (E member: clazz.getEnumConstants()) {
                cachedValues.put(member.getValue(), member);
            }
            cache.put(clazz, cachedValues);
        }

        return cachedValues.get(value);
    }
}
