/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 15.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotTemplateResolver {
    
    REVIEW_CYCLE ("ReviewCyclePlotProjectTemplate"),
    PROJECT_PARTICIPATION ("ProjectParticipationPlotTemplate"),
    MANUAL ("ManualPlotTemplate");
    
    private final String value;

    private PlotTemplateResolver(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlotTemplateResolver getByValue(String value) {
        if (REVIEW_CYCLE.getValue().equals(value)) {
            return REVIEW_CYCLE;
        } else if (PROJECT_PARTICIPATION.getValue().equals(value)) {
            return PROJECT_PARTICIPATION;
        } else if (MANUAL.getValue().equals(value)) {
            return MANUAL;
        } else {
            return null;
        }
    }    
}
