/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 23.02.2017
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.voc;

public enum ProjectStatus {


    ACTIVE (0),
    ARCHIVING_REQUESTED (1),
    ARCHIVED (2),
    DATA_FILES_DELETED (3),
    RESTORATION_REQUESTED (4),
    RESTORED (5),
    INACTIVE (6),
    UNFINISHED (7),
    PLANNING_NOTIFICATION_PROJECT (10);

    private final int value;

    private ProjectStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ProjectStatus fromValue(int value) {
        for (ProjectStatus status: ProjectStatus.values()) {
            if (status.getValue() == value) {
                return status;
            }
        }
        return null;
    }

}
