/**
 * ********************************************************* $Id$
 *
 * <p>Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * <p>Created: 19.11.2019
 *
 * <p>Author: wpausch/ev-i
 *
 * <p>*********************************************************
 */
package at.cdes.api.voc.action;

import java.util.HashMap;
import java.util.Map;

public enum Action {
  ADMINISTRATE_AS_BUILT_SUB_PROJECT ("administrateAsBuiltSubProject"),
  ADMINISTRATE_AS_BUILT_DOCUMENTS ("administrateAsBuiltDocuments"),
  ADMINISTRATE_CERTIFICATE("administrateCertificate"),
  ADMINISTRATE_NETWORK_PROJECT ("administrateNetworkProjects"),
  ARCHIVE_DOCUMENT_SEARCH("archiveDocumentSearch"),
  ARCHIVE_REVIEW_HISTORY("archiveReviewHistory"),
  ASSIGN_OPEN_REVIEWS_PLANNING_NOTIFICATION("assignOpenReviewsPlanningNotification"),
  CHANGE_PROJECT_ACCESS_MODE ("changeProjectAccessMode"),
  CHARGE_PLOT_ORDER("chargePlotOrder"),
  DELETE_DOCUMENT_VERSION ("deleteDocumentVersion"),
  DELETE_NETWORK("deleteNetwork"),
  DELETE_ORGANISATION("deleteOrganisation"),
  DELETE_OBJECT_PLANNER ("deleteObjectPlanner"),
  DELETE_PERSON("deletePerson"),
  DELETE_PLANNING_NOTIFICATION("deletePlanningNotification"),
  DELETE_PLANNING_NOTIFICATION_PROJECT("deletePlanningNotificationProject"),
  DELETE_PROJECT ("deleteProject"),
  DELETE_SUB_PROJECT ("deleteSubProject"),
  DELETE_TASK ("deleteTask"),
  DOCUMENT_VERSIONS_OVERVIEW("documentVersionsOverview"),
  DOCUMENT_TYPES_OVERVIEW ("documentTypesOverview"),
  DOWNLOAD_ATTACHMENT("downloadAttachment"),
  DOWNLOAD_DOCUMENT_VERSION("downloadDocumentVersion"),
  DOWNLOAD_DOCUMENT_VERSION_OP_CONTEXT("downloadDocumentVersionOPContext"),
  DOWNLOAD_PLANNING_NOTIFICATION("downloadPlanningNotification"),
  EDIT_CONSORTIUM("editConsortium"),
  EDIT_DOCUMENT_TYPE ("editDocumentType"),
  EDIT_LABEL ("editLabel"),
  EDIT_NETWORK("editNetwork"),  
  EDIT_NUMBER_FORMAT ("editNumberFormat"),
  EDIT_OBJECT_PLANNER ("editObjectPlanner"),
  EDIT_ORGANISATION("editOrganisation"),
  EDIT_ORGANISATION_PERSON("editOrganisationPerson"),
  EDIT_PERSON("editPerson"),
  EDIT_PERSONAL_DATA("editPersonalData"),
  EDIT_PLAN_DELIVER_CATALOGUE("editPlanDeliverCatalogue"),
  EDIT_PLAN_DELIVER_CATALOGUE_DATES("editPlanDeliverCatalogueDates"),
  EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT("editPlanDeliverCatalogueDatesProjCont"),
  EDIT_PLAN_DELIVER_CATALOGUE_END_DATE("editPlanDeliverCatalogueEndDate"),
  EDIT_PLAN_DELIVER_CATALOGUE_START_DATE("editPlanDeliverCatalogueStartDate"),
  EDIT_PLANNING_NOTIFICATION("editPlanningNotification"),
  EDIT_PLANNING_NOTIFICATION_ORDER("editPlanningNotificationOrder"),
  EDIT_PLANNING_NOTIFICATION_PROJECT("editPlanningNotificationProject"),
  EDIT_PROJECT("editProject"),
  EDIT_REVIEW_CYCLE ("editReviewCycle"),
  EDIT_VERSION_PARTS ("editVersionParts"),
  INSERT_NETWORK("insertNetwork"),
  INSERT_OBJECT_PLANNER("insertObjectPlanner"),
  INSERT_PROJECT("insertProject"),
  INVALIDATE_DOCUMENT("invalidateDocument"),
  INVALIDATE_DOCUMENT_OP_CONTEXT ("invalidateDocumentOPContext"),
  INVALIDATE_DOCUMENT_VERSION("invalidateDocumentVersion"),
  LABELS_OVERVIEW ("labelsOverview"),
  EDIT_SUB_PROJECT("editSubProject"),
  INSERT_SUB_PROJECT("insertSubProject"),
  EDIT_PROJECT_PARTICIPATION("editProjectParticipation"),
  INSERT_PROJECT_PARTICIPATION("insertProjectParticipation"),
  DELETE_PROJECT_PARTICIPATION("deleteProjectParticipation"),
  DELETE_ROLE ("deleteRole"),
  EDIT_OBJECT_LIST ("editObjectList"),
  EDIT_ROLE ("editRole"),
  EDIT_ROLE_ACTIONS ("editRoleActions"),
  EXPORT_DOCUMENTS_MSP("exportDocumentsMSP"),
  EXPORT_PLANNING_NOTIFICATION_ORDERS_MSP("exportPlanningNotificationOrdersMSP"),
  EXPORT_PLANNING_NOTIFICATION_REPORT_MSP("exportPlanningNotificationReportMSP"),
  EXPORT_REVIEW_CYCLE_STATUS ("exportReviewCycleStatus"),
  GENERATE_PLANNING_NOTIFICATION_REPORT("generatePlanningNotificationReport"),
  INSERT_PLANNING_NOTIFICATION_PROJECT("insertPlanningNotificationProject"),
  INSERT_ROLE ("insertRole"),
  MANAGE_ROOT_CAS ("manageRootCAs"),
  MONITOR_LATE_REVIEWS("monitorLateReviews"),
  MONITOR_OPEN_REVIEWS_PLANNING_NOTIFICATION("monitorOpenReviewsPlanningNotification"),
  OBJECT_LISTS_OVERVIEW ("objectListsOverview"),
  ORIGINAL_DOCUMENTS_OVERVIEW ("originalDocumentsOverview"),
  OVERRIDE_LATE_REVIEWS("overrideLateReviews"),
  NETWORK_GLOBAL_OVERVIEW("networksGlobalOverview"),
  NETWORK_SECTION_OVERVIEW("networkSectionOverview"),
  PLAN_DELIVER_CATALOGUE_OVERVIEW("planDeliverCatalogueOverview"),
  PLANNING_NOTIFICATION_OVERVIEW("planningNotificationOverview"),
  REVIEW_SECTION_OVERVIEW("reviewSectionOverview"),
  PLANNING_NOTIFICATION_SECTION_OVERVIEW("planningNotificationSectionOverview"),
  PROJECT_PARTICIPATIONS_OVERVIEW("projectParticipationsOverview"),
  PROJECTS_OVERVIEW("projectsOverview"),
  REACTIVATE_PREVIOUS_DOCUMENT_VERSION ("reactivatePreviousDocumentVersion"),
  REASSIGN_PLANNING_NOTIFICATION_TO_ORDER ("reassignPlanningNotificationToOrder"),
  REFERENCE_ORGANISATION("referenceOrganisation"),
  RELEASE_PLAN_DELIVER_CATALOGUE("releasePlanDeliverCatalogue"),
  RELEASE_OBJECT_LIST ("releaseObjectList"),
  REQUEST_MANUAL_PLOT_ALL_RECIPIENTS("requestManualPlotAllRecipients"),
  REQUEST_MANUAL_PLOT_ALL_RECIPIENTS_OP_CONTEXT("requestManualPlotAllRecipientsOPContext"),
  REQUEST_MANUAL_PLOT_ALL_RIGHTS("requestManualPlotAllRights"),
  REQUEST_MANUAL_PLOT_ALL_RIGHTS_OP_CONTEXT("requestManualPlotAllRightsOPContext"),
  REQUEST_MANUAL_PLOT_OWN_RECIPIENT("requestManualPlotOwnRecipient"),
  REQUEST_MANUAL_PLOT_OWN_RECIPIENT_OP_CONTEXT("requestManualPlotOwnRecipientOPContext"),
  REQUEST_ORIGINAL_DOCUMENT("requestOriginalDocument"),
  REQUEST_ORIGINAL_DOCUMENT_OP_CONTEXT("requestOriginalDocumentOPContext"),
  REVIEW_CYCLE_INSTANCES_OVERVIEW ("reviewCycleInstancesOverview"),
  REVIEW_PROTOCOL("reviewProtocoll"),
  REVIEW_PROTOCOL_OP_CONTEXT("reviewProtocollOPContext"),
  ROLES_OVERVIEW ("rolesOverview"),
  ROLES_GLOBAL_OVERVIEW("rolesGlobalOverview"),
  SHOW_CONSORTIUM("showConsortium"),
  SHOW_DOCUMENTS_OF_DELETED_OBJECT_PLANNERS("showDocumentsOfDeletedObjectPlanners"),
  SHOW_NUMBER_FORMAT ("showNumberFormat"),
  SHOW_OBJECT_PLANNER("showObjectPlanner"),
  SHOW_OBJECT_PLANNER_OP_CONTEXT("showObjectPlannerOPContext"),
  SHOW_ORGANISATION("showOrganisation"),
  SHOW_PERSON("showPerson"),
  SHOW_PROJECT("showProject"),
  SHOW_PROJECT_PARTICIPATION ("showProjectParticipation"),
  SHOW_PROJECT_PLOT_ORDERS("showProjectPlotOrders"),
  SHOW_ROLE ("showRole"),
  SUPER_ADMIN_RIGHT("superAdminRight"),
  TASKS_OVERVIEW ("tasksOverview"),
  UPLOAD_DOCUMENT("uploadDocument"),
  SHOW_PNG_PREVIEW("showPngPreview");

  private final String name;

  private Action(String name) {
    this.name = name;
  }

  public String getName() {
    return this.name;
  }

  public static Action getByName(String name) {
      return nameToAction.get(name);
  }

  private static Map<String, Action> nameToAction = new HashMap<String, Action>();

  static {
      for (Action action: Action.values()) {
          nameToAction.put(action.getName(), action);
      }
  }
}
