/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 02.02.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Set;

import at.cdes.api.compositeDto.ObjectPlannerNewDocumentInfo;
import at.cdes.api.compositeDto.ObjectShowInfo;
import at.cdes.api.debug.DebugNode;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.joinDto.ParticipationSelectionJoin;
import at.cdes.api.obj.dto.InstancePageInfo;
import at.cdes.api.obj.dto.InstanceSearchModel;
import at.cdes.api.obj.dto.ObjectInfo;
import at.cdes.api.obj.dto.ObjectListPageInfo;
import at.cdes.api.obj.dto.ObjectListSearchInfo;
import at.cdes.api.obj.dto.ObjectSaveInfo;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.api.voc.misc.SortOrder;

public interface ObjectService {
    
    
    public ObjectPlannerNewDocumentInfo getEditableObjectPlannersForSubProject(Long organisationPersonId, Long subProjectId);

    public ObjectShowInfo getObjectShowInfo(Long organisationPersonId, Long objectId, Integer version);
    public ObjectShowInfo getObjectShowInfoByDocumentVersionId(Long organisationPersonId, Long documentVersionId);
    public ObjectShowInfo getObjectShowInfoByDocumentId(Long organisationPersonId, Long documentId);    
    
    public String triggerExportObjectPlannerReleasePdf(Long loginOrganisationPersonId, Long objectId, Integer version,
                                                       Long objectPlannerReleaseId);
    public String triggerExportObjectPlannerReleasePdfByDocumentVersion(Long loginOrganisationPersonId, Long documentVersionId);
    public String triggerExportObjectPlannerReleasePdfByDocument(Long loginOrganisationPersonId, Long documentId);
    
    public String triggerExportObjectListReleasePdf(Long organisationPersonId, ObjectSearchModel searchModel, SortOrder sortOrder);
    public String triggerExportObjectListReleaseXls(Long organisationPersonId, ObjectSearchModel searchModel, SortOrder sortOrder);
    
    public ObjectListPageInfo getObjectListPageInfo(Long organisationPersonId, Long subProjectId);
    public List<ReviewCycleInstance> getReviewCycleInstancesBySubProjectWithLabelIfNecessary(Long organisationPersonId, Long subProjectId);
    public ObjectListSearchInfo getObjectListSearchInfo(Long organisationPersonId, Long subProjectId);
    public ObjectListSearchInfo getObjectListReleaseSearchInfo(Long organisationPersonId, Long objectListReleaseId);
    public List<ObjectInfo> getObjectInfos(Long organisationPersonId, ObjectSearchModel searchModel);
    public List<ObjectInfo> getObjectReleaseInfos(Long organisationPersonId, ObjectSearchModel searchModel);
    
    public void changeObjectAccess(Long organisationPersonId, Long objectId, boolean readOnly);
    public void changeObjectAccessToReadOnlyAndStopReviews(Long organisationPersonId, Long objectId, String password);
    
    public boolean hasObjectReleasedVersions(Long organisationPersonId, Long objectId);
    
    public List<String> getCodeForObjectCopy(Long organisationPersonId, Long subProjectId, List<String> origCodes, 
                                             Set<String> existingClientCodes);
    
    public List<ParticipationSelectionJoin> getObjectPlannerPlannerOptions(Long organisationPersonId, Long subProjectId);
    
    public String saveObjects(Long organisationPersonId, Long subProjectId, Long as_built_referenceId, List<ObjectSaveInfo> saveInfos);
    public List<DebugNode> releaseObjectList(Long organisationPersonId, Long subProjectId, String password);
    
    public InstancePageInfo getInstancePageInfo(Long organisationPersonId, Long subProjectId, InstanceSearchModel searchModel);
    public boolean deleteInstance(Long organisationPersonId, Long instanceId);
    public void copyInstance(Long organisationPersonId, Long instanceId);
    public void copyInstances(Long organisationPersonId, List<Long> instanceIds, Long subProjectId);
}
