/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 26.04.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.voc;

public enum LabelFontStyle {
    REGULAR (0),
    BOLD (1),
    ITALIC (2),
    BOLD_ITALIC (3);
    
    private final int value;

    private LabelFontStyle(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }
    
    public static LabelFontStyle getByValue(int value) {
        if (REGULAR.getValue() == value) {
            return REGULAR;
        } else if (BOLD.getValue() == value) {
            return BOLD;
        } else if (ITALIC.getValue() == value) {
            return ITALIC;
        } else if (BOLD_ITALIC.getValue() == value) {
            return BOLD_ITALIC;            
        } else {
            return null;
        }
    }    
}
