/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 11.11.2014
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.compositeDto;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import at.cdes.api.dto.ActionInfo;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.SubProjectType;

/** Helper dto for acquiring the whole page context information in one service call.
 */
public class PageContext implements Serializable {

    private static final long serialVersionUID = -7650938933354569155L;

    private Network network;
    private Project project;
    private SubProject subProject;
    private SubProjectType subProjectType;

    private Network planningNotificationNetwork;
    private Project planningNotificationProject;

    private OrganisationPerson organisationPerson;
    private Organisation organisation;
    private Person person;
    private String personVariablesUserLocale;

    private List<ProjectHoliday> projectHolidays;

    private Map<String, ActionInfo> actionsAllowedForProject;

    private Long gridCellLimit;
    private String cdesDojoImplBundleVersion;

    private Boolean passwordExpired;
    private Boolean userPolicyExpired;

    public Network getNetwork() {
        return this.network;
    }
    public void setNetwork(Network network) {
        this.network = network;
    }

    public Project getProject() {
        return this.project;
    }
    public void setProject(Project project) {
        this.project = project;
    }

    public SubProject getSubProject() {
        return this.subProject;
    }
    public void setSubProject(SubProject subProject) {
        this.subProject = subProject;
    }

    public SubProjectType getSubProjectType() {
        return this.subProjectType;
    }
    public void setSubProjectType(SubProjectType subProjectType) {
        this.subProjectType = subProjectType;
    }

    public Network getPlanningNotificationNetwork() {
        return this.planningNotificationNetwork;
    }
    public void setPlanningNotificationNetwork(Network planningNotificationNetwork) {
        this.planningNotificationNetwork = planningNotificationNetwork;
    }
    public Project getPlanningNotificationProject() {
        return this.planningNotificationProject;
    }
    public void setPlanningNotificationProject(Project planningNotificationProject) {
        this.planningNotificationProject = planningNotificationProject;
    }


    public OrganisationPerson getOrganisationPerson() {
        return this.organisationPerson;
    }
    public void setOrganisationPerson(OrganisationPerson organisationPerson) {
        this.organisationPerson = organisationPerson;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }
    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public Person getPerson() {
        return this.person;
    }
    public void setPerson(Person person) {
        this.person = person;
    }

    public List<ProjectHoliday> getProjectHolidays() {
        return this.projectHolidays;
    }

    public void setProjectHolidays(List<ProjectHoliday> projectHolidays) {
        this.projectHolidays = projectHolidays;
    }

    public Map<String, ActionInfo> getActionsAllowedForProject() {
        return this.actionsAllowedForProject;
    }

    public void setActionsAllowedForProject(Map<String, ActionInfo> actionsAllowedForProject) {
        this.actionsAllowedForProject = actionsAllowedForProject;
    }

    public Long getGridCellLimit() {
        return this.gridCellLimit;
    }

    public void setGridCellLimit(Long gridCellLimit) {
        this.gridCellLimit = gridCellLimit;
    }

    public String getCdesDojoImplBundleVersion() {
        return this.cdesDojoImplBundleVersion;
    }
    public void setCdesDojoImplBundleVersion(String cdesDojoImplBundleVersion) {
        this.cdesDojoImplBundleVersion = cdesDojoImplBundleVersion;
    }
    /**
     * @return the personVariablesUserLocale
     */
    public String getPersonVariablesUserLocale() {
        return this.personVariablesUserLocale;
    }
    /**
     * @param personVariablesUserLocale the personVariablesUserLocale to set
     */
    public void setPersonVariablesUserLocale(String personVariablesUserLocale) {
        this.personVariablesUserLocale = personVariablesUserLocale;
    }
    public Boolean getPasswordExpired() {
        return passwordExpired;
    }
    public void setPasswordExpired(Boolean passwordExpired) {
        this.passwordExpired = passwordExpired;
    }
    public Boolean getUserPolicyExpired() {
        return userPolicyExpired;
    }
    public void setUserPolicyExpired(Boolean userPolicyExpired) {
        this.userPolicyExpired = userPolicyExpired;
    }
}
