/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 18.05.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.compositeDto;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.joinDto.PlotOrderZipExportJoin;

public class PlotOrderItemData {

    private PlottOrderItem plotOrderItem;
    private PlottProperties plotProperties;
    private OrderAddress deliveryAddress;
    private Country deliveryCountry;
    private DocumentVersion documentVersion;
    private Document document;
    
    public PlotOrderItemData(PlotOrderZipExportJoin join) {
        this.plotOrderItem = join.getPlotOrderItem();
        this.plotProperties = join.getPlotProperties();
        this.deliveryAddress = join.getDeliveryAddress();
        this.deliveryCountry = join.getDeliveryCountry();
        this.documentVersion = join.getDocumentVersion();
        this.document = join.getDocument();
    }
    
    public PlottOrderItem getPlotOrderItem() {
        return this.plotOrderItem;
    }
    
    public PlottProperties getPlotProperties() {
        return this.plotProperties;
    }
    
    public OrderAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }
    
    public Country getDeliveryCountry() {
        return this.deliveryCountry;
    }
    
    public DocumentVersion getDocumentVersion() {
        return this.documentVersion;
    }
    
    public Document getDocument() {
        return this.document;
    }
}
