package at.cdes.api.sec;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Signature;

public interface SignatureCalculator {
	
	/**
	 * create a new signature object.
	 * 
	 * @param pp
	 *            the signer, may be null
	 * @param content
	 *            the content to sign
	 * @param cert
	 *            the certificate to sign
	 * @param password
	 *            the password to unlock the certificate's private key
	 * @return returns a new CDESSignature object
	 * @throws SignatureCalculatorException
	 * @throws WrongPasswordException
	 *             if the password was wrong
	 */
	public Signature createSignature(ProjectParticipant pp, String content, Certificate cert, String password);
	
	public Signature createSignature(Long projectParticipantId, String content, Certificate cert, String password);

	/**
	 * verify a given CDESSignature, the object should contain the content, that
	 * was signed
	 * 
	 * @param sign
	 *            the CDESSignature
	 * @return true if the verification succeded, else false
	 * @throws SignatureCalculatorException
	 * @throws WrongPasswordException
	 *             if the password was wrong
	 */
	public boolean verifySignature(Signature sign);
}
