/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 29.12.2020
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.project.compositeDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.SubProject;

public class ParticipationSearchInfo {

    // PersonName
    private String personName;
    
    // Organisations
    private List<Organisation> organisations;
    
    // Persons
    private List<Person> persons;
    
    // Roles
    private List<CdesRole> cdesRoles;    
    
    // Networks
    private List<Network> networks;
    
    // Projects
    private List<Project> projects;    
    
    // SubProjects
    private List<SubProject> subProjects;
    
    // ObjectRelease
    private Map<Long, ObjectRelease> idToObjectRelease;
    private Map<Long, Set<Long>> subProjectIdToObjectReleaseIds;
    
    // ObjectPlannerRelease
    private List<ObjectPlannerRelease> objectPlannerReleases;
    
    // ObjectPlannerPositionDefinition
    private Map<Long, ObjectPlannerPositionDefinition> idToObjectPlannerPositionDefinition;
    private Map<Long, List<Long>> projectIdToObjectPlannerPositionDefinitionIds;
    
    // ReviewCycleInstanceReleased
    private List<ReviewCycleInstanceReleased> reviewCycleInstanceReleaseds;
    
    // ReviewCycle
    private Map<Long, ReviewCycle> idToReviewCycle;
    private Map<Long, List<Long>> networkIdToReviewCycleIds;
    
    // ReviewCycleCell
    private List<ReviewCycleCell> reviewCycleCells;
    
    // ReviewCycleNode
    private List<ReviewCycleNode> reviewCycleNodes;
    
    // Realm
    private List<Realm> realms;

    public List<Network> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<Network> networks) {
        this.networks = networks;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public List<Organisation> getOrganisations() {
        return this.organisations;
    }

    public void setOrganisations(List<Organisation> organisations) {
        this.organisations = organisations;
    }

    public List<CdesRole> getCdesRoles() {
        return this.cdesRoles;
    }

    public void setCdesRoles(List<CdesRole> cdesRoles) {
        this.cdesRoles = cdesRoles;
    }

    public List<Person> getPersons() {
        return this.persons;
    }

    public void setPersons(List<Person> persons) {
        this.persons = persons;
    }

    public List<SubProject> getSubProjects() {
        return this.subProjects;
    }

    public void setSubProjects(List<SubProject> subProjects) {
        this.subProjects = subProjects;
    }

    public Map<Long, ObjectRelease> getIdToObjectRelease() {
        return this.idToObjectRelease;
    }

    public void setIdToObjectRelease(Map<Long, ObjectRelease> idToObjectRelease) {
        this.idToObjectRelease = idToObjectRelease;
    }

    public Map<Long, Set<Long>> getSubProjectIdToObjectReleaseIds() {
        return this.subProjectIdToObjectReleaseIds;
    }

    public void setSubProjectIdToObjectReleaseIds(Map<Long, Set<Long>> subProjectIdToObjectReleaseIds) {
        this.subProjectIdToObjectReleaseIds = subProjectIdToObjectReleaseIds;
    }

    public List<ObjectPlannerRelease> getObjectPlannerReleases() {
        return this.objectPlannerReleases;
    }

    public void setObjectPlannerReleases(List<ObjectPlannerRelease> objectPlannerReleases) {
        this.objectPlannerReleases = objectPlannerReleases;
    }

    public Map<Long, ObjectPlannerPositionDefinition> getIdToObjectPlannerPositionDefinition() {
        return this.idToObjectPlannerPositionDefinition;
    }

    public void setIdToObjectPlannerPositionDefinition(Map<Long, ObjectPlannerPositionDefinition> idToObjectPlannerPositionDefinition) {
        this.idToObjectPlannerPositionDefinition =
                idToObjectPlannerPositionDefinition;
    }

    public Map<Long, List<Long>> getProjectIdToObjectPlannerPositionDefinitionIds() {
        return this.projectIdToObjectPlannerPositionDefinitionIds;
    }

    public void setProjectIdToObjectPlannerPositionDefinitionIds(Map<Long, List<Long>> projectIdToObjectPlannerPositionDefinitionIds) {
        this.projectIdToObjectPlannerPositionDefinitionIds =
                projectIdToObjectPlannerPositionDefinitionIds;
    }

    public List<ReviewCycleInstanceReleased> getReviewCycleInstanceReleaseds() {
        return this.reviewCycleInstanceReleaseds;
    }

    public void setReviewCycleInstanceReleaseds(List<ReviewCycleInstanceReleased> reviewCycleInstanceReleaseds) {
        this.reviewCycleInstanceReleaseds = reviewCycleInstanceReleaseds;
    }

    public Map<Long, ReviewCycle> getIdToReviewCycle() {
        return this.idToReviewCycle;
    }

    public void setIdToReviewCycle(Map<Long, ReviewCycle> idToReviewCycle) {
        this.idToReviewCycle = idToReviewCycle;
    }

    public Map<Long, List<Long>> getNetworkIdToReviewCycleIds() {
        return this.networkIdToReviewCycleIds;
    }

    public void setNetworkIdToReviewCycleIds(Map<Long, List<Long>> networkIdToReviewCycleIds) {
        this.networkIdToReviewCycleIds = networkIdToReviewCycleIds;
    }

    public List<ReviewCycleCell> getReviewCycleCells() {
        return this.reviewCycleCells;
    }

    public void setReviewCycleCells(List<ReviewCycleCell> reviewCycleCells) {
        this.reviewCycleCells = reviewCycleCells;
    }

    public List<ReviewCycleNode> getReviewCycleNodes() {
        return this.reviewCycleNodes;
    }

    public void setReviewCycleNodes(List<ReviewCycleNode> reviewCycleNodes) {
        this.reviewCycleNodes = reviewCycleNodes;
    }

    public List<Realm> getRealms() {
        return this.realms;
    }

    public void setRealms(List<Realm> realms) {
        this.realms = realms;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
}
