/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 24.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum OrderAddressType {
    AUTOMATIC (0),
    MANUAL (1);
    
    private final int value;

    private OrderAddressType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static OrderAddressType getByValue(int value) {
        if (AUTOMATIC.getValue() == value) {
            return AUTOMATIC;
        } else if (MANUAL.getValue() == value) {
            return MANUAL;
        } else {
            return null;
        }
    }    
}
