/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 02.04.2017
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;

import org.clazzes.util.lang.Pair;

import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.Localisation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ParticipationListJoin;
import at.cdes.api.joinDto.ProjectParticipantHistoryPartJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.project.compositeDto.OrganisationParticipationEditInfo;
import at.cdes.api.project.compositeDto.ParticipantInfo;
import at.cdes.api.project.compositeDto.ParticipationDeleteInfo;
import at.cdes.api.project.compositeDto.ParticipationPageEditInfo;
import at.cdes.api.project.compositeDto.ParticipationPageInfo;
import at.cdes.api.project.compositeDto.ParticipationPageSearchInfo;
import at.cdes.api.project.compositeDto.ParticipationSearchInfo;
import at.cdes.api.project.compositeDto.ParticipationSecurityInfo;
import at.cdes.api.project.compositeDto.ProjectInfo;
import at.cdes.api.project.compositeDto.ProjectListPageInfo;
import at.cdes.api.project.compositeDto.ProjectPageInfo;
import at.cdes.api.project.compositeDto.ProjectPageSearchInfo;
import at.cdes.api.project.compositeDto.ProjectSaveInfo;
import at.cdes.api.project.compositeDto.RoleConflictInfo;
import at.cdes.api.project.compositeDto.SubProjectEditInfo;
import at.cdes.api.project.searchModel.ParticipationPageSearchModel;
import at.cdes.api.project.searchModel.ProjectPageSearchModel;
import at.cdes.api.project.searchModel.ProjectParticipationSearchModel;
import at.cdes.api.voc.project.ProjectAccess;

public interface ProjectService {
    public ParticipationSearchInfo getParticipationSearchInfo(Long organisationPersonId, Long personId);
    public List<ProjectParticipationJoin> getParticipationJoins(Long organisationPersonId, Long roleTypeId, List<Long> projectIds);
    public List<ProjectParticipationJoin> getParticipationJoinsByIds(Long organisationPersonId, List<Long> projectParticipationIds);
    public List<ParticipationListJoin> getParticipationListJoins(Long organisationPersonId, ProjectParticipationSearchModel searchModel);
    public List<ProjectParticipantHistoryPartJoin> getParticipantHistoryPartJoins(Long organisationPersonId, Long participationId);
    public List<Project> getValidProjectsByNetworkId(Long networkId, boolean buekMode);
    public List<Project> getValidProjectsByNetworkIdAndOrgPersonId(Long networkId, Long organisationPersonId, boolean buekMode);
    public List<ContextJoin> getCopyContextJoinsByNetworkId(Long organisationPersonId, Long networkId);
    public List<SubProject> getValidSubProjectsByProjectId(Long projectId, Long activeOrganisationPersonId);
    public SubProjectEditInfo getSubProjectEditInfo(Long organisationPersonId, Long projectId, Long subProjectId);    
    public SubProject saveSubProject(Long organisationPersonId, SubProject subProject);
    public Project saveProject(Long organisationPersonId, ProjectSaveInfo info);
    public SubProject setSubProjectAccess(Long organisationPersonId, Long subProjectId, boolean readOnly);
    public void deleteSubProject(Long organisationPersonId, Long subProject);
    public void deleteProject(Long organisationPersonId, Long projectId);

    public ProjectPageInfo getProjectCreateInfo(Long organisationPersonId, Long networkId);
    public ProjectPageInfo getProjectEditInfo(Long organisationPersonId, Long projectId);
    public List<DocumentNumberPartGroup> getDocumentNumberPartGroups(Long networkId);
    public List<ReviewCycleResultOption> getReviewCycleResultOptions(Long networkId);
    public List<Localisation> getLocalisations();

    public ParticipationSecurityInfo getParticipationSecurityInfo(Long organisationPersonId, Long projectId);
    public ParticipationPageSearchInfo getParticipationPageSearchInfo(Long projectId);
    public ParticipationPageEditInfo getParticipationPageEditInfo(Long projectId);
    public ParticipationPageInfo getParticipationPageInfo(Long organisationPersonId,
                                                          ParticipationPageSearchModel searchModel);
    public void saveParticipationPageInfo(Long projectId, Long organisationPersonId, OrganisationParticipationEditInfo info);
    public void saveParticipationComment(Long organisationPersonId, Long participationId, String comment);
    public void saveSubProjectRestrictions(Long organisationPersonId, Long projectParticipationId, List<Long> allowedSubProjectIds);
    public boolean mayAddSubProjectRestriction(Long organisationPersonId, Long participationId, Long subProjectId);
    public RoleConflictInfo getRoleConflictInfo(Long organisationPersonId, OrganisationParticipationEditInfo editInfo,
                                                Long organisationId, Long projectId);
    public void deleteDeputy(Long organisationPersonId, Long participantId);
    public ParticipantInfo insertDeputy(Long organisationPersonId, Long deputyOrganisationPersonId, Long projectParticipationId);
    public ParticipantInfo insertMeAsDeputy(Long organisationPersonId, Long projectParticipationId);
    public void deleteParticipationWithRelationsById(Long organisationPersonId, Long projectParticipationId);
    public void deleteParticipationWithRelationsByOrganisation(Long organisationPersonId, Long projectId, Long organisationId);
    public void deleteParticipationById(Long organisationPersonId, Long projectParticipationId);
    public void deleteParticipationByOrganisation(Long organisationPersonId, Long organisationId, Long projectId);
    public String getDeleteParticipationMessageByOrganisation(Long organisationPersonId, Long projectId, Long organisationId);
    public String getDeleteParticipationMessageByParticipation(Long organisationPersonId, Long projectParticipationId);

    public ParticipationDeleteInfo getDeleteParticipationInfoByOrganisation(Long organisationPersonId, Long projectId, Long organisationId);
    public ParticipationDeleteInfo getDeleteParticipationInfoByParticipation(Long organisationPersonId, Long projectParticipationId);    

    public ProjectListPageInfo getProjectListPageInfo(Long organisationPersonId, Long networkId);
    public List<ProjectInfo> getProjectInfos(Long organisationPersonId, ProjectPageSearchModel searchModel);
    public ProjectPageSearchInfo getProjectPageSearchInfo(Long organisationPersonId);
    public void makeProjectAdmin(Long organisationPersonId, Long projectId);
    public void setProjectAccess(Long organisationPersonId, Long projectId, ProjectAccess projectAccess);

    public Project getById(Long projectId);
    public List<Project> getByCode(String code, Long networkId);
    public List<Project> getByMasterDataSet(Long organisationPersonId, Long masterDataSetId);

    public boolean hasDocuments(Long projectId);

    public String triggerExportParticipationPdf(Long organisationPersonId,
                                                ParticipationPageSearchModel searchModel,
                                                Map<String, Double> columnToWidth,
                                                List<Pair<String, Boolean>> sortColumns);


}
