/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 31.01.2023
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.obj.voc;

public enum ObjectChanged {
    
    UNCHANGED (0),
    CHANGED (1),
    NEW (2);
    
    private final int value;

    private ObjectChanged(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }    
    
    public static ObjectChanged getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value.intValue() == UNCHANGED.value) {
            return UNCHANGED;
        } else if (value.intValue() == CHANGED.value) {
            return CHANGED;
        } else if (value.intValue() == NEW.value) {
            return NEW;
        } else {
            throw new IllegalArgumentException("value [" + value + "] is not part of Enum ObjectChanged.");
        }
    }

}
