/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.Signature;
import at.cdes.api.review.compositeDto.INodePositionReleasedInfo;

public class DocumentListOtherVersionNodeResultInfo {

    private ReviewCycleNode node;
    private ReviewCycleNodeResult nodeResult;
    
    /** Reached directly via Document --...--> ObjectPlannerRelease --> ReviewCycleInstanceReleased */
    private ReviewCycleNodeInstanceReleased nodeInstanceReleased;          
    
    /** Reached via ReviewCycleNodeResult --> DepartureObjectListRelease --> ... */
    private ReviewCycleNodeInstanceReleased departureNodeInstanceReleased;
    private Signature departureObjectListReleaseSignature;
    
    private List<DocumentListOtherVersionPositionResultInfo> positionResultInfos;
    
    // Old at.cdes.bo.data.cycle.node.ReviewCycleNode.isEndNode()
    // Refers to: The corresponding ReviewCyclePositionType has no ReviewCycleResultOptions
    private boolean endNode;

    // =================== ReviewCycleNode ================
    public void setNode(ReviewCycleNode node) {
        this.node = node;
    }
    
    public Long getNodeId() {
        return this.node.getId();
    }
    
    public boolean isNodeFree() {
        return this.node.isFree() != null && this.node.isFree().booleanValue();
    }
    
    public Integer getNodePosition() {
        return this.node.getPosition();
    }
    
    public boolean isEndNode() {
        return this.endNode;
    }
    
    // ================ ReviewCycleNodeResult =============
    public void setNodeResult(ReviewCycleNodeResult nodeResult) {
        this.nodeResult = nodeResult;
    }
    
    public Long getNodeResultId() {
        return this.nodeResult.getId();
    }
    
    public Double getNodeResultArrivalDate() {
        return this.nodeResult.getArrivalDate();
    }
    
    public Double getNodeResultDepartureDate() {
        return this.nodeResult.getDepartureDate();
    }
    
    public boolean isNodeResultFinished() {
        return this.nodeResult.isFinished() != null && this.nodeResult.isFinished().booleanValue();
    }
    
    public Long getNodeResultResultOptionId() {
        return this.nodeResult.getReviewCycleResultOptionId();
    }    
    
    public Long getNodeResultCellResultId() {
        return this.nodeResult.getReviewCycleCellResultId();
    }
    
    // ============ DepartureObjectListReleaseSignature =======
    
    public void setDepartureObjectListReleaseSignature(Signature signature) {
        this.departureObjectListReleaseSignature = signature;
    }
    
    public Long getDepartureObjectListReleaseSignatureId() {
        return this.departureObjectListReleaseSignature != null ? this.departureObjectListReleaseSignature.getId() : null;
    }
    
    public Double getDepartureObjectListReleaseSignatureTime() {
        return this.departureObjectListReleaseSignature != null ? this.departureObjectListReleaseSignature.getTime() : null;
    }
    
    // ================= ReviewCycleNodeInstanceReleased ======
    
    public void setReviewCycleNodeInstanceReleased(ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        this.nodeInstanceReleased = nodeInstanceReleased;
    }
    
    public Long getNodeInstanceReleasedId() {
        return this.nodeInstanceReleased != null ? this.nodeInstanceReleased.getId() : null;
    }
    
    public Integer getNodeInstanceReleasedDuration() {
        return this.nodeInstanceReleased != null ? this.nodeInstanceReleased.getDuration() : null;
    }
    
    // ================= DepartureReviewCycleNodeInstanceReleased =======
    
    public void setDepartureNodeInstanceReleased(ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        this.departureNodeInstanceReleased = nodeInstanceReleased;
    }
    
    public Integer getDepartureNodeInstanceReleasedDuration() {
        return this.departureNodeInstanceReleased != null ? this.departureNodeInstanceReleased.getDuration() : null;
    }
    
    // ==================== PositionResultInfos ===============
    
    public void setPositionResultInfos(List<DocumentListOtherVersionPositionResultInfo> positionResultInfos) {
        this.positionResultInfos = positionResultInfos;
        
        Collections.sort(this.positionResultInfos, new Comparator<DocumentListOtherVersionPositionResultInfo>() {
            public int compare(DocumentListOtherVersionPositionResultInfo o1, DocumentListOtherVersionPositionResultInfo o2) {
                double resultDateOne = o1.getPositionResultResultDate() != null ? o1.getPositionResultResultDate() : 0d;
                double resultDateTwo = o2.getPositionResultResultDate() != null ? o2.getPositionResultResultDate() : 0d;
                if (Math.abs(resultDateOne - resultDateTwo) < 1e-9) {
                    return 0;                    
                } else if (resultDateOne < resultDateTwo) {
                    return -1;
                } else {
                    return 1;
                }
            }
        });        
    }
    
    public List<DocumentListOtherVersionPositionResultInfo> getAllPositionResultInfos() {
        return this.positionResultInfos;
    }
    
    public boolean hasPositionResults() {
        return this.positionResultInfos.size() > 0;
    }
    
    public DocumentListOtherVersionPositionResultInfo getLastPositionResultInfo() {
        return this.positionResultInfos.size() > 0 ? this.positionResultInfos.get(this.positionResultInfos.size() - 1) : null;
    }
    
    public boolean isFinished(INodePositionReleasedInfo nodePositionReleasedInfo) {
        // Finished, if a PositionResult
        // - having a Signature, and
        // - having a Digest ---> Ignored, hopefully not relevant
        // - having no commentReference
        // - with matching Participation and Realm exists.
        
        Long refParticipationId = nodePositionReleasedInfo.getParticipationId();
        Long refRealmId = nodePositionReleasedInfo.getRealmId();
        
        for (DocumentListOtherVersionPositionResultInfo positionResultInfo : this.positionResultInfos) {
            Long signatureId = positionResultInfo.getSignatureId();
            Long commentReferenceId = positionResultInfo.getCommentReferenceId();
            Long participationId = positionResultInfo.getParticipationId();
            Long realmId = positionResultInfo.getRealmId();
            
            if (signatureId != null && commentReferenceId == null 
                    && participationId.longValue() == refParticipationId.longValue()
                    && realmId.longValue() == refRealmId.longValue()) {
                return true;
            }
        }
        
        return false;
    }
}
