/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 23.05.2018
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.planning.voc;

public enum DueDateRemarkOption {

    BEFORE_CONSTRUCTION ("beforeConstruction"),
    WHILE_CONSTRUCTION ("whileConstruction"),
    DURING_CONSTRUCTION ("duringConstruction"),
    BEFORE_STARTING ("beforeStarting"),
    AFTER_CONSTRUCTION ("afterConstruction"),
    IN_OPERATION ("inOperation"),
    TILL_OPERATION_APPROVAL ("tillOperationApproval");    
    
    private final String value;
    
    private DueDateRemarkOption(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return this.value;
    }    
    
    public static DueDateRemarkOption getByValue(String value) {
        if (value == BEFORE_CONSTRUCTION.getValue()) {
            return BEFORE_CONSTRUCTION;
        } else if (value == WHILE_CONSTRUCTION.getValue()) {
            return WHILE_CONSTRUCTION;
        } else if (value == DURING_CONSTRUCTION.getValue()) {
            return DURING_CONSTRUCTION;
        } else if (value == BEFORE_STARTING.getValue()) {
            return BEFORE_STARTING;
        } else if (value == AFTER_CONSTRUCTION.getValue()) {
            return AFTER_CONSTRUCTION;
        } else if (value == IN_OPERATION.getValue()) {
            return IN_OPERATION;        
        } else if (value == TILL_OPERATION_APPROVAL.getValue()) {
            return TILL_OPERATION_APPROVAL;                  
        } else {
            return null;
        }
    }    
}
