/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 26.04.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.voc;

public enum LabelAlignment {
    LEFT (0),
    CENTER (1),
    RIGHT (2);
    
    private final int value;

    private LabelAlignment(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }
    
    public static LabelAlignment getByValue(int value) {
        if (LEFT.getValue() == value) {
            return LEFT;
        } else if (CENTER.getValue() == value) {
            return CENTER;
        } else if (RIGHT.getValue() == value) {
            return RIGHT;
        } else {
            return null;
        }
    }    
}
