/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.batik;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.svggen.font.Font;
import org.apache.batik.svggen.font.table.CmapFormat;
import org.apache.batik.svggen.font.table.KernSubtable;
import org.apache.batik.svggen.font.table.KernTable;
import org.apache.batik.svggen.font.table.KerningPair;
import org.apache.batik.svggen.font.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatikFont {
    private static final Logger log = LoggerFactory.getLogger(BatikFont.class);
    final Font font;
    final Map<Long, KerningPair> kernMap;
    final CmapFormat unicodeMap;

    private static Long makeKey(int i0, int i1) {
        return (long)i0 | (long)i1 << 32;
    }

    public BatikFont(String path) {
        this.font = Font.create((String)path);
        Table table = this.font.getTable(1801810542);
        if (table instanceof KernTable) {
            KernTable kt = (KernTable)table;
            if (kt.getSubtableCount() > 0) {
                KernSubtable st = kt.getSubtable(0);
                int n = st.getKerningPairCount();
                this.kernMap = new HashMap<Long, KerningPair>(n);
                for (int i = 0; i < n; ++i) {
                    KerningPair kp = st.getKerningPair(i);
                    Long key = BatikFont.makeKey(kp.getLeft(), kp.getRight());
                    this.kernMap.put(key, kp);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Found [" + this.kernMap.size() + "] kern pairs in font file [" + path + "].");
                }
            } else {
                this.kernMap = null;
            }
        } else {
            this.kernMap = null;
        }
        this.unicodeMap = this.font.getCmapTable().getCmapFormat((short)3, (short)1);
    }

    public KerningPair findKernPair(int left, int right) {
        if (this.kernMap == null) {
            return null;
        }
        return this.kernMap.get(BatikFont.makeKey(left, right));
    }

    public short getKernValue(int left, int right) {
        KerningPair kp = this.findKernPair(left, right);
        return kp == null ? (short)0 : kp.getValue();
    }

    public int getGlyphId(int charCode) {
        return this.unicodeMap.mapCharCode(charCode);
    }

    public Font getFont() {
        return this.font;
    }
}

