/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.batik.impl;

import at.cdes.batik.BatikFont;
import at.cdes.batik.BatikFontCache;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.NameTable;
import org.apache.batik.svggen.font.table.TableDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatikFontCacheImpl
implements BatikFontCache {
    private static final Logger log = LoggerFactory.getLogger(BatikFontCacheImpl.class);
    private static final FileFilter FILE_FILTER_INSTANCE = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && pathname.canRead() && (pathname.getName().endsWith(".ttf") || pathname.getName().endsWith(".TTF"));
        }
    };
    public static final String DEFAULT_FONT_PATH;
    private String fontPath = DEFAULT_FONT_PATH;
    private Map<String, CacheEntry> fontCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseFontName(File file) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            TableDirectory td = new TableDirectory(raf);
            DirectoryEntry ne = td.getEntryByTag(1851878757);
            if (ne == null) {
                throw new IOException("TTF file [" + file + "] does not contain a name table.");
            }
            NameTableImpl nt = new NameTableImpl(ne, raf);
            String name = nt.getRecord((short)4);
            if (name == null) {
                throw new IOException("TTF file [" + file + "] does not contain a full font name.");
            }
            String string = name;
            return string;
        }
    }

    private void scanFontDir(File fontDir) {
        File[] ttfFiles;
        if (fontDir.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug("Scanning font directory [" + fontDir + "]...");
            }
        } else {
            if (log.isDebugEnabled()) {
                if (fontDir.exists()) {
                    log.debug("Font directory [" + fontDir + "] exists, but is not a directory.");
                } else {
                    log.debug("Font directory [" + fontDir + "] does not exist.");
                }
            }
            return;
        }
        int isize = this.fontCache.size();
        for (File ttfFile : ttfFiles = fontDir.listFiles(FILE_FILTER_INSTANCE)) {
            if (ttfFile.isDirectory()) {
                this.scanFontDir(ttfFile);
                continue;
            }
            try {
                String name = BatikFontCacheImpl.parseFontName(ttfFile);
                if (log.isDebugEnabled()) {
                    log.debug("Font [" + name + "] found in file [" + ttfFile + "].");
                }
                this.fontCache.put(name, new CacheEntry(ttfFile));
            }
            catch (Throwable t) {
                log.warn("Error parsing TTF font file [" + ttfFile + "]", t);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Found [" + (this.fontCache.size() - isize) + "] fonts in directory [" + fontDir + "].");
        }
    }

    public void scanFontNames() {
        int pos;
        this.fontCache = new HashMap<String, CacheEntry>(256);
        int lastPos = 0;
        do {
            String fontDir_s = (pos = this.fontPath.indexOf(File.pathSeparatorChar, lastPos)) < 0 ? this.fontPath.substring(lastPos) : this.fontPath.substring(lastPos, pos);
            lastPos = pos + 1;
            File fontDir = new File(fontDir_s);
            this.scanFontDir(fontDir);
        } while (pos >= 0);
        log.info("Found [" + this.fontCache.size() + "] fonts in path [" + this.fontPath + "].");
    }

    @Override
    public BatikFont findFont(String name) {
        CacheEntry entry = this.fontCache.get(name);
        if (entry == null) {
            return null;
        }
        return entry.getFont();
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public void setFontPath(String fontPath) {
        if (fontPath != null && fontPath.length() > 0) {
            this.fontPath = fontPath;
        }
    }

    static {
        String osName = System.getProperty("os.name");
        DEFAULT_FONT_PATH = osName.toLowerCase().contains("window") ? System.getenv("SystemRoot") + "\\fonts" : "/usr/X11R6/lib/X11/fonts:/usr/share/fonts:/usr/local/share/fonts";
    }

    private static class NameTableImpl
    extends NameTable {
        protected NameTableImpl(DirectoryEntry arg0, RandomAccessFile arg1) throws IOException {
            super(arg0, arg1);
        }
    }

    private static class CacheEntry {
        public final File file;
        private BatikFont font;

        public CacheEntry(File file) {
            this.file = file;
        }

        public synchronized BatikFont getFont() {
            if (this.font == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Parsing font file [" + this.file.getAbsolutePath() + "].");
                }
                this.font = new BatikFont(this.file.getAbsolutePath());
            }
            return this.font;
        }
    }
}

