/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.batik.impl;

import at.cdes.batik.BatikFont;
import at.cdes.batik.BatikFontCache;
import at.cdes.batik.BatikSvgException;
import at.cdes.batik.BatikSvgRendererOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.svggen.font.table.HmtxTable;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class BatikSvgRendererOperationsImpl
implements BatikSvgRendererOperations {
    private BatikFontCache fontCache;

    @Override
    public double getTextWidth(String fontName, String text) throws BatikSvgException {
        BatikFont font = this.fontCache.findFont(fontName);
        if (font == null) {
            throw new BatikSvgException("Font [" + fontName + "] could not be found.");
        }
        double unitsPerEm = font.getFont().getHeadTable().getUnitsPerEm();
        HmtxTable hmtx = font.getFont().getHmtxTable();
        int left = -1;
        double w = 0.0;
        int i = 0;
        while (i < text.length()) {
            int rightCp = text.codePointAt(i);
            int right = font.getGlyphId(rightCp);
            w += (double)hmtx.getAdvanceWidth(right);
            if (left >= 0) {
                w += (double)font.getKernValue(left, right);
            }
            left = right;
            i = text.offsetByCodePoints(i, 1);
        }
        return w / unitsPerEm;
    }

    @Override
    public void renderPng(InputStream svg, OutputStream os, double width, double height, double resolution) throws BatikSvgException {
        PNGTranscoder t = new PNGTranscoder();
        float w = (float)(width * resolution / 72.0);
        float h = (float)(height * resolution / 72.0);
        t.addTranscodingHint(ImageTranscoder.KEY_WIDTH, (Object)Float.valueOf(w));
        t.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, (Object)Float.valueOf(h));
        TranscoderInput input = new TranscoderInput(svg);
        TranscoderOutput output = new TranscoderOutput(os);
        try {
            t.transcode(input, output);
            os.flush();
        }
        catch (TranscoderException e) {
            throw new BatikSvgException("transcoder exception", e);
        }
        catch (IOException e) {
            throw new BatikSvgException("I/O exception", e);
        }
    }

    public BatikFontCache getFontCache() {
        return this.fontCache;
    }

    public void setFontCache(BatikFontCache fontCache) {
        this.fontCache = fontCache;
    }
}

