/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.review;

import at.cdes.api.guiService.ReviewService;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.ReviewCycleTreeJoin;
import at.cdes.api.review.compositeDto.InstanceInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.export.review.InstanceInfoExporter;
import at.cdes.impl.reviewCycle.ReviewUtils;
import java.util.List;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;

public class InstanceInfoPdfCallable
extends HasLoggingCallable<ScratchFile> {
    private InstanceInfoExporter exporter;
    private Long loginOrganisationPersonId;
    private ReviewService reviewService;
    private Long instanceId;
    private boolean enableCustomerLogo;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewUtils reviewUtils;

    public InstanceInfoPdfCallable(InstanceInfoExporter exporter, ReviewService reviewService, OrganisationPersonDAO organisationPersonDAO, ProjectDAO projectDAO, ReviewCycleDAO reviewCycleDAO, ReviewUtils reviewUtils, Long organisationPersonId, Long instanceId, boolean enableCustomerLogo) {
        this.exporter = exporter;
        this.loginOrganisationPersonId = organisationPersonId;
        this.reviewService = reviewService;
        this.instanceId = instanceId;
        this.enableCustomerLogo = enableCustomerLogo;
        this.organisationPersonDAO = organisationPersonDAO;
        this.projectDAO = projectDAO;
        this.reviewCycleDAO = reviewCycleDAO;
        this.reviewUtils = reviewUtils;
    }

    public ScratchFile call() throws Exception {
        InstanceInfo instanceInfo = this.reviewService.getInstanceInfo(this.loginOrganisationPersonId, this.instanceId);
        OrganisationPersonJoin callingOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(this.loginOrganisationPersonId);
        String userLocale = callingOrganisationPersonJoin.getPersonVariablesUserLocale();
        Long subProjectId = instanceInfo.getContextJoin().getSubProjectId();
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        List<String> contentLocales = null;
        List<ReviewCycleTreeJoin> reviewCycleTreeJoins = this.reviewCycleDAO.getAllReviewCycleTreeJoins();
        ReviewCycleInfo cycleInfo = this.reviewUtils.constructReviewCycleInfoByTreeJoins(reviewCycleTreeJoins, userLocale, contentLocales);
        ScratchFile scratchFile = this.exporter.export(this.loginOrganisationPersonId, instanceInfo, cycleInfo, this.enableCustomerLogo);
        return scratchFile;
    }
}

