/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Action;
import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ShortObjectPlannerAction;
import at.cdes.impl.dao.GenActionDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcActionDAO
extends AbstrIdDAO<Action>
implements GenActionDAO {
    public AbstractJdbcActionDAO() {
        super(Action.class, "id", "action", new String[]{"id", "name", "description", "read_only"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcActionDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "read_only") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcActionDAO.getSelectClauseForDto("action", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcActionDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".read_only" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "read_only") + " ";
    }

    protected Action fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Action action = new Action();
        action.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        action.setName(rs.getString(++columnIndex));
        action.setDescription(rs.getString(++columnIndex));
        action.setReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return action;
    }

    public static Action fillActionFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Action action = new Action();
        action.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        action.setName(rs.getString(columnIndex.incrementAndGet()));
        action.setDescription(rs.getString(columnIndex.incrementAndGet()));
        action.setReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return action;
    }

    public static Action fillActionFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcActionDAO.fillActionFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    public static ObjectPlannerAction fillObjectPlannerActionFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectPlannerAction objectPlannerAction = new ObjectPlannerAction();
        objectPlannerAction.setActionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setActionName(rs.getString(++columnIndex));
        objectPlannerAction.setActionDescription(rs.getString(++columnIndex));
        objectPlannerAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setAdminRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setDefaultRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setDestActionRuleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setDestActionRuleDestinationContextId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setDestActionRuleCheckMember(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setGlobalRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setNetworkOrganisationOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setNetworkPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setOrgRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setPlannerRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setProjectAccess(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setProjectParticipantInactiveFlag(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        objectPlannerAction.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectPlannerAction;
    }

    public static int getNumberOfObjectPlannerActionAttributes() {
        return 21;
    }

    public static ShortObjectPlannerAction fillShortObjectPlannerActionFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ShortObjectPlannerAction shortObjectPlannerAction = new ShortObjectPlannerAction();
        shortObjectPlannerAction.setActionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        shortObjectPlannerAction.setActionName(rs.getString(++columnIndex));
        shortObjectPlannerAction.setActionDescription(rs.getString(++columnIndex));
        shortObjectPlannerAction.setActionReadOnly(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        shortObjectPlannerAction.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return shortObjectPlannerAction;
    }

    public static int getNumberOfShortObjectPlannerActionAttributes() {
        return 5;
    }

    protected String getSelectClauseForObjectPlannerActionUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("action") ? result + "action.id, action.name, action.description, action.read_only" : result + "NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("adminRole") ? result + "admin_role.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("defaultRole") ? result + "default_role.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("destActionRule") ? result + "dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("globalRole") ? result + "global_role.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("network") ? result + "network.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("networkOrganisation") ? result + "network_organisation.organisation_id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("networkPerson") ? result + "network_person.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlanner") ? result + "object_planner.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("orgRole") ? result + "org_role.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("plannerRole") ? result + "planner_role.id" : result + "NULL";
        result = result + ", ";
        result = localNamesSet.contains("project") ? result + "project.id, project.access" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipant") ? result + "project_participant.id, project_participant.inactive_flag" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("projectParticipation") ? result + "project_participation.id" : result + "NULL";
        return result;
    }

    protected String getSelectClauseForShortObjectPlannerActionUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("action") ? result + "action.id, action.name, action.description, action.read_only" : result + "NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("objectPlanner") ? result + "object_planner.id" : result + "NULL";
        return result;
    }

    public int update(Action dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Action> dtos) {
        Iterator<Action> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getObjectPlannerActionSelectClause() {
        return "action.id, action.name, action.description, action.read_only, admin_role.id, default_role.id, dest_action_rule.id, dest_action_rule.destination_context_id, dest_action_rule.check_member, global_role.id, network.id, network_organisation.organisation_id, network_person.id, object_planner.id, org_role.id, planner_role.id, project.id, project.access, project_participant.id, project_participant.inactive_flag, project_participation.id ";
    }

    public static String getPrefixedObjectPlannerActionSelectClause() {
        return "action.id AS action_id, action.name AS action_name, action.description AS action_description, action.read_only AS action_read_only, admin_role.id AS admin_role_id, default_role.id AS default_role_id, dest_action_rule.id AS dest_action_rule_id, dest_action_rule.destination_context_id AS dest_action_rule_destination_context_id, dest_action_rule.check_member AS dest_action_rule_check_member, global_role.id AS global_role_id, network.id AS network_id, network_organisation.organisation_id AS network_organisation_organisation_id, network_person.id AS network_person_id, object_planner.id AS object_planner_id, org_role.id AS org_role_id, planner_role.id AS planner_role_id, project.id AS project_id, project.access AS project_access, project_participant.id AS project_participant_id, project_participant.inactive_flag AS project_participant_inactive_flag, project_participation.id AS project_participation_id ";
    }

    public static String getShortObjectPlannerActionSelectClause() {
        return "action.id, action.name, action.description, action.read_only, object_planner.id ";
    }

    public static String getPrefixedShortObjectPlannerActionSelectClause() {
        return "action.id AS action_id, action.name AS action_name, action.description AS action_description, action.read_only AS action_read_only, object_planner.id AS object_planner_id ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Action action) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)action.getId());
        statement.setString(2, action.getName());
        statement.setString(3, action.getDescription());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)4, (Boolean)action.getReadOnly());
    }
}

