/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.joinDto.LabelJoin;
import at.cdes.impl.dao.LabelDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcLabelDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;

public class JdbcLabelDAO
extends AbstractJdbcLabelDAO
implements LabelDAO {
    @Override
    public LabelJoin getJoin(final Long labelId) {
        String sql = "SELECT " + JdbcLabelDAO.getLabelJoinSelectClause() + " FROM        label    LEFT JOIN   label_content           ON label_content.label_id = label.id  LEFT JOIN   review_cycle            ON label.review_cycle_id = review_cycle.id  WHERE       label.id = ?;";
        return (LabelJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<LabelJoin>(){

            public LabelJoin perform(PreparedStatement stmt) throws Exception {
                int currIndex = 1;
                stmt.setLong(currIndex, labelId);
                ResultSet rs = stmt.executeQuery();
                LabelJoin join = null;
                if (rs.next()) {
                    join = AbstractJdbcLabelDAO.fillLabelJoinFromResultSet(rs);
                }
                return join;
            }
        });
    }

    @Override
    public List<LabelJoin> getJoinsByOrganisation(final Long organisationId) {
        String sql = "SELECT " + JdbcLabelDAO.getLabelJoinSelectClause() + " FROM        label    LEFT JOIN   label_content           ON label_content.label_id = label.id  LEFT JOIN   review_cycle            ON label.review_cycle_id = review_cycle.id  WHERE       label.organisation_id = ?;";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<LabelJoin>>(){

            public List<LabelJoin> perform(PreparedStatement stmt) throws Exception {
                int currIndex = 1;
                stmt.setLong(currIndex, organisationId);
                ResultSet rs = stmt.executeQuery();
                ArrayList<LabelJoin> joins = new ArrayList<LabelJoin>();
                while (rs.next()) {
                    joins.add(AbstractJdbcLabelDAO.fillLabelJoinFromResultSet(rs));
                }
                return joins;
            }
        });
    }

    @Override
    public List<LabelJoin> getJoinsByReviewCycle(final Long reviewCycleId) {
        String sql = "SELECT " + JdbcLabelDAO.getLabelJoinSelectClause() + " FROM        label    LEFT JOIN   label_content           ON label_content.label_id = label.id  LEFT JOIN   review_cycle            ON label.review_cycle_id = review_cycle.id  WHERE       label.review_cycle_id = ?;";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<LabelJoin>>(){

            public List<LabelJoin> perform(PreparedStatement stmt) throws Exception {
                int currIndex = 1;
                stmt.setLong(currIndex, reviewCycleId);
                ResultSet rs = stmt.executeQuery();
                ArrayList<LabelJoin> joins = new ArrayList<LabelJoin>();
                while (rs.next()) {
                    joins.add(AbstractJdbcLabelDAO.fillLabelJoinFromResultSet(rs));
                }
                return joins;
            }
        });
    }
}

