/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkReviewCycle;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.impl.dao.NetworkReviewCycleDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcNetworkReviewCycleDAO
extends AbstrIdDAO<NetworkReviewCycle>
implements NetworkReviewCycleDAO {
    public JdbcNetworkReviewCycleDAO() {
        super(NetworkReviewCycle.class, "reviewCycleId", "network_review_cycle", new String[]{"review_cycle_id", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcNetworkReviewCycleDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcNetworkReviewCycleDAO.getSelectClauseForDto("network_review_cycle", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcNetworkReviewCycleDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".review_cycle_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "review_cycle_id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected NetworkReviewCycle fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        NetworkReviewCycle networkReviewCycle = new NetworkReviewCycle();
        networkReviewCycle.setReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkReviewCycle.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return networkReviewCycle;
    }

    public static NetworkReviewCycle fillNetworkReviewCycleFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        NetworkReviewCycle networkReviewCycle = new NetworkReviewCycle();
        networkReviewCycle.setReviewCycleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkReviewCycle.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return networkReviewCycle;
    }

    public static NetworkReviewCycle fillNetworkReviewCycleFromResultSet(ResultSet rs) throws SQLException {
        return JdbcNetworkReviewCycleDAO.fillNetworkReviewCycleFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteInstance(final Long reviewCycleId, final Long networkId) {
        String sql = "DELETE FROM network_review_cycle WHERE review_cycle_id = ? AND network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, reviewCycleId);
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(NetworkReviewCycle dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<NetworkReviewCycle> dtos) {
        Iterator<NetworkReviewCycle> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, NetworkReviewCycle networkReviewCycle) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkReviewCycle.getReviewCycleId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)networkReviewCycle.getNetworkId());
    }

    @Override
    public List<NetworkReviewCycle> getByReviewCycle(ReviewCycle reviewCycle) {
        return this.getByReviewCycle(reviewCycle.getId());
    }

    @Override
    public List<NetworkReviewCycle> getByReviewCycle(final Long reviewCycleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, reviewCycleId);
            }
        });
    }

    @Override
    public List<NetworkReviewCycle> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<NetworkReviewCycle> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<NetworkReviewCycle> getByReviewCycles(Collection<Long> reviewCycleId) {
        if (reviewCycleId.isEmpty()) {
            return new ArrayList<NetworkReviewCycle>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[reviewCycleId.size()];
        int n = 0;
        Iterator<Long> it = reviewCycleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"review_cycle_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<NetworkReviewCycle> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<NetworkReviewCycle>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

