/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.document;

import at.cdes.api.document.compositeDto.DocumentListBaseContext;
import at.cdes.api.document.compositeDto.DocumentListData;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionCellResultInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionNodeResultInfo;
import at.cdes.api.document.compositeDto.DocumentListOtherVersionPositionResultInfo;
import at.cdes.api.document.compositeDto.DocumentListRow;
import at.cdes.api.document.compositeDto.StatementResultInfo;
import at.cdes.api.document.searchModel.DocumentSearchModel;
import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.SelectCellConnectionTask;
import at.cdes.api.dto.Signature;
import at.cdes.api.joinDto.AttachedNodePositionJoin;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DocumentListJoin;
import at.cdes.api.joinDto.IDocumentListJoin;
import at.cdes.api.joinDto.NodePositionJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.review.compositeDto.AttachedNodePositionInfo;
import at.cdes.api.review.compositeDto.ReviewCycleCellInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.review.compositeDto.ReviewCycleInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleNodeInstanceReleasedInfo;
import at.cdes.api.review.compositeDto.ReviewCycleNodePositionReleasedInfo;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.AttachedReviewCycleNodePositionDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentReferenceDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.ObjectDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PlottOrderTemplateDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ReviewCycleCellResultDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeResultDAO;
import at.cdes.impl.dao.ReviewCyclePositionResultDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.SelectCellConnectionTaskDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.unionComponent.DocumentListComponent;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.document.context.GenerateTaskEmailSnippetsContextImpl;
import at.cdes.impl.reviewCycle.ReviewUtils;
import at.cdes.impl.reviewCycle.SmallReviewCycleSvgRenderer;
import at.cdes.impl.service.DocumentServiceImpl;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.BatchedDAOGetter;
import at.cdes.impl.util.BatchedDAOGetterMap;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.holiday.HolidayCalculatorFactory;
import at.cdes.impl.util.i18n.I18nHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.bouncycastle.util.encoders.Base64;
import org.clazzes.util.lang.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentUtils {
    private ActionDAO actionDAO;
    private AttachedReviewCycleNodePositionDAO attachedReviewCycleNodePositionDAO;
    private DocumentDAO documentDAO;
    private DocumentReferenceDAO documentReferenceDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentTaskDAO documentTaskDAO;
    private ObjectDAO objectDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PlottOrderTemplateDAO plotOrderTemplateDAO;
    private ProjectDAO projectDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO;
    private ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewUtils reviewUtils;
    private SelectCellConnectionTaskDAO selectCellConnectionTaskDAO;
    private SignatureCalculator signatureCalculator;
    private SignatureDAO signatureDAO;
    private int sqlQueryBatchSize;
    private SubProjectDAO subProjectDAO;
    private SmallReviewCycleSvgRenderer smallReviewCycleSvgRenderer;
    private TaskUtils taskUtils;
    private String timeZone;
    private static final Logger log = LoggerFactory.getLogger(DocumentUtils.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setAttachedReviewCycleNodePositionDAO(AttachedReviewCycleNodePositionDAO attachedReviewCycleNodePositionDAO) {
        this.attachedReviewCycleNodePositionDAO = attachedReviewCycleNodePositionDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReferenceDAO(DocumentReferenceDAO documentReferenceDAO) {
        this.documentReferenceDAO = documentReferenceDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPlotOrderTemplateDAO(PlottOrderTemplateDAO plotOrderTemplateDAO) {
        this.plotOrderTemplateDAO = plotOrderTemplateDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setReviewCycleNodeInstanceReleasedDAO(ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO) {
        this.reviewCycleNodeInstanceReleasedDAO = reviewCycleNodeInstanceReleasedDAO;
    }

    public void setReviewCycleNodePositionReleasedDAO(ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO) {
        this.reviewCycleNodePositionReleasedDAO = reviewCycleNodePositionReleasedDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    public void setReviewUtils(ReviewUtils reviewUtils) {
        this.reviewUtils = reviewUtils;
    }

    public void setSelectCellConnectionTaskDAO(SelectCellConnectionTaskDAO selectCellConnectionTaskDAO) {
        this.selectCellConnectionTaskDAO = selectCellConnectionTaskDAO;
    }

    public void setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setSmallReviewCycleSvgRenderer(SmallReviewCycleSvgRenderer smallReviewCycleSvgRenderer) {
        this.smallReviewCycleSvgRenderer = smallReviewCycleSvgRenderer;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void invalidateDocumentVersionsForObject(DebugContext debugContext, Long organisationPersonId, Long objectId, ProjectParticipant signer, Certificate certificate, String password, String comment) {
        List<DocumentVersion> documentVersions = this.documentVersionDAO.getNonDeletedVersionsForNonInvalidatedDocumentsByObject(objectId);
        this.invalidateDocumentVersions(debugContext, organisationPersonId, documentVersions, signer, certificate, password, comment);
    }

    public void invalidateDocumentVersionsForObjectPlanner(DebugContext debugContext, Long organisationPersonId, Long objectPlannerId, ProjectParticipant signer, Certificate certificate, String password, String comment) {
        List<DocumentVersion> documentVersions = this.documentVersionDAO.getNonDeletedVersionsForNonInvalidatedDocumentsByObjectPlanner(objectPlannerId);
        this.invalidateDocumentVersions(debugContext, organisationPersonId, documentVersions, signer, certificate, password, comment);
    }

    private void invalidateDocumentVersions(DebugContext debugContext, Long organisationPersonId, List<DocumentVersion> documentVersions, ProjectParticipant signer, Certificate certificate, String password, String comment) {
        for (DocumentVersion documentVersion : documentVersions) {
            Long documentVersionId = documentVersion.getId();
            DocumentListData documentListData = this.getDocumentListJoinForVersionId(organisationPersonId, documentVersionId, false);
            List resultOptions = documentListData.getResultOptions();
            HashMap<Long, ReviewCycleResultOption> idToResultOption = new HashMap<Long, ReviewCycleResultOption>();
            for (ReviewCycleResultOption resultOption : resultOptions) {
                idToResultOption.put(resultOption.getId(), resultOption);
            }
            ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
            DocumentListRow documentListRow = (DocumentListRow)documentListData.getDocumentListRows().get(0);
            Long objectPlannerId = documentListRow.getObjectPlannerId();
            ReviewCycle reviewCycle = this.reviewCycleDAO.getByObjectPlanner(objectPlannerId);
            Long documentInvalidationOptionId = reviewCycle.getDocumentInvalidationResultOptionId();
            ReviewCycleResultOption option = (ReviewCycleResultOption)idToResultOption.get(documentInvalidationOptionId);
            Boolean authorized = option.getNeedsAuthorization();
            DocumentVersionStatus documentVersionStatus = documentListRow.getDocumentVersionStatus();
            if (documentVersionStatus == DocumentVersionStatus.getByValue((Integer)option.getDocumentVersionStatus())) continue;
            this.doInvalidateDocumentVersion(debugContext, cycleInfo, idToResultOption, documentListRow, password, comment, option, signer, certificate, false, false, authorized);
        }
    }

    public void invalidateDocumentVersionForAbort(Long organisationPersonId, Long documentVersionId, ProjectParticipant participant, Certificate certificate, String password, String comment, ReviewCycleResultOption selectedResultOption) {
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Long projectId = contextJoin.getProjectId();
        Set<Action> projectActions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.INVALIDATE_DOCUMENT, Action.DELETE_DOCUMENT_VERSION);
        Set<Action> objectPlannerActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.INVALIDATE_DOCUMENT_VERSION, Action.INVALIDATE_DOCUMENT_OP_CONTEXT);
        DocumentListData documentListData = this.getDocumentListJoinForVersionId(organisationPersonId, documentVersionId, false);
        List resultOptions = documentListData.getResultOptions();
        HashMap<Long, ReviewCycleResultOption> idToResultOption = new HashMap<Long, ReviewCycleResultOption>();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            idToResultOption.put(resultOption.getId(), resultOption);
        }
        ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
        DocumentListRow documentListRow = (DocumentListRow)documentListData.getDocumentListRows().get(0);
        boolean reactivate = false;
        DebugContext debugContext = new DebugContext();
        this.doInvalidateDocumentVersion(debugContext, cycleInfo, idToResultOption, documentListRow, password, comment, selectedResultOption, participant, certificate, false, false, false);
    }

    public void invalidateDocumentVersion(Long organisationPersonId, Long documentVersionId, ProjectParticipant participant, Certificate certificate, String password, String comment, Long resultOptionId, boolean reactivateLastReleasedVersion, Boolean authorized, boolean restrictToMaxVersion) {
        boolean isDocumentDeleteOption;
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Long projectId = contextJoin.getProjectId();
        Set<Action> projectActions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.INVALIDATE_DOCUMENT, Action.DELETE_DOCUMENT_VERSION);
        Set<Action> objectPlannerActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.INVALIDATE_DOCUMENT_VERSION, Action.INVALIDATE_DOCUMENT_OP_CONTEXT);
        DocumentListData documentListData = this.getDocumentListJoinForVersionId(organisationPersonId, documentVersionId, restrictToMaxVersion);
        List resultOptions = documentListData.getResultOptions();
        HashMap<Long, ReviewCycleResultOption> idToResultOption = new HashMap<Long, ReviewCycleResultOption>();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            idToResultOption.put(resultOption.getId(), resultOption);
        }
        ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
        DocumentListRow documentListRow = (DocumentListRow)documentListData.getDocumentListRows().get(0);
        if (resultOptionId == null) {
            throw new IllegalArgumentException("A resultOptionId needs to be specified");
        }
        if (!documentListRow.hasInvalidateOption(resultOptionId)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not choose resultOptionId [" + resultOptionId + "]");
        }
        ReviewCycleResultOption resultOption = documentListRow.getInvalidateOption(resultOptionId);
        boolean isDocumentVersionInvalidateOption = resultOption.getDocumentVersionStatus() != null && resultOption.getDocumentVersionStatus().intValue() == DocumentVersionStatus.INVALIDATEDVERSION.getValue();
        boolean isDocumentInvalidateOption = resultOption.getDocumentVersionStatus() != null && resultOption.getDocumentVersionStatus().intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue();
        boolean bl = isDocumentDeleteOption = resultOption.getDocumentVersionStatus() != null && resultOption.getDocumentVersionStatus().intValue() == DocumentVersionStatus.DELETED.getValue();
        if (isDocumentInvalidateOption && !projectActions.contains(Action.INVALIDATE_DOCUMENT) && !objectPlannerActions.contains(Action.INVALIDATE_DOCUMENT_OP_CONTEXT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] lacks privileges INVALIDATE_DOCUMENT or INVALIDATE_DOCUMENT_OP_CONTEXT for documentInvalidateOption - documentVersion [" + documentVersionId + "]");
        }
        if (isDocumentVersionInvalidateOption && !projectActions.contains(Action.INVALIDATE_DOCUMENT) && !objectPlannerActions.contains(Action.INVALIDATE_DOCUMENT_VERSION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] lacks privilege INVALIDATE_DOCUMENT_VERSION or INVALIDATE_DOCUMENT for documentVersionInvalidateOption - documentVersion [" + documentVersionId + "]");
        }
        if (!isDocumentDeleteOption || !projectActions.contains(Action.DELETE_DOCUMENT_VERSION)) {
            // empty if block
        }
        boolean reactivate = reactivateLastReleasedVersion && isDocumentDeleteOption;
        DebugContext debugContext = new DebugContext();
        this.doInvalidateDocumentVersion(debugContext, cycleInfo, idToResultOption, documentListRow, password, comment, resultOption, participant, certificate, false, reactivate, authorized);
    }

    public DocumentListData getDocumentListJoinForVersionId(Long organisationPersonId, Long documentVersionId, boolean restrictToMaxVersion) {
        DocumentListRow row;
        DocumentSearchModel searchModel = new DocumentSearchModel();
        searchModel.setOrganisationPersonId(organisationPersonId);
        searchModel.setDocumentVersionId(documentVersionId);
        DocumentListData documentListData = this.doGetDocumentListJoinWithoutSecurity(searchModel, DocumentServiceImpl.DocumentListMode.INVALIDATE, restrictToMaxVersion);
        List rows = documentListData.getDocumentListRows();
        DocumentListRow documentListRow = row = rows.size() > 0 ? (DocumentListRow)rows.get(0) : null;
        if (row != null) {
            Long documentId = row.getDocumentId();
            List<DocumentReference> documentReferences = this.documentReferenceDAO.getByDocument(documentId);
            row.setDocumentReferences(documentReferences);
            Long projectId = row.getProjectId();
            List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
            HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
            this.calculateInvalidateOptions(documentListData, row, holidayCalculator);
        }
        return documentListData;
    }

    private void calculateInvalidateOptions(DocumentListData documentListData, DocumentListRow documentListRow, HolidayCalculator holidayCalculator) {
        Long sourceDocumentVersionId;
        DocumentListOtherVersionInfo otherVersionInfo;
        boolean hasInvalidateDocumentVersion;
        Long objectPlannerId;
        List allOptions = documentListData.getResultOptions();
        HashMap<Long, ReviewCycleResultOption> idToOption = new HashMap<Long, ReviewCycleResultOption>();
        for (ReviewCycleResultOption option : allOptions) {
            idToOption.put(option.getId(), option);
        }
        ReviewCycleInfo cycleInfo = documentListData.getCycleInfo();
        Long nodeId = documentListRow.getReviewCycleNodeInstanceNodeId();
        ReviewCycleNode node = cycleInfo.getNodeById(nodeId);
        Long cellId = node.getReviewCycleCellId();
        ReviewCycleCell cell = cycleInfo.getCellById(cellId);
        Long cycleId = cell.getReviewCycleId();
        ReviewCycle cycle = cycleInfo.getCycleById(cycleId);
        Long documentVersionInvalidationOptionId = cycle.getDocumentVersionInvalidationResultOptionId();
        boolean isAsBuiltReferenced = this.isAsBuiltReferenced(documentListRow);
        ArrayList<ReviewCycleResultOption> invalidateOptions = new ArrayList<ReviewCycleResultOption>();
        boolean authorizationNeeded = false;
        Map objectPlannerIdToActions = documentListData.getObjectPlannerIdToActions();
        boolean hasInvalidateDocumentOp = objectPlannerIdToActions.containsKey(objectPlannerId = documentListRow.getObjectPlannerId()) && ((Map)objectPlannerIdToActions.get(objectPlannerId)).containsKey(Action.INVALIDATE_DOCUMENT_OP_CONTEXT.getName());
        Set projectActions = documentListData.getProjectActions();
        boolean hasInvalidateDocumentPrj = projectActions.contains(Action.INVALIDATE_DOCUMENT.getName());
        boolean bl = hasInvalidateDocumentVersion = objectPlannerIdToActions.containsKey(objectPlannerId) && ((Map)objectPlannerIdToActions.get(objectPlannerId)).containsKey(Action.INVALIDATE_DOCUMENT_VERSION.getName());
        if (!(documentVersionInvalidationOptionId == null || documentListRow.isInvalidated() || documentListRow.isDeleted() || documentListRow.isReleasedNegativ() || isAsBuiltReferenced || !hasInvalidateDocumentVersion && !hasInvalidateDocumentPrj)) {
            ReviewCycleResultOption invalidationOption = (ReviewCycleResultOption)idToOption.get(documentVersionInvalidationOptionId);
            authorizationNeeded |= invalidationOption.isNeedsAuthorization() != null && invalidationOption.isNeedsAuthorization() != false;
            invalidateOptions.add(invalidationOption);
        }
        if (!documentListRow.isInvalidatedAll() && (hasInvalidateDocumentOp || hasInvalidateDocumentPrj)) {
            Long documentInvalidationOptionId = cycle.getDocumentInvalidationResultOptionId();
            ReviewCycleResultOption documentInvalidationOption = (ReviewCycleResultOption)idToOption.get(documentInvalidationOptionId);
            authorizationNeeded |= documentInvalidationOption != null && documentInvalidationOption.isNeedsAuthorization() != null && documentInvalidationOption.isNeedsAuthorization() != false;
            invalidateOptions.add(documentInvalidationOption);
        }
        Long documentVersionDeletedOptionId = cycle.getDocumentVersionDeletedOptionId();
        ReviewCycleResultOption documentVersionDeletedOption = (ReviewCycleResultOption)idToOption.get(documentVersionDeletedOptionId);
        if (documentVersionDeletedOptionId != null && !documentListRow.isDeleted() && !isAsBuiltReferenced) {
            boolean mayDeleteDocumentVersion = projectActions.contains(Action.DELETE_DOCUMENT_VERSION.getName());
            if (mayDeleteDocumentVersion) {
                authorizationNeeded |= documentVersionDeletedOption != null && documentVersionDeletedOption.isNeedsAuthorization() != null && documentVersionDeletedOption.isNeedsAuthorization() != false;
                invalidateOptions.add(documentVersionDeletedOption);
            } else if (hasInvalidateDocumentVersion && cell.getIsDocumentVersionDeletable() != null && cell.getIsDocumentVersionDeletable().booleanValue()) {
                Double uploaded = documentListRow.getDocumentVersionUploaded();
                long currentMillis = System.currentTimeMillis();
                Double now = new Double(currentMillis) / 1000.0;
                int workingDaysBetween = holidayCalculator.getWorkingDaysBetween(uploaded, now, this.timeZone);
                boolean isStatusA = documentListRow.isPrereviewed();
                boolean isInTime = true;
                if (workingDaysBetween == 1 && !isStatusA) {
                    int minutesBetween;
                    Calendar uploadedCalendar = Calendar.getInstance(TimeZone.getTimeZone(this.timeZone));
                    uploadedCalendar.setTimeInMillis((long)(uploaded * 1000.0));
                    Calendar nowCalendar = Calendar.getInstance(TimeZone.getTimeZone(this.timeZone));
                    nowCalendar.setTimeInMillis(currentMillis);
                    int hoursBetween = uploadedCalendar.get(11) - nowCalendar.get(11);
                    int daysBetween = uploadedCalendar.get(7) - nowCalendar.get(7);
                    if (hoursBetween < 0 && daysBetween != 0) {
                        isInTime = false;
                    } else if (hoursBetween == 0 && (minutesBetween = uploadedCalendar.get(12) - nowCalendar.get(12)) < 0 && daysBetween != 0) {
                        isInTime = false;
                    }
                } else if (workingDaysBetween > 1 && !isStatusA) {
                    isInTime = false;
                }
                boolean hasPosResults = false;
                if (isInTime) {
                    List cellResultInfos = documentListRow.getAllCellResultInfos();
                    block1: for (DocumentListOtherVersionCellResultInfo cellResultInfo : cellResultInfos) {
                        if (!cellResultInfo.getCellId().equals(cellId) || !cellResultInfo.getCellResultDocumentVersionId().equals(documentListRow.getDocumentVersionId())) continue;
                        List nodeResultInfos = cellResultInfo.getAllNodeResultInfos();
                        for (DocumentListOtherVersionNodeResultInfo nodeResultInfo : nodeResultInfos) {
                            if (!nodeResultInfo.hasPositionResults()) continue;
                            hasPosResults = true;
                            continue block1;
                        }
                    }
                    if (!hasPosResults) {
                        authorizationNeeded |= documentVersionDeletedOption != null && documentVersionDeletedOption.isNeedsAuthorization() != null && documentVersionDeletedOption.isNeedsAuthorization() != false;
                        invalidateOptions.add(documentVersionDeletedOption);
                    }
                }
                if (hasPosResults || !isInTime) {
                    documentListRow.setShowDeleteNotAvailableHint(true);
                }
            }
        } else if (isAsBuiltReferenced) {
            documentListRow.setShowAsBuiltHint(true);
        }
        if (invalidateOptions.isEmpty() && !isAsBuiltReferenced) {
            documentListRow.setShowNoneHint(true);
        }
        DocumentVersionStatus sourceStatus = (otherVersionInfo = documentListRow.getOtherVersionInfoById(sourceDocumentVersionId = documentListRow.getCellConnectionResultSourceDocumentVersionId())) != null ? otherVersionInfo.getDocumentVersionStatus() : null;
        HashSet<Long> invalidateOptionIdsWithReactivationOption = new HashSet<Long>();
        if (otherVersionInfo != null && (sourceStatus == DocumentVersionStatus.INVALIDATEDVERSION || sourceStatus == DocumentVersionStatus.REPLACED || sourceStatus == DocumentVersionStatus.ASBUILT)) {
            for (ReviewCycleResultOption invalidateOption : invalidateOptions) {
                if (documentVersionDeletedOptionId == null || documentVersionDeletedOptionId.longValue() != invalidateOption.getId().longValue()) continue;
                invalidateOptionIdsWithReactivationOption.add(invalidateOption.getId());
            }
        }
        documentListRow.setInvalidateOptionIdsWithReactivationOption(invalidateOptionIdsWithReactivationOption);
        documentListRow.setInvalidateOptions(invalidateOptions);
    }

    private boolean isAsBuiltReferenced(DocumentListRow documentListRow) {
        Long documentVersionId = documentListRow.getDocumentVersionId();
        List<DocumentVersion> asBuiltReferenceSources = this.documentVersionDAO.getByAsBuiltReference(documentVersionId);
        boolean isAsBuiltReferenced = false;
        for (DocumentVersion asBuiltReferenceSource : asBuiltReferenceSources) {
            DocumentVersionStatus currStatus = DocumentVersionStatus.getByValue((Integer)asBuiltReferenceSource.getStatus());
            isAsBuiltReferenced |= currStatus != DocumentVersionStatus.DELETED;
        }
        return isAsBuiltReferenced;
    }

    public DocumentListData doGetDocumentListJoinWithoutSecurity(DocumentSearchModel searchModel, DocumentServiceImpl.DocumentListMode mode, boolean restrictToMaxVersion) {
        ArrayList<DocumentListJoin> attachedNodePositionJoins;
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
        String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
        ContextJoin contextJoin = this.getContextJoinByDocumentSearchModel(searchModel);
        Long subProjectId = contextJoin.getSubProjectId();
        ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
        List<String> contentLocales = I18nHelper.getContentLocales(localisationJoin);
        Long projectId = contextJoin.getProjectId();
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, projectId, Action.DOCUMENT_VERSIONS_OVERVIEW, Action.INVALIDATE_DOCUMENT, Action.DELETE_DOCUMENT_VERSION, Action.REACTIVATE_PREVIOUS_DOCUMENT_VERSION);
        List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
        long prevMillis = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("Will query DocumentListJoin");
        }
        Set<DocumentListComponent> componentSet = DocumentListComponent.getSet(DocumentListComponent.BASE, DocumentListComponent.INSTANCE, DocumentListComponent.CYCLE);
        if (mode == DocumentServiceImpl.DocumentListMode.XLS || mode == DocumentServiceImpl.DocumentListMode.INVALIDATE) {
            componentSet.add(DocumentListComponent.CELL_CONNECTION_RESULT);
            componentSet.add(DocumentListComponent.ENTRY_RESULT);
            componentSet.add(DocumentListComponent.ATTACHED_NODE_POSITION);
        }
        List<DocumentListJoin> allJoins = this.documentDAO.getDocumentListJoin(searchModel, holidayCalculator, componentSet, restrictToMaxVersion);
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - prevMillis;
            log.debug("Queried [" + allJoins.size() + "] DocumentListJoins in [" + duration + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        this.convertI18nFields(allJoins, personVariablesUserLocale, contentLocales, searchModel);
        List<DocumentListJoin> baseJoinsUnfiltered = this.getDocumentListJoinComponents(allJoins, DocumentListComponent.BASE);
        if (log.isDebugEnabled()) {
            log.debug("Extracted [" + baseJoinsUnfiltered.size() + "] BASE joins.");
        }
        DocumentListBaseContext baseContext = new DocumentListBaseContext(baseJoinsUnfiltered);
        List<ReviewCycleResultOption> resultOptions = this.reviewUtils.fetchAndConvertResultOptions(personVariablesUserLocale, contentLocales);
        Map<Long, ReviewCycleResultOption> idToResultOption = ContainerHelper.groupById(resultOptions);
        this.checkDeletePrivilege(organisationPersonId, baseContext, idToResultOption, searchModel);
        Set<Long> objectPlannerIds = this.getObjectPlannerIds(baseJoinsUnfiltered);
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - prevMillis;
            log.debug("Filtered these joins, extracting [" + baseJoinsUnfiltered.size() + "] filtered DocumentListJoins, in [" + duration + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        Map<Long, Set<Action>> rawObjectPlannerIdToActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerIds, Action.DELETE_DOCUMENT_VERSION, Action.DOWNLOAD_ATTACHMENT, Action.DOWNLOAD_DOCUMENT_VERSION, Action.DOWNLOAD_DOCUMENT_VERSION_OP_CONTEXT, Action.INVALIDATE_DOCUMENT, Action.INVALIDATE_DOCUMENT_OP_CONTEXT, Action.INVALIDATE_DOCUMENT_VERSION, Action.SHOW_OBJECT_PLANNER, Action.SHOW_OBJECT_PLANNER_OP_CONTEXT, Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT, Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS, Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS, Action.REQUEST_MANUAL_PLOT_OWN_RECIPIENT_OP_CONTEXT, Action.REQUEST_MANUAL_PLOT_ALL_RECIPIENTS_OP_CONTEXT, Action.REQUEST_MANUAL_PLOT_ALL_RIGHTS_OP_CONTEXT, Action.REQUEST_ORIGINAL_DOCUMENT, Action.REQUEST_ORIGINAL_DOCUMENT_OP_CONTEXT, Action.REVIEW_PROTOCOL, Action.REVIEW_PROTOCOL_OP_CONTEXT, Action.SUPER_ADMIN_RIGHT, Action.SHOW_PNG_PREVIEW);
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - prevMillis;
            log.debug("Queried objectPlannerIdToActions in [" + duration + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        Map<Long, Map<String, Boolean>> objectPlannerIdToActions = ActionHelper.transformToMap(rawObjectPlannerIdToActions);
        boolean directPlotPossible = this.isDirectPlotPossible(searchModel);
        List<DocumentListJoin> instanceJoins = this.getDocumentListJoinComponents(allJoins, DocumentListComponent.INSTANCE);
        List<DocumentListJoin> cycleJoins = this.getDocumentListJoinComponents(allJoins, DocumentListComponent.CYCLE);
        ReviewCycleInfo cycleInfo = this.constructReviewCycleInfo(cycleJoins, personVariablesUserLocale, contentLocales);
        ArrayList<DocumentListJoin> cellConnectionResultJoins = mode == DocumentServiceImpl.DocumentListMode.XLS || mode == DocumentServiceImpl.DocumentListMode.INVALIDATE ? this.getDocumentListJoinComponents(allJoins, DocumentListComponent.CELL_CONNECTION_RESULT) : new ArrayList<DocumentListJoin>();
        ArrayList<DocumentListJoin> entryResultJoins = mode == DocumentServiceImpl.DocumentListMode.XLS || mode == DocumentServiceImpl.DocumentListMode.INVALIDATE ? this.getDocumentListJoinComponents(allJoins, DocumentListComponent.ENTRY_RESULT) : new ArrayList<DocumentListJoin>();
        ArrayList<DocumentListJoin> arrayList = attachedNodePositionJoins = mode == DocumentServiceImpl.DocumentListMode.XLS || mode == DocumentServiceImpl.DocumentListMode.INVALIDATE ? this.getDocumentListJoinComponents(allJoins, DocumentListComponent.ATTACHED_NODE_POSITION) : new ArrayList<DocumentListJoin>();
        if (log.isDebugEnabled()) {
            log.debug("Queried: [" + instanceJoins.size() + "] instance joins, [" + cycleJoins.size() + "] cycle joins, [" + cellConnectionResultJoins.size() + "] cellConnectionResultJoins, [" + entryResultJoins.size() + "] entryResultJoins, [" + attachedNodePositionJoins.size() + "] attachedNodePositionJoins");
        }
        List<DocumentListRow> documentListRows = this.constructDocumentListRows((DocumentListBaseContext<DocumentListJoin>)baseContext, searchModel, cycleInfo, mode, baseJoinsUnfiltered, instanceJoins, cellConnectionResultJoins, entryResultJoins, attachedNodePositionJoins, idToResultOption);
        if (log.isDebugEnabled()) {
            log.debug("Constructed [" + documentListRows.size() + "] documentListRows.");
        }
        DocumentListData retData = new DocumentListData();
        if (mode == DocumentServiceImpl.DocumentListMode.GUI_LIST || mode == DocumentServiceImpl.DocumentListMode.PDF) {
            List<DocumentListRow> svgRows = this.constructDocumentListRows((DocumentListBaseContext<DocumentListJoin>)baseContext, searchModel, cycleInfo, DocumentServiceImpl.DocumentListMode.SVG, baseJoinsUnfiltered, instanceJoins, cellConnectionResultJoins, entryResultJoins, attachedNodePositionJoins, idToResultOption);
            HashMap<Long, String> documentIdToReviewStatusSvg = new HashMap<Long, String>();
            HashMap<Long, String> documentIdToReviewStatusToolTip = new HashMap<Long, String>();
            HashMap<Long, Integer> documentIdToDelay = new HashMap<Long, Integer>();
            this.fetchDocumentIdToReviewStatusSvgMap(documentIdToReviewStatusSvg, documentIdToReviewStatusToolTip, documentIdToDelay, svgRows, cycleInfo, personVariablesUserLocale, holidayCalculator);
            retData.setDocumentIdToReviewStatusSvg(documentIdToReviewStatusSvg);
            retData.setDocumentIdToReviewStatusToolTip(documentIdToReviewStatusToolTip);
            retData.setDocumentIdToDelay(documentIdToDelay);
        }
        retData.setObjectPlannerIdToActions(objectPlannerIdToActions);
        retData.setProjectActions(ActionHelper.convertEnumToString(actions));
        retData.setResultOptions(resultOptions);
        retData.setDirectPlotPossible(directPlotPossible);
        retData.setDocumentListRows(documentListRows);
        retData.setCycleInfo(cycleInfo);
        if (log.isDebugEnabled()) {
            log.debug("Successfully returning DocumentListData.");
        }
        return retData;
    }

    public void fetchDocumentIdToReviewStatusSvgMap(Map<Long, String> documentIdToReviewStatusSvg, Map<Long, String> documentIdToReviewStatusToolTip, Map<Long, Integer> documentIdToDelay, List<DocumentListRow> documentListRows, ReviewCycleInfo reviewCycleInfo, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        String s;
        DocumentListRow documentListRow;
        Long documentVersionId;
        HashSet<Long> documentVersionIds = new HashSet<Long>();
        HashMap<Long, DocumentListRow> documentVersionIdToRow = new HashMap<Long, DocumentListRow>();
        for (DocumentListRow documentListRow2 : documentListRows) {
            Long documentVersionId2 = documentListRow2.getDocumentVersionId();
            if (documentVersionId2 == null) continue;
            documentVersionIds.add(documentVersionId2);
            documentVersionIdToRow.put(documentVersionId2, documentListRow2);
        }
        ArrayList<Long> documentVersionIdsList = new ArrayList<Long>();
        documentVersionIdsList.addAll(documentVersionIds);
        Map<Long, Integer> documentVersionIdToSignedPositionResultCount = QueryHelper.executeDAOGetter(documentVersionIdsList, this.sqlQueryBatchSize, new BatchedDAOGetterMap<Integer, Long>(){

            @Override
            public Map<Long, Integer> execute(List<Long> ids) {
                return DocumentUtils.this.reviewCycleNodePositionReleasedDAO.getSignedPositionResultCountByVersionIds(ids);
            }
        });
        for (Long documentVersionId3 : documentVersionIds) {
            DocumentListRow documentListRow3 = (DocumentListRow)documentVersionIdToRow.get(documentVersionId3);
            Integer signedCount = documentVersionIdToSignedPositionResultCount.containsKey(documentVersionId3) ? documentVersionIdToSignedPositionResultCount.get(documentVersionId3) : 0;
            documentListRow3.setSignedPositionResultCount(signedCount.intValue());
        }
        List<NodePositionJoin> openNodePositionJoins = QueryHelper.executeDAOGetter(documentVersionIdsList, this.sqlQueryBatchSize / 2, new BatchedDAOGetter<NodePositionJoin, Long>(){

            @Override
            public List<NodePositionJoin> execute(List<Long> ids) {
                return DocumentUtils.this.reviewCycleNodePositionReleasedDAO.getNodePositionJoinsByVersionIds(ids);
            }
        });
        List<AttachedNodePositionJoin> openAttachedNodePositionJoins = QueryHelper.executeDAOGetter(documentVersionIdsList, this.sqlQueryBatchSize / 2, new BatchedDAOGetter<AttachedNodePositionJoin, Long>(){

            @Override
            public List<AttachedNodePositionJoin> execute(List<Long> ids) {
                return DocumentUtils.this.attachedReviewCycleNodePositionDAO.getAttachedNodePositionJoinsByVersionIds(ids);
            }
        });
        for (NodePositionJoin openNodePositionJoin : openNodePositionJoins) {
            documentVersionId = openNodePositionJoin.getDocumentVersionId();
            documentListRow = (DocumentListRow)documentVersionIdToRow.get(documentVersionId);
            if (!documentListRow.hasOpenPositionParticipationString(s = openNodePositionJoin.getOrganisationName() + " (" + openNodePositionJoin.getPersonSurName() + " " + openNodePositionJoin.getPersonGivenName() + ") ")) {
                documentListRow.registerOpenPositionParticipationString(s);
            }
            documentListRow.incrementOpenPositionCount();
        }
        for (AttachedNodePositionJoin openAttachedNodePositionJoin : openAttachedNodePositionJoins) {
            documentVersionId = openAttachedNodePositionJoin.getDocumentVersionId();
            documentListRow = (DocumentListRow)documentVersionIdToRow.get(documentVersionId);
            if (!documentListRow.hasOpenPositionParticipationString(s = openAttachedNodePositionJoin.getOrganisationName() + " (" + openAttachedNodePositionJoin.getPersonSurName() + " " + openAttachedNodePositionJoin.getPersonGivenName() + ") ")) {
                documentListRow.registerOpenPositionParticipationString(s);
            }
            documentListRow.incrementOpenPositionCount();
        }
        for (DocumentListRow documentListRow4 : documentListRows) {
            Long documentId = documentListRow4.getDocumentId();
            if (documentListRow4.getReviewCycleInstanceReleasedName() == null) continue;
            Triple<String, String, Integer> result = this.smallReviewCycleSvgRenderer.render(documentListRow4, reviewCycleInfo, 150.0, 50.0, true, false, false, personVariablesUserLocale, holidayCalculator);
            documentIdToReviewStatusSvg.put(documentId, (String)result.getFirst());
            documentIdToReviewStatusToolTip.put(documentId, (String)result.getSecond());
            documentIdToDelay.put(documentId, (Integer)result.getThird());
        }
    }

    public Map<Long, String> getDocumentIdToReviewStatusToolTipMap(List<DocumentListRow> documentListRows, ReviewCycleInfo reviewCycleInfo, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        HashMap<Long, String> documentIdToReviewStatusToolTip = new HashMap<Long, String>();
        for (DocumentListRow documentListRow : documentListRows) {
            Long documentId = documentListRow.getDocumentId();
            String result = "<b>server test</b>";
            documentIdToReviewStatusToolTip.put(documentId, result);
        }
        return documentIdToReviewStatusToolTip;
    }

    private ReviewCycleInfo constructReviewCycleInfo(List<DocumentListJoin> joins, String personVariablesUserLocale, List<String> contentLocales) {
        ReviewCycleInfo reviewCycleInfo = new ReviewCycleInfo();
        HashMap<Long, ReviewCycle> idToCycle = new HashMap<Long, ReviewCycle>();
        HashMap<Long, ReviewCycleCell> idToCell = new HashMap<Long, ReviewCycleCell>();
        HashMap<Long, ReviewCycleNode> idToNode = new HashMap<Long, ReviewCycleNode>();
        HashSet<Long> endNodeIds = new HashSet<Long>();
        HashMap cycleIdToCells = new HashMap();
        HashMap cellIdToNodes = new HashMap();
        HashMap cellIdToLeavingConnections = new HashMap();
        HashMap cellIdToIncomingConnections = new HashMap();
        for (DocumentListJoin join : joins) {
            Long cycleId = join.getReviewCycleId();
            Long cellId = join.getReviewCycleCellId();
            Long nodeId = join.getReviewCycleNodeId();
            Long endNodeId = join.getEndNodeId();
            Long sourceCellId = join.getReviewCycleCellConnectionSourceCellId();
            Long destinationCellId = join.getReviewCycleCellConnectionDestinationCellId();
            String reviewCycleName = join.getReviewCycleName();
            reviewCycleName = I18nHelper.convertDatabaseToJs(reviewCycleName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleName(reviewCycleName);
            String reviewCycleCellName = join.getReviewCycleCellName();
            reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCellName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleCellName(reviewCycleCellName);
            String reviewCycleNodeName = join.getReviewCycleNodeName();
            reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleNodeName(reviewCycleNodeName);
            if (cycleId != null) {
                idToCycle.put(cycleId, join.getReviewCycle());
            }
            if (cellId != null) {
                idToCell.put(cellId, join.getReviewCycleCell());
                if (!cycleIdToCells.containsKey(cycleId)) {
                    cycleIdToCells.put(cycleId, new ArrayList());
                }
                ((List)cycleIdToCells.get(cycleId)).add(join.getReviewCycleCell());
            }
            if (nodeId != null) {
                idToNode.put(nodeId, join.getReviewCycleNode());
                if (!cellIdToNodes.containsKey(cellId)) {
                    cellIdToNodes.put(cellId, new ArrayList());
                }
                ((List)cellIdToNodes.get(cellId)).add(join.getReviewCycleNode());
            }
            if (endNodeId != null) {
                endNodeIds.add(endNodeId);
            }
            if (sourceCellId != null) {
                if (!cellIdToLeavingConnections.containsKey(sourceCellId)) {
                    cellIdToLeavingConnections.put(sourceCellId, new ArrayList());
                }
                ((List)cellIdToLeavingConnections.get(sourceCellId)).add(join.getReviewCycleCellConnection());
            }
            if (destinationCellId == null) continue;
            if (!cellIdToIncomingConnections.containsKey(destinationCellId)) {
                cellIdToIncomingConnections.put(destinationCellId, new ArrayList());
            }
            ((List)cellIdToIncomingConnections.get(destinationCellId)).add(join.getReviewCycleCellConnection());
        }
        reviewCycleInfo.setIdToCycle(idToCycle);
        reviewCycleInfo.setIdToCell(idToCell);
        reviewCycleInfo.setIdToNode(idToNode);
        reviewCycleInfo.setEndNodeIds(endNodeIds);
        reviewCycleInfo.setCycleIdToCells(cycleIdToCells);
        reviewCycleInfo.setCellIdToNodes(cellIdToNodes);
        reviewCycleInfo.setCellIdToLeavingConnections(cellIdToLeavingConnections);
        reviewCycleInfo.setCellIdToIncomingConnections(cellIdToIncomingConnections);
        List resultOptions = this.reviewCycleResultOptionDAO.getAll();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            String resultOptionName = resultOption.getName();
            resultOptionName = I18nHelper.convertDatabaseToJs(resultOptionName, personVariablesUserLocale, contentLocales);
            resultOption.setName(resultOptionName);
        }
        reviewCycleInfo.setResultOptions(resultOptions);
        return reviewCycleInfo;
    }

    public void convertI18nFields(List<DocumentListJoin> allJoins, String personVariablesUserLocale, List<String> contentLocales, DocumentSearchModel searchModel) {
        if (searchModel.getSubProjectId() != null) {
            for (DocumentListJoin documentListJoin : allJoins) {
                String documentContent = documentListJoin.getDocumentContent();
                documentContent = I18nHelper.convertDatabaseToJs(documentContent, personVariablesUserLocale, contentLocales);
                documentListJoin.setDocumentContent(documentContent);
                String documentReleaseContent = documentListJoin.getDocumentReleaseContent();
                documentReleaseContent = I18nHelper.convertDatabaseToJs(documentReleaseContent, personVariablesUserLocale, contentLocales);
                documentListJoin.setDocumentReleaseContent(documentReleaseContent);
                String realmName = documentListJoin.getRealmName();
                realmName = I18nHelper.convertDatabaseToJs(realmName, personVariablesUserLocale, contentLocales);
                documentListJoin.setRealmName(realmName);
                String reviewCycleNodeName = documentListJoin.getReviewCycleNodeName();
                reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, contentLocales);
                documentListJoin.setReviewCycleNodeName(reviewCycleNodeName);
                String reviewCycleCellName = documentListJoin.getReviewCycleCellName();
                reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCellName, personVariablesUserLocale, contentLocales);
                documentListJoin.setReviewCycleCellName(reviewCycleCellName);
                String resultOptionName = documentListJoin.getReviewCycleResultOptionName();
                resultOptionName = I18nHelper.convertDatabaseToJs(resultOptionName, personVariablesUserLocale, contentLocales);
                documentListJoin.setReviewCycleResultOptionName(resultOptionName);
            }
        }
    }

    public <T extends IDocumentListJoin> List<T> getDocumentListJoinComponents(List<T> allJoins, DocumentListComponent component) {
        ArrayList<IDocumentListJoin> joins = new ArrayList<IDocumentListJoin>();
        for (IDocumentListJoin candidateJoin : allJoins) {
            Integer unionClause = candidateJoin.getUnionClause();
            if (component != DocumentListComponent.getByValue(unionClause)) continue;
            joins.add(candidateJoin);
        }
        return joins;
    }

    public boolean isDirectPlotPossible(DocumentSearchModel searchModel) {
        if (searchModel.getObjectId() != null) {
            return this.plotOrderTemplateDAO.isDirectPlotPossibleByObject(searchModel.getObjectId());
        }
        return this.plotOrderTemplateDAO.isDirectPlotPossibleBySubProject(searchModel.getSubProjectId());
    }

    public <T extends IDocumentListJoin> void checkDeletePrivilege(Long organisationPersonId, DocumentListBaseContext<T> baseContext, Map<Long, ReviewCycleResultOption> idToResultOption, DocumentSearchModel documentSearchModel) {
        ArrayList<IDocumentListJoin> extractedJoins = new ArrayList<IDocumentListJoin>();
        for (Long documentId : baseContext.getAllDocumentIds()) {
            if (baseContext.hasAnyDocumentVersion(documentId)) continue;
            extractedJoins.add(baseContext.getSomeJoinForDocumentId(documentId));
        }
        for (Object documentVersionId : baseContext.getAllDocumentVersionIds()) {
            extractedJoins.add(baseContext.getSomeJoinForDocumentVersionId((Long)documentVersionId));
        }
        HashSet<Long> projectIds = new HashSet<Long>();
        for (IDocumentListJoin documentListJoin : extractedJoins) {
            projectIds.add(documentListJoin.getProjectId());
        }
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.SHOW_DOCUMENTS_OF_DELETED_OBJECT_PLANNERS);
        for (IDocumentListJoin documentListJoin : extractedJoins) {
            Long projectId = documentListJoin.getProjectId();
            if (documentSearchModel.getShowDeleted() == null || !documentSearchModel.getShowDeleted().booleanValue() || projectIdToActions.containsKey(projectId) && projectIdToActions.get(projectId).contains(Action.SHOW_DOCUMENTS_OF_DELETED_OBJECT_PLANNERS)) continue;
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] emitted a document search for project [" + projectId + "] with showDeleted == true, although the (for this purpose) necessary privilege [showDocumentsOfDeletedObjectPlanners] is missing.");
        }
    }

    private Set<Long> getObjectPlannerIds(List<DocumentListJoin> documentListJoins) {
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        for (DocumentListJoin documentListJoin : documentListJoins) {
            objectPlannerIds.add(documentListJoin.getObjectPlannerId());
        }
        return objectPlannerIds;
    }

    public ContextJoin getContextJoinByDocumentSearchModel(DocumentSearchModel searchModel) {
        Long documentVersionId = searchModel.getDocumentVersionId();
        ContextJoin contextJoin = documentVersionId != null ? this.documentVersionDAO.getContextJoin(documentVersionId) : (searchModel.getSubProjectId() != null ? this.subProjectDAO.getSubProjectContextJoin(searchModel.getSubProjectId()) : this.objectDAO.getObjectContextJoin(searchModel.getObjectId()));
        return contextJoin;
    }

    private List<DocumentListRow> constructDocumentListRows(DocumentListBaseContext<DocumentListJoin> baseContext, DocumentSearchModel searchModel, ReviewCycleInfo cycleInfo, DocumentServiceImpl.DocumentListMode mode, List<DocumentListJoin> baseJoins, List<DocumentListJoin> instanceJoins, List<DocumentListJoin> cellConnectionResultJoins, List<DocumentListJoin> entryResultJoins, List<DocumentListJoin> attachedNodePositionJoins, Map<Long, ReviewCycleResultOption> idToResultOption) {
        boolean guiOrPdf;
        Map<Long, List<DocumentListJoin>> documentIdToInstanceJoins = this.groupDocumentListJoinsByDocumentId(instanceJoins);
        Map<Long, List<DocumentListJoin>> documentVersionIdToCellConnectionResultJoins = this.groupDocumentListJoinsByDocumentVersionId(cellConnectionResultJoins);
        Map<Long, List<DocumentListJoin>> documentVersionIdToEntryResultJoins = this.groupDocumentListJoinsByDocumentVersionId(entryResultJoins);
        Map<Long, List<DocumentListJoin>> documentVersionIdToAttachedNodePositionJoins = this.groupDocumentListJoinsByDocumentVersionId(attachedNodePositionJoins);
        List<DocumentListJoin> filteredBaseJoins = this.restrictToLatestJoins(baseJoins, searchModel);
        filteredBaseJoins = this.applyReleasedFromToFilter(filteredBaseJoins, searchModel, baseContext, idToResultOption);
        filteredBaseJoins = this.applyStateFilter(filteredBaseJoins, searchModel, baseContext);
        boolean bl = guiOrPdf = mode == DocumentServiceImpl.DocumentListMode.GUI_LIST || mode == DocumentServiceImpl.DocumentListMode.PDF;
        if (guiOrPdf || mode == DocumentServiceImpl.DocumentListMode.INVALIDATE) {
            baseJoins = filteredBaseJoins;
        } else {
            ArrayList<DocumentListJoin> effectiveBaseJoins = new ArrayList<DocumentListJoin>();
            for (DocumentListJoin baseJoin : filteredBaseJoins) {
                Set documentsDocumentVersionIds;
                effectiveBaseJoins.add(baseJoin);
                if (!baseJoin.isDocumentHasDocumentVersions().booleanValue() || (documentsDocumentVersionIds = baseContext.getVersionIdsByDocumentId(baseJoin.getDocumentId())).isEmpty()) continue;
                for (Long documentVersionId : documentsDocumentVersionIds) {
                    DocumentListJoin additionalBaseJoin = (DocumentListJoin)baseContext.getSomeJoinForDocumentVersionId(documentVersionId);
                    if (documentVersionId.equals(baseJoin.getDocumentVersionId())) continue;
                    effectiveBaseJoins.add(additionalBaseJoin);
                }
            }
            baseJoins = effectiveBaseJoins;
        }
        ArrayList<DocumentListRow> rows = new ArrayList<DocumentListRow>();
        for (DocumentListJoin baseJoin : baseJoins) {
            Long documentId = baseJoin.getDocumentId();
            Long documentVersionId = baseJoin.getDocumentVersionId();
            String key = documentVersionId != null ? baseJoin.getDocumentVersionName() : baseJoin.getDocumentName();
            DocumentListRow row = new DocumentListRow();
            row.setKey(key);
            row.setDocument(baseJoin.getDocument());
            row.setDocumentRelease(baseJoin.getDocumentRelease());
            row.setDocumentVersion(baseJoin.getDocumentVersion());
            List<DocumentListJoin> currInstanceJoins = documentIdToInstanceJoins.get(documentId);
            ReviewCycleInstanceReleasedInfo instanceReleasedInfo = this.constructInstanceReleasedInfo(currInstanceJoins, cycleInfo, false);
            row.setInstanceReleasedInfo(instanceReleasedInfo);
            if (documentVersionId != null) {
                DocumentListJoin latestPositionResultJoin = (DocumentListJoin)baseContext.getPositionResultJoinByVersionWithoutCommentReferenceAndMaxResultDate(documentVersionId);
                row.setLatestPositionResult(latestPositionResultJoin != null ? latestPositionResultJoin.getReviewCyclePositionResult() : null);
                Long nodeId = baseJoin.getReviewCycleNodeInstanceReviewCycleNodeId();
                DocumentListJoin latestNodeResultJoin = (DocumentListJoin)baseContext.getNodeResultJoinByVersionNodeAndMaxArrivalDate(documentVersionId, nodeId);
                row.setLatestNodeResult(latestNodeResultJoin != null ? latestNodeResultJoin.getReviewCycleNodeResult() : null);
            }
            row.setObject((Object)baseJoin.getObject());
            row.setObjectPlanner(baseJoin.getObjectPlanner());
            row.setProject(baseJoin.getProject());
            row.setReviewCycleNodeInstance(baseJoin.getReviewCycleNodeInstance());
            row.setRevisedDocumentVersion(baseJoin.getRevisedDocumentVersion());
            row.setSubProject(baseJoin.getSubProject());
            row.setObjectPlannerRelease(baseJoin.getObjectPlannerRelease());
            row.setPreviewSupportDocumentVersion(baseJoin.getPreviewSupportDocumentVersion());
            List<DocumentListOtherVersionInfo> otherVersionInfos = this.constructOtherVersionInfos(baseContext, instanceReleasedInfo, cycleInfo, documentId, false);
            if (guiOrPdf) {
                DocumentListOtherVersionInfo lastVersionInfo = otherVersionInfos.size() > 0 ? otherVersionInfos.get(otherVersionInfos.size() - 1) : null;
                row.setIsReleasedVersionOfRevision(lastVersionInfo != null && lastVersionInfo.getDocumentVersionRevisedVersionId() != null);
            } else {
                row.setDocumentListRelease(baseJoin.getDocumentListRelease());
                row.setObjectRelease(baseJoin.getObjectRelease());
                row.setObjectListRelease(baseJoin.getObjectListRelease());
                row.setObjectReleaseObjectType(baseJoin.getObjectReleaseObjectType());
                ArrayList<AttachedNodePositionInfo> attachedNodePositionInfos = new ArrayList<AttachedNodePositionInfo>();
                if (documentVersionIdToAttachedNodePositionJoins.containsKey(documentVersionId)) {
                    for (DocumentListJoin join : documentVersionIdToAttachedNodePositionJoins.get(documentVersionId)) {
                        AttachedNodePositionInfo info = new AttachedNodePositionInfo();
                        info.setAttachedReviewCycleNodePosition(join.getAttachedReviewCycleNodePosition());
                        info.setRealm(join.getRealmId() != null ? join.getRealm() : null);
                        info.setReviewerMainPerson(join.getReviewerMainPerson());
                        info.setReviewerParticipant(join.getReviewerParticipant());
                        info.setReviewerOrganisation(join.getReviewerOrganisation());
                        attachedNodePositionInfos.add(info);
                    }
                }
                row.setAttachedNodePositionInfos(attachedNodePositionInfos);
                if (documentVersionId != null) {
                    DocumentListJoin someResultJoin;
                    List<DocumentListJoin> resultJoins = documentVersionIdToCellConnectionResultJoins.containsKey(documentVersionId) ? documentVersionIdToCellConnectionResultJoins.get(documentVersionId) : documentVersionIdToEntryResultJoins.get(documentVersionId);
                    DocumentListJoin documentListJoin = someResultJoin = resultJoins != null && resultJoins.size() > 0 ? resultJoins.get(0) : null;
                    if (someResultJoin != null) {
                        row.setPlannerParticipant(someResultJoin.getPlannerParticipant());
                        row.setPlannerOrganisation(someResultJoin.getPlannerOrganisation());
                        row.setPlannerPerson(someResultJoin.getPlannerPerson());
                        row.setPlannerMainPerson(someResultJoin.getPlannerMainPerson());
                        if (someResultJoin.getReviewCycleCellConnectionResultId() != null) {
                            row.setCellConnectionResult(someResultJoin.getReviewCycleCellConnectionResult());
                            row.setDestCellResult(someResultJoin.getDestCellResult());
                        } else if (someResultJoin.getReviewCycleEntryResultId() != null) {
                            row.setEntryResult(someResultJoin.getReviewCycleEntryResult());
                        }
                        ArrayList<StatementResultInfo> statementResultInfos = new ArrayList<StatementResultInfo>();
                        for (DocumentListJoin resultJoin : resultJoins) {
                            StatementResultInfo statementResultInfo;
                            Realm realm = resultJoin.getRealm();
                            ReviewCycleResultOption resultOption = resultJoin.getReviewCycleResultOption();
                            if (resultJoin.getReviewCycleCellConnectionStatementResultId() != null) {
                                statementResultInfo = new StatementResultInfo();
                                statementResultInfo.setCellConnectionStatementResult(resultJoin.getReviewCycleCellConnectionStatementResult());
                                statementResultInfo.setRealm(realm);
                                statementResultInfo.setResultOption(resultOption);
                                statementResultInfos.add(statementResultInfo);
                                continue;
                            }
                            if (resultJoin.getReviewCycleEntryStatementResultId() == null) continue;
                            statementResultInfo = new StatementResultInfo();
                            statementResultInfo.setEntryStatementResult(resultJoin.getReviewCycleEntryStatementResult());
                            statementResultInfo.setRealm(realm);
                            statementResultInfo.setResultOption(resultOption);
                            statementResultInfos.add(statementResultInfo);
                        }
                        row.setStatementResultInfos(statementResultInfos);
                    }
                } else {
                    row.setPlannerParticipant(baseJoin.getPlannerParticipant());
                    row.setPlannerOrganisation(baseJoin.getPlannerOrganisation());
                    row.setPlannerMainPerson(baseJoin.getPlannerMainPerson());
                }
                row.setOtherVersionInfos(otherVersionInfos);
            }
            rows.add(row);
        }
        return rows;
    }

    public <T extends IDocumentListJoin> List<T> restrictToLatestJoins(List<T> baseJoins, DocumentSearchModel searchModel) {
        Integer searchedStatusInt = searchModel.getStatus();
        DocumentVersionStatus searchedStatus = DocumentVersionStatus.getByValue((Integer)searchedStatusInt);
        Map<Long, List<T>> documentIdToBaseJoins = this.groupDocumentListJoinsByDocumentId(baseJoins);
        ArrayList<IDocumentListJoin> greatestVersionBaseJoins = new ArrayList<IDocumentListJoin>();
        for (Long documentId : documentIdToBaseJoins.keySet()) {
            List<T> currBaseJoins = documentIdToBaseJoins.get(documentId);
            if (currBaseJoins.size() == 1 && ((IDocumentListJoin)currBaseJoins.get(0)).getDocumentVersionId() == null) {
                greatestVersionBaseJoins.add((IDocumentListJoin)currBaseJoins.get(0));
                continue;
            }
            Collections.sort(currBaseJoins, new Comparator<T>(){

                @Override
                public int compare(T joinOne, T joinTwo) {
                    double uploadedTwo;
                    double uploadedOne = joinOne.getDocumentVersionUploaded() != null ? joinOne.getDocumentVersionUploaded() : 0.0;
                    double d = uploadedTwo = joinTwo.getDocumentVersionUploaded() != null ? joinTwo.getDocumentVersionUploaded() : 0.0;
                    if (uploadedOne < uploadedTwo) {
                        return -1;
                    }
                    if (uploadedOne > uploadedTwo) {
                        return 1;
                    }
                    return 0;
                }
            });
            IDocumentListJoin lastBaseJoin = (IDocumentListJoin)currBaseJoins.get(currBaseJoins.size() - 1);
            greatestVersionBaseJoins.add(lastBaseJoin);
        }
        return greatestVersionBaseJoins;
    }

    public <T extends IDocumentListJoin> List<T> applyReleasedFromToFilter(List<T> extractedJoins, DocumentSearchModel documentSearchModel, DocumentListBaseContext<T> baseContext, Map<Long, ReviewCycleResultOption> idToResultOption) {
        Double releasedFrom = documentSearchModel.getReleasedFrom();
        Double releasedTo = documentSearchModel.getReleasedTo();
        if (releasedFrom != null || releasedTo != null) {
            ArrayList<T> joinsAfterReleasedFilter = new ArrayList<T>();
            for (IDocumentListJoin join : extractedJoins) {
                boolean keep;
                DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)join.getDocumentVersionStatus());
                boolean bl = keep = join.getDocumentVersionId() != null;
                if (documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV) {
                    ReviewCycleResultOption positionResultOption;
                    Long documentVersionId = join.getDocumentVersionId();
                    Long nodeId = join.getReviewCycleNodeInstanceReviewCycleNodeId();
                    IDocumentListJoin nodeResultJoin = baseContext.getNodeResultJoinByVersionNodeAndMaxArrivalDate(documentVersionId, nodeId);
                    IDocumentListJoin positionResultJoin = baseContext.getPositionResultJoinByVersionWithoutCommentReferenceAndMaxResultDate(documentVersionId);
                    Long positionResultOptionId = positionResultJoin != null ? positionResultJoin.getReviewCyclePositionResultReviewCycleResultOptionId() : null;
                    ReviewCycleResultOption reviewCycleResultOption = positionResultOption = positionResultOptionId != null ? idToResultOption.get(positionResultOptionId) : null;
                    if (nodeResultJoin == null && positionResultOption == null) {
                        keep = false;
                    }
                    if (releasedFrom != null) {
                        keep &= positionResultOption == null && nodeResultJoin.getReviewCycleNodeResultArrivalDate() >= releasedFrom - 86400.0 - 1.0E-9 || positionResultOption != null && DocumentVersionStatus.getByValue((Integer)positionResultOption.getDocumentVersionStatus()) == DocumentVersionStatus.RELEASEDPOSITIV && positionResultJoin.getReviewCyclePositionResultResultDate() >= releasedFrom - 86400.0 - 1.0E-9;
                    }
                    if (releasedTo != null) {
                        keep &= positionResultOption == null && nodeResultJoin.getReviewCycleNodeResultArrivalDate() <= releasedTo + 86400.0 + 1.0E-9 || positionResultOption != null && DocumentVersionStatus.getByValue((Integer)positionResultOption.getDocumentVersionStatus()) == DocumentVersionStatus.RELEASEDPOSITIV && positionResultJoin.getReviewCyclePositionResultResultDate() <= releasedTo + 86400.0 + 1.0E-9;
                    }
                } else {
                    keep = false;
                }
                if (!keep) continue;
                joinsAfterReleasedFilter.add(join);
            }
            extractedJoins = joinsAfterReleasedFilter;
        }
        return extractedJoins;
    }

    public <T extends IDocumentListJoin> List<T> applyStateFilter(List<T> extractedJoins, DocumentSearchModel documentSearchModel, DocumentListBaseContext<T> baseContext) {
        Integer searchedStatus = documentSearchModel.getStatus();
        ArrayList<IDocumentListJoin> joinsBeforePrivileges = new ArrayList<IDocumentListJoin>();
        for (IDocumentListJoin extractedJoin : extractedJoins) {
            Long documentVersionId = extractedJoin.getDocumentVersionId();
            Integer documentVersionStatus = extractedJoin.getDocumentVersionStatus();
            Long revisedDocumentVersionId = extractedJoin.getDocumentVersionRevisedDocumentVersionId();
            Integer revisedDocumentVersionStatus = null;
            IDocumentListJoin effectiveJoin = extractedJoin;
            if (revisedDocumentVersionId != null) {
                IDocumentListJoin revisedJoin = baseContext.getSomeJoinForDocumentVersionId(revisedDocumentVersionId);
                if (revisedJoin == null) {
                    throw new RuntimeException("Could not find revised DocumentListJoin starting from DocumentVersion [" + documentVersionId + "] with revisedDocumentVersionId [" + revisedDocumentVersionId + "], something is strange here.");
                }
                revisedDocumentVersionStatus = revisedJoin.getDocumentVersionStatus();
                effectiveJoin = revisedJoin;
            }
            if (!(documentVersionId == null || revisedDocumentVersionId == null && searchedStatus != null && searchedStatus.intValue() == DocumentVersionStatus.INREVIEW.getValue() || revisedDocumentVersionId == null || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.INVALIDATEDVERSION.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.DELETED.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.ABORTED.getValue() || documentVersionStatus.intValue() != DocumentVersionStatus.INREVIEW.getValue() && documentVersionStatus.intValue() != DocumentVersionStatus.INVALIDATEDVERSION.getValue() && documentVersionStatus.intValue() != DocumentVersionStatus.DELETED.getValue()) && (revisedDocumentVersionId == null || searchedStatus != null && searchedStatus.intValue() == DocumentVersionStatus.INREVIEW.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.INVALIDATEDVERSION.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.INVALIDATEDALL.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.DELETED.getValue() || revisedDocumentVersionStatus.intValue() == DocumentVersionStatus.ABORTED.getValue() || documentVersionStatus.intValue() != DocumentVersionStatus.INREVIEW.getValue() && documentVersionStatus.intValue() != DocumentVersionStatus.INVALIDATEDVERSION.getValue() && documentVersionStatus.intValue() != DocumentVersionStatus.DELETED.getValue())) continue;
            joinsBeforePrivileges.add(effectiveJoin);
        }
        return joinsBeforePrivileges;
    }

    public Map<Long, String> getDocumentIdToReviewStatusSvgMap(List<DocumentListRow> documentListRows, ReviewCycleInfo reviewCycleInfo, String personVariablesUserLocale, HolidayCalculator holidayCalculator) {
        HashMap<Long, String> documentIdToReviewStatusSvg = new HashMap<Long, String>();
        for (DocumentListRow documentListRow : documentListRows) {
            Long documentId = documentListRow.getDocumentId();
            Triple<String, String, Integer> result = this.smallReviewCycleSvgRenderer.render(documentListRow, reviewCycleInfo, 150.0, 50.0, true, false, false, personVariablesUserLocale, holidayCalculator);
            documentIdToReviewStatusSvg.put(documentId, (String)result.getFirst());
        }
        return documentIdToReviewStatusSvg;
    }

    private Map<Long, List<DocumentListJoin>> groupDocumentListJoinsByDocumentVersionId(List<DocumentListJoin> joins) {
        HashMap<Long, List<DocumentListJoin>> documentVersionIdToJoins = new HashMap<Long, List<DocumentListJoin>>();
        for (DocumentListJoin join : joins) {
            Long documentVersionId = join.getDocumentVersionId();
            if (documentVersionId == null) continue;
            if (!documentVersionIdToJoins.containsKey(documentVersionId)) {
                documentVersionIdToJoins.put(documentVersionId, new ArrayList());
            }
            ((List)documentVersionIdToJoins.get(documentVersionId)).add(join);
        }
        return documentVersionIdToJoins;
    }

    public <T extends IDocumentListJoin> Map<Long, List<T>> groupDocumentListJoinsByDocumentId(List<T> joins) {
        HashMap<Long, List<T>> documentIdToJoins = new HashMap<Long, List<T>>();
        for (IDocumentListJoin join : joins) {
            Long documentId = join.getDocumentId();
            if (documentId == null) continue;
            if (!documentIdToJoins.containsKey(documentId)) {
                documentIdToJoins.put(documentId, new ArrayList());
            }
            ((List)documentIdToJoins.get(documentId)).add(join);
        }
        return documentIdToJoins;
    }

    public <T extends IDocumentListJoin> ReviewCycleInstanceReleasedInfo constructInstanceReleasedInfo(List<T> joins, ReviewCycleInfo cycleInfo, boolean small) {
        ReviewCycleInstanceReleasedInfo instanceReleasedInfo = new ReviewCycleInstanceReleasedInfo();
        if (joins == null) {
            return instanceReleasedInfo;
        }
        IDocumentListJoin someJoin = (IDocumentListJoin)joins.get(0);
        instanceReleasedInfo.setReviewCycleInstanceReleased(someJoin.getReviewCycleInstanceReleased());
        Map<Long, List<T>> cellInstanceReleasedIdToJoins = this.groupInstanceJoinsByCellInstanceReleasedId(joins);
        ArrayList<ReviewCycleCellInstanceReleasedInfo> cellInstanceReleasedInfos = new ArrayList<ReviewCycleCellInstanceReleasedInfo>();
        for (Long cellInstanceReleasedId : cellInstanceReleasedIdToJoins.keySet()) {
            List<T> cellInstanceReleasedJoins = cellInstanceReleasedIdToJoins.get(cellInstanceReleasedId);
            ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo = this.constructCellInstanceReleasedInfo(cellInstanceReleasedIdToJoins.get(cellInstanceReleasedId), cycleInfo, small);
            cellInstanceReleasedInfos.add(cellInstanceReleasedInfo);
        }
        instanceReleasedInfo.setCellInstanceReleasedInfos(cellInstanceReleasedInfos);
        return instanceReleasedInfo;
    }

    private <T extends IDocumentListJoin> Map<Long, List<T>> groupInstanceJoinsByCellInstanceReleasedId(List<T> joins) {
        HashMap<Long, List<T>> cellInstanceReleasedIdToJoins = new HashMap<Long, List<T>>();
        for (IDocumentListJoin join : joins) {
            Long cellInstanceReleasedId = join.getReviewCycleCellInstanceReleasedId();
            if (cellInstanceReleasedId == null) continue;
            if (!cellInstanceReleasedIdToJoins.containsKey(cellInstanceReleasedId)) {
                cellInstanceReleasedIdToJoins.put(cellInstanceReleasedId, new ArrayList());
            }
            ((List)cellInstanceReleasedIdToJoins.get(cellInstanceReleasedId)).add(join);
        }
        return cellInstanceReleasedIdToJoins;
    }

    private <T extends IDocumentListJoin> ReviewCycleCellInstanceReleasedInfo constructCellInstanceReleasedInfo(List<T> joins, ReviewCycleInfo cycleInfo, boolean small) {
        ReviewCycleCellInstanceReleasedInfo info = new ReviewCycleCellInstanceReleasedInfo();
        IDocumentListJoin someJoin = (IDocumentListJoin)joins.get(0);
        ReviewCycleCellInstanceReleased cellInstanceReleased = someJoin.getReviewCycleCellInstanceReleased();
        Long cellId = cellInstanceReleased.getReviewCycleCellId();
        ReviewCycleCell cell = cycleInfo.getCellById(cellId);
        info.setReviewCycleCell(cell);
        info.setReviewCycleCellInstanceReleased(cellInstanceReleased);
        ArrayList<ReviewCycleNodeInstanceReleasedInfo> nodeInstanceReleasedInfos = new ArrayList<ReviewCycleNodeInstanceReleasedInfo>();
        Map<Long, List<T>> nodeInstanceReleasedIdToJoins = this.groupCellInstanceJoinsByNodeInstanceReleasedId(joins);
        for (Long nodeInstanceReleasedId : nodeInstanceReleasedIdToJoins.keySet()) {
            ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo = this.constructNodeInstanceReleasedInfo(nodeInstanceReleasedIdToJoins.get(nodeInstanceReleasedId), cycleInfo, small);
            if (nodeInstanceReleasedInfo == null) continue;
            nodeInstanceReleasedInfos.add(nodeInstanceReleasedInfo);
        }
        info.setNodeInstanceReleasedInfos(nodeInstanceReleasedInfos);
        return info;
    }

    private <T extends IDocumentListJoin> Map<Long, List<T>> groupCellInstanceJoinsByNodeInstanceReleasedId(List<T> joins) {
        HashMap<Long, List<T>> nodeInstanceReleasedIdToJoins = new HashMap<Long, List<T>>();
        for (IDocumentListJoin join : joins) {
            if (join.getReviewCycleNodeInstanceReleasedId() == null) continue;
            Long nodeInstanceReleasedId = join.getReviewCycleNodeInstanceReleasedId();
            if (!nodeInstanceReleasedIdToJoins.containsKey(nodeInstanceReleasedId)) {
                nodeInstanceReleasedIdToJoins.put(nodeInstanceReleasedId, new ArrayList());
            }
            ((List)nodeInstanceReleasedIdToJoins.get(nodeInstanceReleasedId)).add(join);
        }
        return nodeInstanceReleasedIdToJoins;
    }

    private <T extends IDocumentListJoin> ReviewCycleNodeInstanceReleasedInfo constructNodeInstanceReleasedInfo(List<T> joins, ReviewCycleInfo cycleInfo, boolean small) {
        ReviewCycleNodeInstanceReleasedInfo info = new ReviewCycleNodeInstanceReleasedInfo();
        IDocumentListJoin someJoin = (IDocumentListJoin)joins.get(0);
        ReviewCycleNodeInstanceReleased nodeInstanceReleased = someJoin.getReviewCycleNodeInstanceReleased();
        Long nodeId = nodeInstanceReleased.getReviewCycleNodeId();
        ReviewCycleNode node = cycleInfo.getNodeById(nodeId);
        if (node == null) {
            return null;
        }
        info.setNodeInstanceReleased(nodeInstanceReleased);
        info.setNode(node);
        List<T> fullJoins = joins;
        ArrayList<ReviewCycleNodePositionReleasedInfo> nodePositionReleasedInfos = new ArrayList<ReviewCycleNodePositionReleasedInfo>();
        HashSet<Long> nodePositionReleasedIdsAlreadyAdded = new HashSet<Long>();
        for (IDocumentListJoin join : joins) {
            if (join.getReviewCycleNodePositionReleasedId() == null || nodePositionReleasedIdsAlreadyAdded.contains(join.getReviewCycleNodePositionReleasedId())) continue;
            ReviewCycleNodePositionReleasedInfo nodePositionReleasedInfo = new ReviewCycleNodePositionReleasedInfo();
            nodePositionReleasedInfo.setReviewCycleNodePositionReleased(join.getReviewCycleNodePositionReleased());
            nodePositionReleasedInfo.setRealm(join.getRealmId() != null ? join.getRealm() : null);
            nodePositionReleasedInfo.setReviewerParticipant(join.getReviewerParticipant());
            nodePositionReleasedInfo.setReviewerOrganisation(join.getReviewerOrganisation());
            nodePositionReleasedInfo.setReviewerMainPerson(join.getReviewerMainPerson());
            nodePositionReleasedInfos.add(nodePositionReleasedInfo);
            nodePositionReleasedIdsAlreadyAdded.add(join.getReviewCycleNodePositionReleasedId());
        }
        info.setNodePositionReleasedInfos(nodePositionReleasedInfos);
        return info;
    }

    public <T extends IDocumentListJoin> List<DocumentListOtherVersionInfo> constructOtherVersionInfos(DocumentListBaseContext<T> baseContext, ReviewCycleInstanceReleasedInfo instanceReleasedInfo, ReviewCycleInfo cycleInfo, Long documentId, boolean small) {
        ArrayList<DocumentListOtherVersionInfo> infos = new ArrayList<DocumentListOtherVersionInfo>();
        Set versionIds = baseContext.getVersionIdsByDocumentId(documentId);
        for (Long versionId : versionIds) {
            IDocumentListJoin someJoin = baseContext.getSomeJoinForDocumentVersionId(versionId);
            DocumentListOtherVersionInfo info = new DocumentListOtherVersionInfo();
            info.setDocumentVersion(someJoin.getDocumentVersion());
            info.setActiveNodeInstance(someJoin.getReviewCycleNodeInstance());
            List<DocumentListOtherVersionCellResultInfo> cellResultInfos = this.constructCellResultInfos(baseContext, instanceReleasedInfo, cycleInfo, versionId, small);
            info.setCellResultInfos(cellResultInfos);
            infos.add(info);
        }
        return infos;
    }

    private <T extends IDocumentListJoin> List<DocumentListOtherVersionCellResultInfo> constructCellResultInfos(DocumentListBaseContext<T> baseContext, ReviewCycleInstanceReleasedInfo instanceReleasedInfo, ReviewCycleInfo cycleInfo, Long documentVersionId, boolean small) {
        ArrayList<DocumentListOtherVersionCellResultInfo> infos = new ArrayList<DocumentListOtherVersionCellResultInfo>();
        Set cellResultIds = baseContext.getCellResultIdsByDocumentVersionId(documentVersionId);
        for (Long cellResultId : cellResultIds) {
            DocumentListOtherVersionCellResultInfo info = new DocumentListOtherVersionCellResultInfo();
            IDocumentListJoin someJoin = baseContext.getSomeJoinForCellResultId(cellResultId);
            Long cellId = someJoin.getReviewCycleCellResultReviewCycleCellId();
            ReviewCycleCell cell = cycleInfo.getCellById(cellId);
            Long cycleId = cell.getReviewCycleId();
            ReviewCycle cycle = cycleInfo.getCycleById(cycleId);
            ReviewCycleCellResult cellResult = someJoin.getReviewCycleCellResult();
            info.setReviewCycle(cycle);
            info.setReviewCycleCell(cell);
            info.setCellResult(cellResult);
            List<DocumentListOtherVersionNodeResultInfo> nodeResultInfos = this.constructNodeResultInfos(baseContext, instanceReleasedInfo, cycleInfo, cellResultId, small);
            info.setNodeResultInfos(nodeResultInfos);
            infos.add(info);
        }
        return infos;
    }

    private <T extends IDocumentListJoin> List<DocumentListOtherVersionNodeResultInfo> constructNodeResultInfos(DocumentListBaseContext<T> baseContext, ReviewCycleInstanceReleasedInfo instanceReleasedInfo, ReviewCycleInfo cycleInfo, Long cellResultId, boolean small) {
        ArrayList<DocumentListOtherVersionNodeResultInfo> infos = new ArrayList<DocumentListOtherVersionNodeResultInfo>();
        Set nodeResultIds = baseContext.getNodeResultIdsByCellResultId(cellResultId);
        for (Long nodeResultId : nodeResultIds) {
            IDocumentListJoin someJoin = baseContext.getSomeJoinForNodeResultId(nodeResultId);
            Long reviewCycleNodeId = someJoin.getReviewCycleNodeResultReviewCycleNodeId();
            ReviewCycleNode node = cycleInfo.getNodeById(reviewCycleNodeId);
            ReviewCycleNodeResult nodeResult = someJoin.getReviewCycleNodeResult();
            ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo = instanceReleasedInfo.getByNodeId(reviewCycleNodeId);
            ReviewCycleNodeInstanceReleased nodeInstanceReleased = nodeInstanceReleasedInfo != null ? nodeInstanceReleasedInfo.getNodeInstanceReleased() : null;
            DocumentListOtherVersionNodeResultInfo info = new DocumentListOtherVersionNodeResultInfo();
            info.setNode(node);
            info.setNodeResult(nodeResult);
            info.setDepartureNodeInstanceReleased(someJoin.getAllNodeDepNodeInstanceReleased());
            info.setDepartureObjectListReleaseSignature(someJoin.getAllNodeDepSignature());
            info.setReviewCycleNodeInstanceReleased(nodeInstanceReleased);
            List<DocumentListOtherVersionPositionResultInfo> positionResultInfos = this.constructPositionResultInfos(baseContext, nodeResultId, small);
            info.setPositionResultInfos(positionResultInfos);
            infos.add(info);
        }
        return infos;
    }

    private <T extends IDocumentListJoin> List<DocumentListOtherVersionPositionResultInfo> constructPositionResultInfos(DocumentListBaseContext<T> baseContext, Long nodeResultId, boolean small) {
        ArrayList<DocumentListOtherVersionPositionResultInfo> infos = new ArrayList<DocumentListOtherVersionPositionResultInfo>();
        List joins = baseContext.getJoinsByNodeResultId(nodeResultId);
        for (IDocumentListJoin join : joins) {
            if (join.getReviewCyclePositionResultId() == null) continue;
            DocumentListOtherVersionPositionResultInfo info = new DocumentListOtherVersionPositionResultInfo();
            ReviewCyclePositionResult positionResult = join.getReviewCyclePositionResult();
            info.setPositionResult(positionResult);
            if (!small) {
                DocumentListJoin documentListJoin = (DocumentListJoin)join;
                info.setRealm(documentListJoin.getRealm());
                info.setReviewerParticipant(documentListJoin.getReviewerParticipant());
                info.setReviewerOrganisation(documentListJoin.getReviewerOrganisation());
                info.setReviewerPerson(documentListJoin.getReviewerPerson());
                info.setReviewerMainPerson(documentListJoin.getReviewerMainPerson());
                info.setAttachedTask(documentListJoin.getIsAttachedResultId() != null);
            }
            infos.add(info);
        }
        return infos;
    }

    private void doInvalidateDocumentVersion(DebugContext debugContext, ReviewCycleInfo cycleInfo, Map<Long, ReviewCycleResultOption> idToResultOption, DocumentListRow documentListRow, String password, String comment, ReviewCycleResultOption resultOption, ProjectParticipant signer, Certificate certificate, boolean isInvalidationUpload, boolean reactivateLastReleasedVersion, Boolean authorized) {
        Long documentVersionId = documentListRow.getDocumentVersionId();
        String documentVersionName = documentListRow.getDocumentVersionName();
        debugContext.openDebugNode("doInvalidateDocumentVersion (documentVersion: id = [" + documentVersionId + "], name = [" + documentVersionName + "]");
        Long nodeId = documentListRow.getReviewCycleNodeInstanceNodeId();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.getByNodeAndDocumentVersion(nodeId, documentVersionId);
        nodeResult.setReviewCycleResultOptionId(resultOption.getId());
        ReviewCyclePositionResult positionResult = new ReviewCyclePositionResult();
        positionResult.setActiveObjectListId(documentListRow.getObjectListReleaseId());
        positionResult.setActiveDocumentListId(documentListRow.getDocumentListReleaseId());
        positionResult.setComment(comment);
        positionResult.setDocumentVersionId(documentListRow.getDocumentVersionId());
        positionResult.setProjectParticipantId(signer.getId());
        positionResult.setResultDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        positionResult.setReviewCycleNodeId(nodeId);
        positionResult.setReviewCycleNodeResultId(nodeResult.getId());
        positionResult.setIsAuthorized(authorized);
        positionResult.setReviewCycleResultOptionId(resultOption.getId());
        positionResult = (ReviewCyclePositionResult)this.reviewCyclePositionResultDAO.save(positionResult);
        debugContext.addSavePositionResultMessage(positionResult);
        positionResult.setDigestCalculatorId(null);
        positionResult.setDigest(this.getPositionResultHash(positionResult, null));
        this.reviewCyclePositionResultDAO.update(positionResult);
        debugContext.addUpdateMessage(positionResult.getId(), "PositionResult", "(set digest)");
        Signature signature = this.signatureCalculator.createSignature(signer, comment, certificate, password);
        signature = (Signature)this.signatureDAO.save(signature);
        debugContext.addMessageSaveSignature(signature);
        positionResult.setSignatureId(signature.getId());
        this.reviewCyclePositionResultDAO.update(positionResult);
        debugContext.addUpdateMessage(positionResult.getId(), "PositionResult", "(set signatureId = [" + positionResult.getSignatureId() + "]");
        this.invalidateDocumentVersion2(debugContext, cycleInfo, idToResultOption, documentListRow, nodeResult, resultOption, isInvalidationUpload, reactivateLastReleasedVersion);
        debugContext.closeDebugNode();
    }

    private void invalidateDocumentVersion2(DebugContext debugContext, ReviewCycleInfo cycleInfo, Map<Long, ReviewCycleResultOption> idToResultOption, DocumentListRow documentListRow, ReviewCycleNodeResult nodeResult, ReviewCycleResultOption resultOption, boolean isInvalidationUpload, boolean reactivateLastReleasedVersion) {
        DocumentVersionStatus sourceDocumentVersionStatus;
        Long sourceDocumentVersionId;
        debugContext.openDebugNode("invalidateDocumentVersion2");
        Long documentVersionId = documentListRow.getDocumentVersionId();
        Long projectId = documentListRow.getProjectId();
        List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
        Project project = (Project)this.projectDAO.get(projectId);
        Long localisationId = project.getLocalisationId();
        Long nodeId = documentListRow.getReviewCycleNodeInstanceNodeId();
        this.taskUtils.removeTasks(debugContext, documentVersionId, projectId);
        ReviewCycleInstanceReleasedInfo instanceReleasedInfo = documentListRow.getInstanceReleasedInfo();
        Long instanceReleasedId = instanceReleasedInfo.getInstanceReleasedId();
        ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo = instanceReleasedInfo.getByNodeId(nodeId);
        if (nodeInstanceReleasedInfo == null || nodeInstanceReleasedInfo.getNodeInstanceReleased() == null) {
            log.error("invalidateDocumentVersion2: projectId=" + projectId + " documentVersionId=" + documentVersionId + " instanceReleasedId=" + instanceReleasedId + " nodeId=" + nodeId + (nodeInstanceReleasedInfo == null ? " nodeInstanceReleasedInfo == null" : "nodeInstanceReleased == null"));
        }
        ReviewCycleNodeInstanceReleased nodeInstanceReleased = nodeInstanceReleasedInfo.getNodeInstanceReleased();
        Long cellInstanceReleasedId = nodeInstanceReleasedInfo.getCellInstanceReleasedId();
        ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo = instanceReleasedInfo.getByCellInstanceReleasedId(cellInstanceReleasedId);
        ReviewCycleNodeInstanceReleasedInfo lastNodeInstanceReleasedInfo = cellInstanceReleasedInfo.getLastNodeInstanceReleasedInfo();
        ReviewCycleNodeInstanceReleased lastNodeInstanceReleased = lastNodeInstanceReleasedInfo.getNodeInstanceReleased();
        Long lastNodeInstanceReleasedId = lastNodeInstanceReleased.getId();
        Long objectListReleaseId = documentListRow.getObjectListReleaseId();
        Long objectPlannerId = documentListRow.getObjectPlannerId();
        Long objectPlannerReleaseId = documentListRow.getObjectPlannerReleaseId();
        DocumentVersion documentVersion = (DocumentVersion)this.documentVersionDAO.get(documentVersionId);
        Long lastNodeId = lastNodeInstanceReleasedInfo.getNodeId();
        this.reviewUtils.finishReviewCycleNode(debugContext, null, nodeInstanceReleased, nodeResult, objectListReleaseId, objectPlannerId, objectPlannerReleaseId, documentVersion, lastNodeId);
        ReviewCycle cycle = cycleInfo.getCycleByNodeId(nodeId);
        if (nodeInstanceReleased.getId().longValue() != lastNodeInstanceReleasedInfo.getNodeInstanceReleasedId().longValue() && (objectPlannerReleaseId != null || cycle.getDocumentInvalidationResultOptionId() == null || cycle.getDocumentInvalidationResultOptionId().longValue() != resultOption.getId().longValue())) {
            this.reviewUtils.moveDocumentVersionToNode(debugContext, null, lastNodeInstanceReleased, objectListReleaseId, objectPlannerReleaseId, instanceReleasedId, nodeResult, documentVersion);
        }
        DocumentVersion sourceDocumentVersion = (sourceDocumentVersionId = documentListRow.getCellConnectionResultSourceDocumentVersionId()) != null ? (DocumentVersion)this.documentVersionDAO.get(sourceDocumentVersionId) : null;
        DocumentVersionStatus documentVersionStatus = sourceDocumentVersionStatus = sourceDocumentVersion != null ? DocumentVersionStatus.getByValue((Integer)sourceDocumentVersion.getStatus()) : null;
        if (cycle.getDocumentVersionDeletedOptionId() != null && cycle.getDocumentVersionDeletedOptionId().longValue() == resultOption.getId().longValue()) {
            boolean hasDocumentVersions = this.setDocumentVersionToDeleted(documentVersion);
            if (sourceDocumentVersion != null && !reactivateLastReleasedVersion) {
                lastNodeInstanceReleased = this.reviewCycleNodeInstanceReleasedDAO.getByDocumentVersionAndObjectListRelease(sourceDocumentVersionId, objectListReleaseId);
                lastNodeInstanceReleasedId = lastNodeInstanceReleased.getId();
                this.taskUtils.generateSelectCellTask(debugContext, objectListReleaseId, sourceDocumentVersionId, lastNodeInstanceReleased.getId(), false, false);
            } else {
                Long documentReleaseId = documentListRow.getDocumentReleaseId();
                if (documentReleaseId != null && documentListRow.getDocumentReleaseStartDate() != null && !hasDocumentVersions) {
                    GenerateTaskEmailSnippetsContextImpl taskContext = new GenerateTaskEmailSnippetsContextImpl(null);
                    List<ProjectParticipation> projectRoleParticipations = this.projectParticipationDAO.getParticipationsByProjectAndRoleTypeAndAction(projectId, RoleTypeEnum.PROJECT_SURVEILLANT.getValue(), Action.MONITOR_LATE_REVIEWS.getName());
                    Set<Long> projectRoleParticipationIds = ContainerHelper.getPersistentIdsSet(projectRoleParticipations);
                    ObjectPlannerRelease objectPlannerRelease = (ObjectPlannerRelease)this.objectPlannerReleaseDAO.get(objectPlannerReleaseId);
                    ReviewCycleInstanceReleased instanceReleased = documentListRow.getInstanceReleasedInfo().getInstanceReleased();
                    Document document = documentListRow.getDocument();
                    DocumentRelease documentRelease = documentListRow.getDocumentRelease();
                    this.taskUtils.generateReviewCycleEntryTask(debugContext, taskContext, null, projectHolidays, projectRoleParticipationIds, localisationId, objectPlannerRelease, instanceReleased, document, documentRelease);
                }
            }
            if (reactivateLastReleasedVersion && (sourceDocumentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || sourceDocumentVersionStatus == DocumentVersionStatus.ASBUILT)) {
                List<ReviewCycleNodeResult> nodeResults = this.reviewCycleNodeResultDAO.getByDocumentVersionSortedByPosition(sourceDocumentVersionId);
                ReviewCycleNodeResult lastNodeResult = nodeResults.size() > 0 ? nodeResults.get(nodeResults.size() - 1) : null;
                List<ReviewCyclePositionResult> positionResults = this.reviewCyclePositionResultDAO.getByDocumentVersionWithoutCommentReferenceSortedByPosition(sourceDocumentVersionId);
                ReviewCycleResultOption lastStatusChangingPositionResultOption = this.getLastStatusChangingPositionResultOption(positionResults, idToResultOption);
                ReviewCycleResultOption lastResultOptionBeforeInvalidation = this.getLastResultOptionBeforeInvalidation(positionResults, idToResultOption);
                if (sourceDocumentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || sourceDocumentVersionStatus == DocumentVersionStatus.ASBUILT || sourceDocumentVersionStatus == DocumentVersionStatus.REPLACED) {
                    DocumentVersionStatus lastStatusChangingStatus;
                    if (lastResultOptionBeforeInvalidation != null) {
                        ReviewCycleCellResult lastCellResult = (ReviewCycleCellResult)this.reviewCycleCellResultDAO.get(lastNodeResult.getReviewCycleCellResultId());
                        Long lastNodeResultNodeId = lastNodeResult.getReviewCycleNodeId();
                        ReviewCycleNode lastNode = cycleInfo.getNodeById(lastNodeResultNodeId);
                        lastCellResult.setReviewCycleResultOptionId(lastResultOptionBeforeInvalidation.getId());
                        if (cycleInfo.isEndNode(lastNode.getId())) {
                            lastCellResult.setNextReviewCycleCellId(null);
                            lastCellResult.setDepartureDate(null);
                        }
                        this.reviewCycleCellResultDAO.update(lastCellResult);
                        debugContext.addUpdateReviewCycleCellResultMessage(lastCellResult);
                    }
                    if ((lastStatusChangingStatus = DocumentVersionStatus.getByValue((Integer)lastStatusChangingPositionResultOption.getDocumentVersionStatus())) == DocumentVersionStatus.INREVIEW || lastStatusChangingStatus == DocumentVersionStatus.RELEASEDPOSITIV || lastStatusChangingStatus == DocumentVersionStatus.RELEASEDNEGATIV) {
                        sourceDocumentVersion.setStatus(Integer.valueOf(lastStatusChangingStatus.getValue()));
                    } else {
                        sourceDocumentVersion.setStatus(Integer.valueOf(DocumentVersionStatus.INREVIEW.getValue()));
                    }
                    this.documentVersionDAO.update(sourceDocumentVersion);
                    debugContext.addUpdateDocumentVersionStatusStatusChange(sourceDocumentVersion);
                    if (lastNodeResult.getReviewCycleResultOptionId() != null) {
                        lastNodeResult.setReviewCycleResultOptionId(null);
                        lastNodeResult.setFinished(Boolean.valueOf(false));
                        lastNodeResult.setDepartureDate(null);
                        lastNodeResult.setDepartureObjectListId(null);
                        this.reviewCycleNodeResultDAO.update(lastNodeResult);
                        debugContext.addUpdateNodeResultMessage(lastNodeResult);
                        this.taskUtils.insertCreateMissingTasks(debugContext, cycleInfo, idToResultOption, lastNodeResult, sourceDocumentVersion, true, 0);
                    } else if (nodeResults.size() >= 2 && sourceDocumentVersionStatus != DocumentVersionStatus.ASBUILT && sourceDocumentVersionStatus != DocumentVersionStatus.REPLACED) {
                        ReviewCycleNodeResult lastActiveNodeResult = nodeResults.get(nodeResults.size() - 2);
                        lastActiveNodeResult.setReviewCycleResultOptionId(null);
                        lastActiveNodeResult.setFinished(Boolean.valueOf(false));
                        lastActiveNodeResult.setDepartureDate(null);
                        lastActiveNodeResult.setDepartureObjectListId(null);
                        this.reviewCycleNodeResultDAO.update(lastActiveNodeResult);
                        debugContext.addUpdateNodeResultMessage(lastActiveNodeResult);
                        this.reviewCycleNodeResultDAO.delete(lastNodeResult.getId());
                        debugContext.addDeleteNodeResultMessage(lastNodeResult);
                        Long oldActualNodeInstanceId = sourceDocumentVersion.getActiveNodeInstanceId();
                        ReviewCycleNodeInstance actualNodeInstance = this.reviewCycleNodeInstanceDAO.getSiblingByNode(oldActualNodeInstanceId, lastActiveNodeResult.getReviewCycleNodeId());
                        sourceDocumentVersion.setActiveNodeInstanceId(actualNodeInstance.getId());
                        this.documentVersionDAO.update(sourceDocumentVersion);
                        debugContext.addUpdateDocumentVersionMessage(sourceDocumentVersion);
                        this.taskUtils.insertCreateMissingTasks(debugContext, cycleInfo, idToResultOption, lastActiveNodeResult, sourceDocumentVersion, true, 0);
                    }
                    documentVersion.setReactivatedDocumentVersionId(sourceDocumentVersionId);
                    this.documentVersionDAO.update(documentVersion);
                    debugContext.addUpdateDocumentVersionMessage(documentVersion);
                }
            }
        } else if (cycle.getDocumentVersionInvalidationResultOptionId() != null && cycle.getDocumentVersionInvalidationResultOptionId().longValue() == resultOption.getId().longValue() && !isInvalidationUpload) {
            List<DocumentVersion> revisions = this.documentVersionDAO.getRevisedDocumentVersionSourcesSortedByUploaded(documentVersionId);
            DocumentVersion lastRevision = revisions.size() > 0 ? revisions.get(revisions.size() - 1) : null;
            DocumentVersionStatus lastRevisionStatus = lastRevision != null ? DocumentVersionStatus.getByValue((Integer)lastRevision.getStatus()) : null;
            List<SelectCellConnectionTask> selectCellConnectionTasks = this.selectCellConnectionTaskDAO.getByDocumentVersion(documentVersionId);
            if ((lastRevision == null || lastRevisionStatus == DocumentVersionStatus.DELETED || lastRevisionStatus == DocumentVersionStatus.INVALIDATEDALL) && selectCellConnectionTasks.size() == 0) {
                this.taskUtils.generateSelectCellTask(debugContext, objectListReleaseId, documentVersionId, lastNodeInstanceReleasedId, false, false);
            }
        } else if (cycle.getDocumentInvalidationResultOptionId() != null && cycle.getDocumentInvalidationResultOptionId().longValue() == resultOption.getId().longValue() || cycle.getDocumentVersionAbortedResultOptionId() != null && cycle.getDocumentVersionAbortedResultOptionId().longValue() == resultOption.getId().longValue()) {
            if (sourceDocumentVersion != null) {
                this.taskUtils.removeTasks(debugContext, sourceDocumentVersionId, projectId);
            }
            List<DocumentTask> documentTasks = this.documentTaskDAO.getByDocument(documentVersion.getDocumentId());
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (DocumentTask documentTask : documentTasks) {
                taskIds.add(documentTask.getTaskId());
                debugContext.addDeleteDocumentTaskMessage(documentTask);
            }
            this.taskUtils.deleteReviewCycleEntryTasks(taskIds);
        }
        debugContext.closeDebugNode();
    }

    private boolean setDocumentVersionToDeleted(DocumentVersion documentVersion) {
        documentVersion.setStatus(Integer.valueOf(DocumentVersionStatus.DELETED.getValue()));
        this.documentVersionDAO.update(documentVersion);
        List<DocumentVersion> allVersions = this.documentVersionDAO.getByDocument(documentVersion.getDocumentId());
        boolean foundAny = false;
        for (DocumentVersion allVersion : allVersions) {
            if (allVersion.getStatus().intValue() == DocumentVersionStatus.DELETED.getValue()) continue;
            foundAny = true;
        }
        if (!foundAny) {
            Document document = (Document)this.documentDAO.get(documentVersion.getDocumentId());
            document.setHasDocumentVersions(Boolean.valueOf(false));
            this.documentDAO.update(document);
        }
        return foundAny;
    }

    private ReviewCycleResultOption getLastStatusChangingPositionResultOption(List<ReviewCyclePositionResult> positionResults, Map<Long, ReviewCycleResultOption> idToResultOption) {
        ReviewCycleResultOption lastStatusChangingPositionResultOption = null;
        for (ReviewCyclePositionResult positionResult : positionResults) {
            DocumentVersionStatus resultOptionStatus;
            Long resultOptionId = positionResult.getReviewCycleResultOptionId();
            ReviewCycleResultOption resultOption = resultOptionId != null ? idToResultOption.get(resultOptionId) : null;
            DocumentVersionStatus documentVersionStatus = resultOptionStatus = resultOption != null ? DocumentVersionStatus.getByValue((Integer)resultOption.getDocumentVersionStatus()) : null;
            if (resultOption == null || resultOptionStatus == null || resultOptionStatus == DocumentVersionStatus.INVALIDATEDVERSION) continue;
            lastStatusChangingPositionResultOption = resultOption;
        }
        return lastStatusChangingPositionResultOption;
    }

    private ReviewCycleResultOption getLastResultOptionBeforeInvalidation(List<ReviewCyclePositionResult> positionResults, Map<Long, ReviewCycleResultOption> idToResultOption) {
        ReviewCycleResultOption lastResultOptionBeforeInvalidation = null;
        for (ReviewCyclePositionResult positionResult : positionResults) {
            DocumentVersionStatus resultOptionStatus;
            Long resultOptionId = positionResult.getReviewCycleResultOptionId();
            ReviewCycleResultOption resultOption = resultOptionId != null ? idToResultOption.get(resultOptionId) : null;
            DocumentVersionStatus documentVersionStatus = resultOptionStatus = resultOption != null ? DocumentVersionStatus.getByValue((Integer)resultOption.getDocumentVersionStatus()) : null;
            if (resultOption == null || resultOptionStatus != null && resultOptionStatus != DocumentVersionStatus.INVALIDATEDVERSION) continue;
            lastResultOptionBeforeInvalidation = resultOption;
        }
        return lastResultOptionBeforeInvalidation;
    }

    private String getPositionResultHash(ReviewCyclePositionResult positionResult, Map<Long, Attachment> attachments) {
        if (positionResult.getDigest() != null) {
            return positionResult.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        try {
            DigestOutputStream dos = new DigestOutputStream(osd, MessageDigest.getInstance("SHA1", "BC"));
            dos.write(("id=" + positionResult.getId()).getBytes());
            dos.write(("comment=" + positionResult.getComment()).getBytes());
            dos.write(("documentVersionId=" + positionResult.getDocumentVersionId()).getBytes());
            if (positionResult.getActiveDocumentListId() != null) {
                dos.write(("activeDocumentListId=" + positionResult.getActiveDocumentListId()).getBytes());
            }
            dos.write(("activeObjectListId=" + positionResult.getActiveObjectListId()).getBytes());
            dos.write(("projectParticipantId=" + positionResult.getProjectParticipantId()).getBytes());
            if (positionResult.getRealmId() != null) {
                dos.write(("realmId=" + positionResult.getRealmId()).getBytes());
            }
            if (positionResult.getCommentReferenceId() == null || positionResult.getReviewCycleNodeResultId() != null) {
                dos.write(("reviewCycleNodeResultId=" + positionResult.getReviewCycleNodeResultId()).getBytes());
            }
            if (positionResult.getReviewCycleResultOptionId() != null) {
                dos.write(("reviewCycleResultOptionId=" + positionResult.getReviewCycleResultOptionId()).getBytes());
            }
            if (positionResult.getReviewCycleCommentOptionId() != null) {
                dos.write(("reviewCycleCommentOptionId=" + positionResult.getReviewCycleCommentOptionId()).getBytes());
            }
            dos.write(("resultDate=" + positionResult.getResultDate()).getBytes());
            dos.write("attachments=".getBytes());
            if (attachments != null) {
                Object[] a = attachments.keySet().toArray();
                Arrays.sort(a);
                for (int i = 0; i < a.length; ++i) {
                    if (attachments.get((Long)a[i]).getDigest() == null) continue;
                    dos.write(((Integer)a[i]).toString().getBytes());
                    dos.write("=".getBytes());
                    dos.write(attachments.get((Long)a[i]).getDigest().getBytes());
                    dos.write("\n".getBytes());
                }
            }
            dos.write(("reviewCycleNodeId=" + positionResult.getReviewCycleNodeId()).getBytes());
            String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException("Hashing DocumentList = ", e);
        }
    }
}

