/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OriginalDocumentTask;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.guiService.TaskService;
import at.cdes.api.joinDto.CertificateOrgPersonJoin;
import at.cdes.api.joinDto.IReviewTaskJoin;
import at.cdes.api.joinDto.PlanDeliverReleaseJoin;
import at.cdes.api.joinDto.ReviewTaskDoneJoin;
import at.cdes.api.joinDto.ReviewTaskJoin;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.task.dto.ReviewTaskPageInfo;
import at.cdes.api.task.dto.Task;
import at.cdes.api.task.dto.TaskCountLine;
import at.cdes.api.task.dto.TaskCounts;
import at.cdes.api.task.searchModel.TaskSearchModel;
import at.cdes.api.task.voc.TaskDeputyMode;
import at.cdes.api.task.voc.TaskSearchMode;
import at.cdes.api.task.voc.TaskType;
import at.cdes.api.voc.TaskEmailSnippetType;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.AttachedReviewTaskDAO;
import at.cdes.impl.dao.AttachedReviewTaskDoneDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.OriginalDocumentTaskDAO;
import at.cdes.impl.dao.OriginalDocumentTaskDoneDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDoneDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDoneDAO;
import at.cdes.impl.dao.ReviewTaskDAO;
import at.cdes.impl.dao.ReviewTaskDoneDAO;
import at.cdes.impl.dao.SelectCellConnectionTaskDAO;
import at.cdes.impl.dao.SelectCellConnectionTaskDoneDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.dao.jdbc.JdbcReviewCycleDAO;
import at.cdes.impl.dao.unionComponent.PlanDeliverReleaseComponent;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.export.review.ReviewTaskPdfCallable;
import at.cdes.impl.export.review.ReviewTaskPdfExporter;
import at.cdes.impl.export.review.ReviewTaskXlsCallable;
import at.cdes.impl.export.review.ReviewTaskXlsExporter;
import at.cdes.impl.reviewCycle.ReviewCycleContext;
import at.cdes.impl.reviewCycle.ReviewTaskContext;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.task.TaskHelper;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.BatchedDAOGetter;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.holiday.HolidayCalculatorFactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final Logger perfLog = LoggerFactory.getLogger((String)"at.cdes.impl.service.TaskServiceImpl_PerfLog");
    private static final Logger futureEmailLog = LoggerFactory.getLogger((String)"at.cdes.impl.service.TaskServiceImpl_FutureEmail");
    private ActionDAO actionDAO;
    private AttachedReviewTaskDAO attachedReviewTaskDAO;
    private AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO;
    private Boolean disableTaskCounts;
    private DocumentTaskDAO documentTaskDAO;
    private DocumentDAO documentDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentVersionTaskDAO documentVersionTaskDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private Boolean enableCustomerLogo;
    private FutureEmailDAO futureEmailDAO;
    private IOneTimeScheduler oneTimeScheduler;
    private OrganisationPersonDAO organisationPersonDAO;
    private OriginalDocumentTaskDAO originalDocumentTaskDAO;
    private OriginalDocumentTaskDoneDAO originalDocumentTaskDoneDAO;
    private PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO;
    private PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO;
    private Boolean reversePreduration;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO;
    private ReviewCyclePlottTaskDAO reviewCyclePlottTaskDAO;
    private ReviewCyclePlottTaskDoneDAO reviewCyclePlottTaskDoneDAO;
    private ReviewTaskDAO reviewTaskDAO;
    private ReviewTaskDoneDAO reviewTaskDoneDAO;
    private ReviewTaskPdfExporter reviewTaskPdfExporter;
    private ReviewTaskXlsExporter reviewTaskXlsExporter;
    private SelectCellConnectionTaskDAO selectCellConnectionTaskDAO;
    private SelectCellConnectionTaskDoneDAO selectCellConnectionTaskDoneDAO;
    private int sqlQueryBatchSize;
    private TaskDAO taskDAO;
    private ProjectDAO projectDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private TaskEmailSnippetDAO taskEmailSnippetDAO;
    private TaskUtils taskUtils;
    private CertificateRequestDAO certificateRequestDAO;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setAttachedReviewTaskDAO(AttachedReviewTaskDAO attachedReviewTaskDAO) {
        this.attachedReviewTaskDAO = attachedReviewTaskDAO;
    }

    public void setAttachedReviewTaskDoneDAO(AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO) {
        this.attachedReviewTaskDoneDAO = attachedReviewTaskDoneDAO;
    }

    public void setDisableTaskCounts(Boolean disableTaskCounts) {
        this.disableTaskCounts = disableTaskCounts;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionTaskDAO(DocumentVersionTaskDAO documentVersionTaskDAO) {
        this.documentVersionTaskDAO = documentVersionTaskDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOriginalDocumentTaskDAO(OriginalDocumentTaskDAO originalDocumentTaskDAO) {
        this.originalDocumentTaskDAO = originalDocumentTaskDAO;
    }

    public void setOriginalDocumentTaskDoneDAO(OriginalDocumentTaskDoneDAO originalDocumentTaskDoneDAO) {
        this.originalDocumentTaskDoneDAO = originalDocumentTaskDoneDAO;
    }

    public void setPlotOrderAcceptanceTaskDAO(PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO) {
        this.plotOrderAcceptanceTaskDAO = plotOrderAcceptanceTaskDAO;
    }

    public void setPlotOrderAcceptanceTaskDoneDAO(PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO) {
        this.plotOrderAcceptanceTaskDoneDAO = plotOrderAcceptanceTaskDoneDAO;
    }

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setReviewCycleEntryTaskDAO(ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO) {
        this.reviewCycleEntryTaskDAO = reviewCycleEntryTaskDAO;
    }

    public void setReviewCyclePlotTaskDAO(ReviewCyclePlottTaskDAO reviewCyclePlottTaskDAO) {
        this.reviewCyclePlottTaskDAO = reviewCyclePlottTaskDAO;
    }

    public void setReviewCyclePlotTaskDoneDAO(ReviewCyclePlottTaskDoneDAO reviewCyclePlottTaskDoneDAO) {
        this.reviewCyclePlottTaskDoneDAO = reviewCyclePlottTaskDoneDAO;
    }

    public void setReviewTaskDAO(ReviewTaskDAO reviewTaskDAO) {
        this.reviewTaskDAO = reviewTaskDAO;
    }

    public void setReviewTaskDoneDAO(ReviewTaskDoneDAO reviewTaskDoneDAO) {
        this.reviewTaskDoneDAO = reviewTaskDoneDAO;
    }

    public void setReviewTaskPdfExporter(ReviewTaskPdfExporter reviewTaskPdfExporter) {
        this.reviewTaskPdfExporter = reviewTaskPdfExporter;
    }

    public void setReviewTaskXlsExporter(ReviewTaskXlsExporter reviewTaskXlsExporter) {
        this.reviewTaskXlsExporter = reviewTaskXlsExporter;
    }

    public void setSelectCellConnectionTaskDAO(SelectCellConnectionTaskDAO selectCellConnectionTaskDAO) {
        this.selectCellConnectionTaskDAO = selectCellConnectionTaskDAO;
    }

    public void setSelectCellConnectionTaskDoneDAO(SelectCellConnectionTaskDoneDAO selectCellConnectionTaskDoneDAO) {
        this.selectCellConnectionTaskDoneDAO = selectCellConnectionTaskDoneDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setTaskEmailSnippetDAO(TaskEmailSnippetDAO taskEmailSnippetDAO) {
        this.taskEmailSnippetDAO = taskEmailSnippetDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void updateReviewTasks(ResultSummary resultSummary, final Long projectId, final Long subProjectId, List<Long> unreleasedDocumentIds) {
        if (log.isDebugEnabled()) {
            log.debug("Called updateReviewTask for projectId [" + projectId + "], subProjectId [" + subProjectId + "], and " + unreleasedDocumentIds.size() + " unreleased documents.");
        }
        if (unreleasedDocumentIds.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("About to execute the plan deliver release join.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Will query PlanDeliverReleaseJoin for document ids [" + unreleasedDocumentIds + "]");
            }
            List<PlanDeliverReleaseJoin> releaseJoins = QueryHelper.executeDAOGetter(unreleasedDocumentIds, this.sqlQueryBatchSize / 10, new BatchedDAOGetter<PlanDeliverReleaseJoin, Long>(){

                @Override
                public List<PlanDeliverReleaseJoin> execute(List<Long> ids) {
                    return TaskServiceImpl.this.reviewCycleDAO.getPlanDeliverReleaseJoin(projectId, subProjectId, ids);
                }
            });
            if (log.isDebugEnabled()) {
                log.debug("Received " + releaseJoins.size() + " tuples.");
            }
            List<PlanDeliverReleaseJoin> reviewCycleJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.REVIEW_CYCLE, releaseJoins, resultSummary);
            reviewCycleJoins.addAll(JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.RESULT_OPTION, releaseJoins, resultSummary));
            ReviewCycleContext cycleContext = new ReviewCycleContext(reviewCycleJoins);
            List<PlanDeliverReleaseJoin> documentVersionTaskJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.DOCUMENT_VERSION_TASK, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> documentJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.DOCUMENT, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> participationJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.DOCUMENT_VERSION_PARTICIPATION, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> futureEmailJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.DOCUMENT_VERSION_FUTURE_EMAIL, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> entryTaskJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.ENTRY_TASK, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> objectPlannerJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.DOCUMENT_OBJECT_PLANNER, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> projectRoleJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.PROJECT_ROLE, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> additionalInfoJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.REVIEW_CYCLE_NODE_RESULT, releaseJoins, resultSummary);
            List<PlanDeliverReleaseJoin> projectHolidayJoins = JdbcReviewCycleDAO.extractForComponent(PlanDeliverReleaseComponent.PROJECT_HOLIDAY, releaseJoins, resultSummary);
            ArrayList<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
            for (PlanDeliverReleaseJoin planDeliverReleaseJoin : projectHolidayJoins) {
                projectHolidays.add(planDeliverReleaseJoin.getProjectHoliday());
            }
            if (log.isDebugEnabled()) {
                log.debug(".. Extracted joins: ReviewCycleJoins: " + reviewCycleJoins.size() + ", docVersionTaskJoins: " + documentVersionTaskJoins.size() + ", documentJoins: " + documentJoins.size() + ", participationJoins: " + participationJoins.size());
                log.debug("..................: futureEmailJoins: " + futureEmailJoins.size() + ", entryTaskJoins: " + entryTaskJoins.size() + ", objectPlannerJoins: " + objectPlannerJoins.size() + ", projectRoleJoins: ", (Object)(projectRoleJoins.size() + ", holidayJoins: " + projectHolidayJoins));
            }
            HashSet<Long> unreleasedDocumentIdsSet = new HashSet<Long>();
            unreleasedDocumentIdsSet.addAll(unreleasedDocumentIds);
            if (unreleasedDocumentIdsSet.size() != unreleasedDocumentIds.size()) {
                log.error("unreleasedDocumentIds list contains duplicates!");
                for (Long documentId : unreleasedDocumentIds) {
                    log.error("===> " + documentId);
                }
                throw new IllegalArgumentException("Will abort NOW to avoid data inconsistencies (duplicate tasks).");
            }
            ReviewTaskContext reviewTaskContext = new ReviewTaskContext(documentJoins, documentVersionTaskJoins, futureEmailJoins, entryTaskJoins, objectPlannerJoins, projectRoleJoins, projectHolidays);
            this.updateReviewTasksOfDocument(cycleContext, reviewTaskContext, documentVersionTaskJoins, participationJoins, futureEmailJoins, projectId, subProjectId, projectHolidays, unreleasedDocumentIds, additionalInfoJoins);
            if (log.isDebugEnabled()) {
                log.debug("Finished calling updateReviewTasksOfDocument, will call updateDocumentTasksOfDocuments");
            }
            this.updateDocumentTasksOfDocuments(reviewTaskContext, unreleasedDocumentIds);
            if (log.isDebugEnabled()) {
                log.debug("Will finally call commitAll.");
            }
            reviewTaskContext.commitAll(resultSummary, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO, this.taskDAO, this.documentTaskDAO, this.reviewCycleEntryTaskDAO, this.documentVersionTaskDAO);
            if (log.isDebugEnabled()) {
                log.debug("Successfully called commitAll.");
            }
        }
    }

    private void updateReviewTasksOfDocument(ReviewCycleContext cycleContext, ReviewTaskContext taskContext, List<PlanDeliverReleaseJoin> documentVersionTaskJoins, List<PlanDeliverReleaseJoin> participationJoins, List<PlanDeliverReleaseJoin> futureEmailJoins, Long projectId, Long subProjectId, List<ProjectHoliday> projectHolidays, List<Long> unreleasedDocumentIds, List<PlanDeliverReleaseJoin> additionalInfoJoins) {
        Project project = (Project)this.projectDAO.get(projectId);
        boolean UsePDCStartDateForTasks = project.isUsePDCStartDateForTasks();
        for (PlanDeliverReleaseJoin documentVersionTaskJoin : documentVersionTaskJoins) {
            DocumentRelease documentRelease;
            Long documentVersionId = documentVersionTaskJoin.getDocumentVersionId();
            DocumentVersion documentVersion = taskContext.getDocumentVersion(documentVersionId);
            ReviewCycleNodeInstance activeNodeInstance = cycleContext.getNodeInstance(documentVersion.getActiveNodeInstanceId());
            ReviewCycleNode activeNode = cycleContext.getNodeById(activeNodeInstance.getReviewCycleNodeId());
            if (log.isDebugEnabled()) {
                log.debug("...... Processing DocumentVersionTaskJoins for documentVersion " + documentVersionId + ", ReviewCycleNodeInstance activeNodeInstance " + activeNodeInstance.getId());
            }
            ReviewCycleNodeInstanceReleased nodeInstanceReleased = null;
            for (ReviewCycleNodeInstanceReleased candidate : cycleContext.getAllNodeInstancesReleased()) {
                if (log.isTraceEnabled()) {
                    log.trace("... when searching nodeInstanceReleased: Checking candidate [" + candidate.getId() + "]");
                }
                if (candidate.getReviewCycleNodeInstanceId().longValue() != documentVersion.getActiveNodeInstanceId().longValue()) continue;
                nodeInstanceReleased = candidate;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug("...... Determined ReviewCycleNodeInstanceReleased " + (nodeInstanceReleased != null ? nodeInstanceReleased.getId() : "null"));
            }
            Long localisationId = documentVersionTaskJoin.getProjectLocalisationId();
            BaseTask task = documentVersionTaskJoin.getBaseTask();
            DocumentVersionTask documentVersionTask = documentVersionTaskJoin.getDocumentVersionTask();
            DocumentRelease documentRelease2 = documentRelease = documentVersionTaskJoin.getDocumentReleaseId() != null ? documentVersionTaskJoin.getDocumentRelease() : null;
            if (log.isDebugEnabled()) {
                log.debug("....... Determined taskId " + task.getId() + ", documentReleaseId " + (documentRelease != null ? documentRelease.getId() : "null"));
            }
            task.setLocalisationId(localisationId);
            Double documentReleaseStartDate = documentRelease != null ? documentRelease.getStartDate() : null;
            Double documentReleaseEndDate = documentRelease != null ? documentRelease.getEndDate() : null;
            boolean allPreviousNodesAreNotEmpty = true;
            boolean isFirstDocumentVersion = false;
            for (PlanDeliverReleaseJoin additionalInfoJoin : additionalInfoJoins) {
                if (additionalInfoJoin.getDocumentId().equals(documentVersionTaskJoin.getDocumentId()) && additionalInfoJoin.getDerivedInfoNumberOfDocumentVersions() == 1) {
                    isFirstDocumentVersion = true;
                }
                if (!additionalInfoJoin.getReviewCycleNodeResultFinished().booleanValue() || additionalInfoJoin.getReviewCycleNodeResultReviewCycleResultOptionId() == null) continue;
                Integer resultOptionValue = cycleContext.getResultOption(additionalInfoJoin.getReviewCycleNodeResultReviewCycleResultOptionId()).getValue();
                allPreviousNodesAreNotEmpty &= resultOptionValue != -8;
            }
            boolean usePDCStartDate = UsePDCStartDateForTasks && isFirstDocumentVersion && (activeNode.getPosition().equals(1) || !allPreviousNodesAreNotEmpty);
            this.taskUtils.generateTaskDeadlines(cycleContext, task, documentVersionTask, documentReleaseStartDate, documentReleaseEndDate, projectHolidays, nodeInstanceReleased, usePDCStartDate, projectId);
            taskContext.registerTaskForUpdate(task);
            taskContext.registerDocumentVersionTaskForUpdate(documentVersionTask);
            Long participationId = documentVersionTask.getProjectParticipationId();
            List<FutureEmail> futureEmails = taskContext.getFutureEmailsForTask(task.getId());
            this.taskUtils.generateMultipleTaskEmailSnippets(new DebugContext(), taskContext, futureEmails, projectHolidays, participationJoins, task, participationId, TaskEmailSnippetType.TYPE_TASK_RESCHEDULED);
            Collection<ProjectParticipation> projectRoleParticipations = taskContext.getAllProjectRoleParticipations();
            HashSet<Long> projectRoleParticipationIds = new HashSet<Long>();
            for (ProjectParticipation projectRoleParticipation : projectRoleParticipations) {
                projectRoleParticipationIds.add(projectRoleParticipation.getId());
            }
            if (futureEmailLog.isDebugEnabled()) {
                futureEmailLog.debug("updateReviewTasksOfDocument will call generateTaskLateFutureEmail");
            }
            this.taskUtils.generateTaskLateFutureEMail(new DebugContext(), taskContext, projectHolidays, projectRoleParticipationIds, task);
        }
    }

    private void updateDocumentTasksOfDocuments(ReviewTaskContext taskContext, List<Long> unreleasedDocumentIds) {
        Collection<ObjectPlannerRelease> releasedObjectPlanners = taskContext.getAllReleasedObjectPlanners();
        for (Long unreleasedDocumentId : unreleasedDocumentIds) {
            this.updateDocumentTasksOfDocument(taskContext, releasedObjectPlanners, unreleasedDocumentId);
        }
    }

    private void updateDocumentTasksOfDocument(ReviewTaskContext taskContext, Collection<ObjectPlannerRelease> releasedObjectPlanners, Long unreleasedDocumentId) {
        boolean noObjectPlanner;
        if (log.isDebugEnabled()) {
            log.debug(".... Called updateDocumentTasksOfDocument with " + releasedObjectPlanners.size() + " released objectPlanners and unreleasedDocumentId " + unreleasedDocumentId);
        }
        Collection<PlanDeliverReleaseJoin> entryTaskJoins = taskContext.getEntryTaskJoinsForDocument(unreleasedDocumentId);
        HashMap<Long, PlanDeliverReleaseJoin> idToReviewCycleEntryTaskJoin = new HashMap<Long, PlanDeliverReleaseJoin>();
        for (PlanDeliverReleaseJoin entryTaskJoin : entryTaskJoins) {
            if (entryTaskJoin.getDocumentTaskTaskId() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug(".... Registering documentTask " + entryTaskJoin.getDocumentTaskTaskId() + " in map.");
            }
            idToReviewCycleEntryTaskJoin.put(entryTaskJoin.getDocumentTaskTaskId(), entryTaskJoin);
        }
        if (idToReviewCycleEntryTaskJoin.size() > 1) {
            throw new IllegalArgumentException("The old code called from at.cdes.controller.actionhandler.TaskOperationsImpl.updateDocumentTasksOfDocument(ReleasedDocument, ReleasedObjectList, Project) queries this using uniqueResult.");
        }
        PlanDeliverReleaseJoin taskJoin = idToReviewCycleEntryTaskJoin.size() == 0 ? null : (PlanDeliverReleaseJoin)idToReviewCycleEntryTaskJoin.values().iterator().next();
        BaseTask task = taskJoin != null ? taskJoin.getBaseTask() : null;
        DocumentTask documentTask = taskJoin != null ? taskJoin.getDocumentTask() : null;
        ReviewCycleEntryTask reviewCycleEntryTask = taskJoin != null ? taskJoin.getReviewCycleEntryTask() : null;
        Document document = taskContext.getDocument(unreleasedDocumentId);
        Long objectPlannerId = document.getObjectPlannerId();
        ObjectPlannerRelease releasedObjectPlanner = null;
        for (ObjectPlannerRelease candidate : releasedObjectPlanners) {
            if (candidate.getObjectPlannerId().longValue() != objectPlannerId.longValue()) continue;
            releasedObjectPlanner = candidate;
        }
        if (log.isDebugEnabled()) {
            log.debug(".... Chose releasedObjectPlanner " + (releasedObjectPlanner != null ? releasedObjectPlanner.getId() : "null"));
        }
        DocumentRelease releasedDocument = taskContext.getReleasedDocumentByDocumentId(unreleasedDocumentId);
        boolean bl = noObjectPlanner = releasedObjectPlanner == null || releasedObjectPlanner.getPlannerId() == null;
        if (log.isDebugEnabled()) {
            log.debug(".... noObjectPlanner = " + noObjectPlanner + "; documentTask = " + (documentTask != null ? documentTask.getTaskId() : "null"));
        }
        if (!noObjectPlanner && documentTask == null) {
            if (document.getStartDate() != null && !document.isHasDocumentVersions().booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug(".... Will generate ReviewCycleEntryTask for relObjectPlanner " + releasedObjectPlanner.getId() + ", document " + document.getId());
                }
                ProjectParticipation participation = taskContext.getProjectParticipation(releasedObjectPlanner.getPlannerId());
                Project project = taskContext.getProject(participation.getProjectId());
                Long localisationId = project.getLocalisationId();
                DocumentRelease documentRelease = taskContext.getReleasedDocumentByDocumentId(document.getId());
                ReviewCycleInstanceReleased reviewCycleInstanceReleased = taskContext.getInstanceReleased(releasedObjectPlanner.getReviewCycleInstanceId());
                List<PlanDeliverReleaseJoin> objectPlannerJoins = taskContext.getAllObjectPlannerJoins();
                List<ProjectHoliday> projectHolidays = taskContext.getAllProjectHolidays();
                Collection<ProjectParticipation> projectRoleParticipations = taskContext.getAllProjectRoleParticipations();
                HashSet<Long> projectRoleParticipationIds = new HashSet<Long>();
                for (ProjectParticipation projectRoleParticipation : projectRoleParticipations) {
                    projectRoleParticipationIds.add(projectRoleParticipation.getId());
                }
                this.taskUtils.generateReviewCycleEntryTask(new DebugContext(), taskContext, objectPlannerJoins, projectHolidays, projectRoleParticipationIds, localisationId, releasedObjectPlanner, reviewCycleInstanceReleased, document, documentRelease);
            }
        } else if (documentTask != null) {
            if (log.isDebugEnabled()) {
                log.debug(".... Case documentTask != null; taskId = " + documentTask.getTaskId());
            }
            if (document.getStartDate() == null || noObjectPlanner) {
                if (log.isDebugEnabled()) {
                    log.debug(".... Case startDate == null OR noObjectPlanner");
                }
                for (PlanDeliverReleaseJoin entryTaskJoin : entryTaskJoins) {
                    if (entryTaskJoin.getReviewCycleEntryTaskTaskId() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(".... Scheduling reviewCycleEntryTask " + entryTaskJoin.getReviewCycleEntryTaskTaskId() + " for deletion.");
                        }
                        taskContext.registerReviewCycleEntryTaskForDelete(entryTaskJoin.getReviewCycleEntryTask());
                        taskContext.registerDocumentTaskForDelete(entryTaskJoin.getDocumentTask());
                        taskContext.registerTaskForDelete(entryTaskJoin.getBaseTask());
                    }
                    if (entryTaskJoin.getTaskEmailSnippetEmailSnippetId() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(".... Scheduling taskEmailSnippet " + entryTaskJoin.getTaskEmailSnippetEmailSnippetId() + " for deletion");
                        }
                        taskContext.registerTaskEmailSnippetForDelete(entryTaskJoin.getTaskEmailSnippet());
                    }
                    if (entryTaskJoin.getFutureEmailId() == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(".... Scheduling futureEmail " + entryTaskJoin.getFutureEmailId() + " for deletion");
                    }
                    taskContext.registerFutureEmailForDelete(entryTaskJoin.getFutureEmail());
                }
            } else {
                ReviewCycleInstanceReleased instance = taskContext.getInstanceReleased(releasedObjectPlanner.getReviewCycleInstanceId());
                List<ProjectHoliday> projectHolidays = taskContext.getAllProjectHolidays();
                this.taskUtils.generateTaskDeadlines(projectHolidays, task, documentTask, reviewCycleEntryTask, releasedDocument, instance.getDuration(), instance.getDurationPre());
                if (log.isDebugEnabled()) {
                    log.debug(".... Will update reviewCycleEntryTask " + reviewCycleEntryTask.getTaskId());
                }
                taskContext.registerTaskForUpdate(task);
                taskContext.registerReviewCycleEntryTaskForUpdate(reviewCycleEntryTask);
                List<FutureEmail> futureEmails = taskContext.getFutureEmailsForTask(task.getId());
                this.taskUtils.generateMultipleTaskEmailSnippets(new DebugContext(), taskContext, futureEmails, projectHolidays, taskContext.getAllObjectPlannerJoins(), task, releasedObjectPlanner.getPlannerId(), TaskEmailSnippetType.TYPE_TASK_RESCHEDULED);
                Collection<ProjectParticipation> projectRoleParticipations = taskContext.getAllProjectRoleParticipations();
                HashSet<Long> projectRoleParticipationIds = new HashSet<Long>();
                for (ProjectParticipation projectRoleParticipation : projectRoleParticipations) {
                    projectRoleParticipationIds.add(projectRoleParticipation.getId());
                }
                if (futureEmailLog.isDebugEnabled()) {
                    futureEmailLog.debug("updateDocumentTasksOfDocument will call generateTaskLateFutureEmail");
                }
                this.taskUtils.generateTaskLateFutureEMail(new DebugContext(), taskContext, projectHolidays, projectRoleParticipationIds, task);
            }
        }
    }

    private String utcSecondsToDebugString(Double utcSeconds) {
        return utcSeconds != null ? new Date((long)(utcSeconds * 1000.0)).toString() : "null";
    }

    private <T extends IReviewTaskJoin> List<Task> processTaskJoins(Long loginPersonId, List<T> reviewTaskJoins, Function<T, TaskType> getTaskType, TriConsumer<Task, T, Map<Long, List<ProjectHoliday>>> additional, Long organisationPersonId) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long loginPrincipalPersonId = loginPrincipal.getPersonId();
        Map<Long, List<IReviewTaskJoin>> taskIdToJoins = reviewTaskJoins.stream().collect(Collectors.groupingBy(IReviewTaskJoin::getBaseTaskId));
        List<Long> projectIds = reviewTaskJoins.stream().map(IReviewTaskJoin::getProjectId).distinct().collect(Collectors.toList());
        Map projectHolidays = reviewTaskJoins.size() != 0 ? this.projectHolidayDAO.getByProjects(projectIds).stream().collect(Collectors.groupingBy(ProjectHoliday::getProjectId)) : Collections.emptyMap();
        HashMap<Long, Set<Action>> projectIdToActions = new HashMap<Long, Set<Action>>();
        HashSet<Action> globalActions = new HashSet<Action>();
        List<CertificateOrgPersonJoin> signedUserPolicyVersions = this.certificateRequestDAO.getSignedUserPolicyVersionsForPerson(loginPrincipalPersonId);
        for (CertificateOrgPersonJoin signedUserPolicyVersion : signedUserPolicyVersions) {
            if (signedUserPolicyVersion.getOrganisationPersonRetiredFlag().booleanValue()) continue;
            organisationPersonId = signedUserPolicyVersion.getCertificateOrganisationPersonId();
            Map<Long, Set<Action>> currProjectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.REVIEW_PROTOCOL, Action.TASKS_OVERVIEW, Action.UPLOAD_DOCUMENT, Action.OVERRIDE_LATE_REVIEWS);
            for (Long projectId : currProjectIdToActions.keySet()) {
                Set<Action> currActions = currProjectIdToActions.get(projectId);
                if (projectIdToActions.containsKey(projectId)) {
                    ((Set)projectIdToActions.get(projectId)).addAll(currActions);
                    continue;
                }
                projectIdToActions.put(projectId, currActions);
            }
            if (log.isDebugEnabled()) {
                log.debug("projectIdToActions for organisationPersonId [" + organisationPersonId + "]: " + projectIdToActions);
            }
            globalActions.addAll(this.actionDAO.getGlobalActions(organisationPersonId, Action.DELETE_TASK));
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Long taskId : taskIdToJoins.keySet()) {
            List<IReviewTaskJoin> currJoins = taskIdToJoins.get(taskId);
            IReviewTaskJoin someJoin = currJoins.get(0);
            Task task = new Task();
            task.setTaskId(someJoin.getBaseTaskId());
            task.setTaskType(getTaskType.apply(someJoin));
            task.setName(someJoin.getBaseTaskName());
            task.setBeginDate(someJoin.getBaseTaskBeginDate());
            task.setEndDate(someJoin.getBaseTaskEndDate());
            task.setDeltaT(someJoin.getBaseTaskDeltaT());
            task.setUnreleasedDocumentId(someJoin.getDocumentId());
            if (someJoin.getDocumentReleaseId() != null) {
                task.setDocumentId(someJoin.getDocumentReleaseId());
                task.setDocumentName(someJoin.getDocumentReleaseName());
                task.setDocumentContent(someJoin.getDocumentReleaseContent());
                task.setDocumentEndDate(someJoin.getDocumentReleaseEndDate());
            } else {
                task.setDocumentId(someJoin.getDocumentId());
                task.setDocumentName(someJoin.getDocumentName());
                task.setDocumentContent(someJoin.getDocumentContent());
                task.setDocumentEndDate(someJoin.getDocumentEndDate());
            }
            task.setDocumentVersionId(someJoin.getDocumentVersionId());
            task.setDocumentVersionName(someJoin.getDocumentVersionName());
            task.setDocumentVersionUploaded(someJoin.getDocumentVersionUploaded());
            if (someJoin.getObjectReleaseId() != null) {
                task.setObjectId(someJoin.getObjectReleaseId());
                task.setObjectCode(someJoin.getObjectReleaseCode());
                task.setObjectName(someJoin.getObjectReleaseName());
            } else {
                task.setObjectId(someJoin.getObjectId());
                task.setObjectCode(someJoin.getObjectCode());
                task.setObjectName(someJoin.getObjectName());
            }
            Long projectId = someJoin.getProjectId();
            task.setProjectId(projectId);
            task.setProjectCode(someJoin.getProjectCode());
            task.setProjectName(someJoin.getProjectName());
            Long networkId = someJoin.getNetworkId();
            task.setNetworkId(networkId);
            task.setNetworkName(someJoin.getNetworkName());
            task.setContractualDeadline(someJoin.getDocumentVersionTaskContractualDeadline());
            task.setMinDeltaT(someJoin.getDocumentVersionTaskMinDeltaT());
            task.setUrgency(someJoin.getDocumentVersionTaskUrgency());
            task.setFinishCellFlag(someJoin.getReviewCycleResultOptionFinishCellFlag());
            task.setRealmCode(someJoin.getRealmCode());
            task.setRealmName(someJoin.getRealmName());
            task.setResultOptionName(someJoin.getReviewCycleResultOptionName());
            task.setPositionResultOrgPersonId(someJoin.getPositionResultOrgPersonId());
            task.setPositionResultPersonId(someJoin.getPositionResultPersonId());
            task.setPositionResultPersonGivenName(someJoin.getPositionResultPersonGivenName());
            task.setPositionResultPersonSurName(someJoin.getPositionResultPersonSurName());
            task.setPositionResultOrganisationId(someJoin.getPositionResultOrganisationId());
            task.setPositionResultOrganisationName(someJoin.getPositionResultOrganisationName());
            if (task.getTaskType() == TaskType.REVIEW_CYCLE_PLOT_TASK || task.getTaskType() == TaskType.PLOT_ORDER_ACCEPTANCE_TASK) {
                task.setPlotOrderJobNumber(someJoin.getPlotOrderJobNumber());
            }
            additional.accept(task, someJoin, projectHolidays);
            Person mainParticipantPerson = null;
            Organisation mainParticipantOrganisation = null;
            Person ownParticipantPerson = null;
            Organisation ownParticipantOrganisation = null;
            Person signerPerson = null;
            Organisation signerOrganisation = null;
            Long ownTaskOrgPersonId = null;
            List<IReviewTaskJoin> participantJoins = taskIdToJoins.get(taskId);
            for (IReviewTaskJoin participantJoin : participantJoins) {
                Boolean mainParticipantFlag;
                if (participantJoin.getPersonId() != null && participantJoin.getPersonId().longValue() == loginPrincipalPersonId.longValue()) {
                    ownTaskOrgPersonId = participantJoin.getProjectParticipantOrganisationPersonId();
                }
                if ((mainParticipantFlag = participantJoin.getProjectParticipantMainParticipantFlag()) != null && mainParticipantFlag.booleanValue()) {
                    mainParticipantPerson = participantJoin.getPerson();
                    mainParticipantOrganisation = participantJoin.getOrganisation();
                } else {
                    ownParticipantPerson = participantJoin.getPerson();
                    ownParticipantOrganisation = participantJoin.getOrganisation();
                }
                if (!(participantJoin instanceof ReviewTaskDoneJoin)) continue;
                ReviewTaskDoneJoin reviewTaskDoneJoin = (ReviewTaskDoneJoin)participantJoin;
                if (reviewTaskDoneJoin.getSignerPersonId() != null) {
                    signerPerson = reviewTaskDoneJoin.getSignerPerson();
                }
                if (reviewTaskDoneJoin.getSignerOrganisationId() == null) continue;
                signerOrganisation = reviewTaskDoneJoin.getSignerOrganisation();
            }
            task.setMainParticipantPerson(mainParticipantPerson);
            task.setMainParticipantOrganisation(mainParticipantOrganisation);
            task.setOwnTaskOrgPersonId(ownTaskOrgPersonId);
            task.setOwnParticipantPerson(ownParticipantPerson);
            task.setOwnParticipantOrganisation(ownParticipantOrganisation);
            task.setSignerPerson(signerPerson);
            task.setSignerOrganisation(signerOrganisation);
            Set projectActions = (Set)projectIdToActions.get(projectId);
            boolean hasTasksOverview = projectActions.contains(Action.TASKS_OVERVIEW);
            boolean hasUploadDocument = projectActions.contains(Action.UPLOAD_DOCUMENT);
            task.setMayDoReviewProtocol(projectActions.contains(Action.REVIEW_PROTOCOL));
            task.setMayDoReviewDetail(hasTasksOverview);
            task.setMayDoAssignReview(projectActions.contains(Action.OVERRIDE_LATE_REVIEWS));
            task.setMayDoReview(hasTasksOverview);
            task.setMayDoUpload(hasTasksOverview);
            task.setMayDoReUpload(hasTasksOverview);
            task.setMayDoUploadOriginal(hasUploadDocument);
            task.setMayDoPlotOrderConfirm(hasTasksOverview);
            task.setMayDoPlotOrderDelivery(hasTasksOverview);
            task.setMayDoDelete(globalActions.contains(Action.DELETE_TASK));
            tasks.add(task);
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading [" + tasks.size() + "] tasks.");
        }
        return tasks;
    }

    public List<Task> getReviewTasks(Long organisationPersonId, TaskSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!this.actionDAO.getGlobalActions(organisationPersonId, Action.TASKS_OVERVIEW).contains(Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is mising permission [" + Action.TASKS_OVERVIEW + "] for querying review tasks.");
        }
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long loginPersonId = loginPrincipal.getPersonId();
        Double now = (double)Instant.now().toEpochMilli() / 1000.0;
        long prevMillis = System.currentTimeMillis();
        if (searchModel.getSearchMode() != TaskSearchMode.DONE) {
            if (perfLog.isDebugEnabled()) {
                perfLog.debug("Will query ReviewTaskJoins");
            }
            List<ReviewTaskJoin> reviewTaskJoins = this.taskDAO.getReviewTaskJoins(loginPersonId, searchModel);
            if (perfLog.isDebugEnabled()) {
                long currMillis = System.currentTimeMillis();
                long duration = currMillis - prevMillis;
                perfLog.debug("Queried [" + reviewTaskJoins.size() + "] ReviewTaskJoins in [" + duration + "ms]");
            }
            return this.processTaskJoins(loginPersonId, reviewTaskJoins, this::getTaskTypeByReviewTaskJoin, (task, someJoin, projectHolidays) -> {
                task.setOverallEndDate(this.getOverallEndDateByReviewTaskJoin((ReviewTaskJoin)someJoin));
                task.setSampleControlReview(this.getSampleControlReviewByReviewTaskJoin((ReviewTaskJoin)someJoin));
                task.setTaskStatus(this.getTaskStatusByReviewTaskJoin((ReviewTaskJoin)someJoin));
                task.setTaskDelay(this.getTaskDelayByReviewTaskJoin((ReviewTaskJoin)someJoin, projectHolidays.getOrDefault(someJoin.getProjectId(), Collections.emptyList()), now));
                task.setReviewDate(someJoin.getReviewCyclePositionResultResultDate());
                task.setUploadedDate(someJoin.getDocumentVersionUploaded());
                task.setReviewCycleDelay(this.getReviewCycleDelayByReviewTaskJoin((ReviewTaskJoin)someJoin, projectHolidays.getOrDefault(someJoin.getProjectId(), Collections.emptyList()), now));
                task.setDone(Boolean.valueOf(false));
            }, searchModel.getOrganisationPersonId());
        }
        if (perfLog.isDebugEnabled()) {
            perfLog.debug("Will query ReviewTaskDoneJoins");
        }
        List<ReviewTaskDoneJoin> reviewTaskJoins = this.taskDAO.getReviewTaskDoneJoins(loginPersonId, searchModel);
        if (perfLog.isDebugEnabled()) {
            long currMillis = System.currentTimeMillis();
            long duration = currMillis - prevMillis;
            perfLog.debug("Queried [" + reviewTaskJoins.size() + "] ReviewTaskDoneJoins in [" + duration + "ms]");
        }
        return this.processTaskJoins(loginPersonId, reviewTaskJoins, this::getTaskTypeByReviewTaskDoneJoin, (task, someJoin, projectHolidays) -> {
            task.setOverallEndDate(this.getOverallEndDateByReviewTaskDoneJoin((ReviewTaskDoneJoin)someJoin));
            task.setSampleControlReview(this.getSampleControlReviewByReviewTaskDoneJoin((ReviewTaskDoneJoin)someJoin));
            task.setTaskDelay(this.getTaskDelayByReviewTaskDoneJoin((ReviewTaskDoneJoin)someJoin, projectHolidays.getOrDefault(someJoin.getProjectId(), Collections.emptyList()), now));
            task.setDoneDate(this.getDoneDateByReviewTaskDoneJoin((ReviewTaskDoneJoin)someJoin));
            if (someJoin.getDocumentVersionId() != null) {
                task.setUploadedDate(someJoin.getDocumentVersionUploaded());
            } else if (someJoin.getReviewCycleEntryResultDocumentVersionId() != null) {
                task.setUploadedDate(someJoin.getReviewCycleEntryResultDocumentVersionUploaded());
            }
            task.setDone(Boolean.valueOf(true));
        }, searchModel.getOrganisationPersonId());
    }

    public OriginalDocumentTask getOriginalDocumentTaskByTaskId(Long organisationPersonId, Long taskId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Project project = this.projectDAO.getByDocumentVersionTask(taskId);
        Long projectId = project.getId();
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is not allowed to execute getOriginalDocumentTaskByTaskId for taskId [" + taskId + "] in project [" + projectId + "]; privilege [" + Action.TASKS_OVERVIEW + "] is missing.");
        }
        List<OriginalDocumentTask> originalTasks = this.originalDocumentTaskDAO.getByTask(taskId);
        return !originalTasks.isEmpty() ? originalTasks.get(0) : null;
    }

    private Double getDoneDateByReviewTaskDoneJoin(ReviewTaskDoneJoin reviewTaskDoneJoin) {
        if (reviewTaskDoneJoin.getReviewCycleEntryTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getReviewCycleEntryTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getOriginalDocumentTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getOriginalDocumentTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getPlotOrderAcceptanceTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getPlotOrderAcceptanceTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getReviewCyclePlottTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getReviewCycleEntryTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getReviewTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getReviewTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getAttachedReviewTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getAttachedReviewTaskDoneDoneDate();
        }
        if (reviewTaskDoneJoin.getSelectCellConnectionTaskDoneTaskId() != null) {
            return reviewTaskDoneJoin.getSelectCellConnectionTaskDoneDoneDate();
        }
        return null;
    }

    private TaskType getTaskTypeByReviewTaskJoin(ReviewTaskJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewCycleEntryTaskTaskId() != null) {
            return TaskType.REVIEW_CYCLE_ENTRY_TASK;
        }
        if (reviewTaskJoin.getOriginalDocumentTaskTaskId() != null) {
            return TaskType.ORIGINAL_DOCUMENT_TASK;
        }
        if (reviewTaskJoin.getPlotOrderAcceptanceTaskTaskId() != null) {
            return TaskType.PLOT_ORDER_ACCEPTANCE_TASK;
        }
        if (reviewTaskJoin.getReviewCyclePlottTaskTaskId() != null) {
            return TaskType.REVIEW_CYCLE_PLOT_TASK;
        }
        if (reviewTaskJoin.getReviewTaskTaskId() != null) {
            return TaskType.REVIEW_TASK;
        }
        if (reviewTaskJoin.getAttachedReviewTaskTaskId() != null) {
            return TaskType.ATTACHED_REVIEW_TASK;
        }
        if (reviewTaskJoin.getSelectCellConnectionTaskTaskId() != null) {
            return TaskType.SELECT_CELL_CONNECTION_TASK;
        }
        return TaskType.UNKNOWN;
    }

    private TaskType getTaskTypeByReviewTaskDoneJoin(ReviewTaskDoneJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewCycleEntryTaskDoneTaskId() != null) {
            return TaskType.REVIEW_CYCLE_ENTRY_TASK_DONE;
        }
        if (reviewTaskJoin.getOriginalDocumentTaskDoneTaskId() != null) {
            return TaskType.ORIGINAL_DOCUMENT_TASK_DONE;
        }
        if (reviewTaskJoin.getPlotOrderAcceptanceTaskDoneTaskId() != null) {
            return TaskType.PLOT_ORDER_ACCEPTANCE_TASK_DONE;
        }
        if (reviewTaskJoin.getReviewCyclePlottTaskDoneTaskId() != null) {
            return TaskType.REVIEW_CYCLE_PLOT_TASK_DONE;
        }
        if (reviewTaskJoin.getReviewTaskDoneTaskId() != null) {
            return TaskType.REVIEW_TASK_DONE;
        }
        if (reviewTaskJoin.getAttachedReviewTaskDoneTaskId() != null) {
            return TaskType.ATTACHED_REVIEW_TASK_DONE;
        }
        if (reviewTaskJoin.getSelectCellConnectionTaskDoneTaskId() != null) {
            return TaskType.SELECT_CELL_CONNECTION_TASK_DONE;
        }
        return TaskType.UNKNOWN;
    }

    private Double getOverallEndDateByReviewTaskJoin(ReviewTaskJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewCycleEntryTaskTaskId() != null) {
            return reviewTaskJoin.getReviewCycleEntryTaskOverallEndDate();
        }
        return reviewTaskJoin.getDocumentVersionTaskOverallEndDate();
    }

    private Double getOverallEndDateByReviewTaskDoneJoin(ReviewTaskDoneJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewCycleEntryTaskDoneTaskId() != null) {
            return reviewTaskJoin.getReviewCycleEntryTaskDoneOverallEndDate();
        }
        return reviewTaskJoin.getDocumentVersionTaskOverallEndDate();
    }

    private Boolean getSampleControlReviewByReviewTaskJoin(ReviewTaskJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewTaskTaskId() != null) {
            return reviewTaskJoin.getReviewTaskSampleControlReview();
        }
        if (reviewTaskJoin.getAttachedReviewTaskTaskId() != null) {
            return reviewTaskJoin.getAttachedReviewTaskSampleControlReview();
        }
        return null;
    }

    private Boolean getSampleControlReviewByReviewTaskDoneJoin(ReviewTaskDoneJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewTaskDoneTaskId() != null) {
            return reviewTaskJoin.getReviewTaskDoneSampleControlReview();
        }
        if (reviewTaskJoin.getAttachedReviewTaskDoneTaskId() != null) {
            return reviewTaskJoin.getAttachedReviewTaskDoneSampleControlReview();
        }
        return null;
    }

    private Integer getTaskStatusByReviewTaskJoin(ReviewTaskJoin reviewTaskJoin) {
        if (reviewTaskJoin.getReviewTaskTaskId() != null) {
            return reviewTaskJoin.getReviewTaskTaskStatus();
        }
        if (reviewTaskJoin.getAttachedReviewTaskTaskId() != null) {
            return reviewTaskJoin.getAttachedReviewTaskTaskStatus();
        }
        return null;
    }

    private Double getTaskDelayEndDate(ReviewTaskJoin join) {
        if (join.getReviewTaskTaskId() != null || join.getSelectCellConnectionTaskTaskId() != null || join.getAttachedReviewTaskTaskId() != null) {
            return join.getBaseTaskEndDate();
        }
        if (join.getReviewCycleEntryTaskTaskId() != null) {
            if (join.getDocumentReleaseStartDate() != null) {
                return join.getDocumentReleaseStartDate();
            }
            if (join.getDocumentStartDate() != null) {
                return join.getDocumentStartDate();
            }
            return join.getBaseTaskEndDate();
        }
        return null;
    }

    private Double getDoneTaskDelayEndDate(ReviewTaskDoneJoin join) {
        if (join.getReviewTaskDoneTaskId() != null || join.getSelectCellConnectionTaskDoneTaskId() != null || join.getAttachedReviewTaskDoneTaskId() != null) {
            return join.getBaseTaskEndDate();
        }
        if (join.getReviewCycleEntryTaskDoneTaskId() != null) {
            if (join.getDocumentReleaseStartDate() != null) {
                return join.getDocumentReleaseStartDate();
            }
            if (join.getDocumentStartDate() != null) {
                return join.getDocumentStartDate();
            }
            return join.getBaseTaskEndDate();
        }
        return null;
    }

    private Long getTaskDelayByReviewTaskJoin(ReviewTaskJoin join, List<ProjectHoliday> holidays, Double now) {
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", holidays);
        Double endDate = this.getTaskDelayEndDate(join);
        if (endDate != null) {
            return (long)holidayCalculator.getWorkingDaysBetween(endDate, now);
        }
        return null;
    }

    private Long getTaskDelayByReviewTaskDoneJoin(ReviewTaskDoneJoin join, List<ProjectHoliday> holidays, Double now) {
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", holidays);
        Double endDate = this.getDoneTaskDelayEndDate(join);
        if (endDate != null) {
            return (long)holidayCalculator.getWorkingDaysBetween(endDate, now);
        }
        return null;
    }

    private Double getReviewCycleEndDateByReviewTaskJoin(ReviewTaskJoin join) {
        if (join.getDocumentReleaseEndDate() != null) {
            return join.getDocumentReleaseEndDate();
        }
        if (join.getDocumentEndDate() != null) {
            return join.getDocumentEndDate();
        }
        return this.getOverallEndDateByReviewTaskJoin(join);
    }

    private Long getReviewCycleDelayByReviewTaskJoin(ReviewTaskJoin join, List<ProjectHoliday> holidays, Double now) {
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", holidays);
        Double endDate = this.getReviewCycleEndDateByReviewTaskJoin(join);
        if (endDate != null) {
            return (long)holidayCalculator.getWorkingDaysBetween(endDate, now);
        }
        return null;
    }

    public String triggerExportReviewTaskListPdf(Long loginOrganisationPersonId, TaskSearchModel taskSearchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns, Set<Long> taskIdsAfterQuickFilter, String quickFilter) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, loginOrganisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        ReviewTaskPdfCallable job = new ReviewTaskPdfCallable(this.reviewTaskPdfExporter, this, loginOrganisationPersonId, taskSearchModel, columnToWidth, columnSortSpecs, this.enableCustomerLogo, taskIdsAfterQuickFilter, quickFilter);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportReviewTaskListXls(Long loginOrganisationPersonId, TaskSearchModel taskSearchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, loginOrganisationPersonId);
        List columnSortSpecs = ColumnSortSpec.getFromClient(sortColumns);
        ReviewTaskXlsCallable job = new ReviewTaskXlsCallable(this.reviewTaskXlsExporter, this, loginOrganisationPersonId, taskSearchModel, columnToWidth, columnSortSpecs, this.enableCustomerLogo);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public void deleteTask(Long organisationPersonId, Long taskId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!this.actionDAO.getGlobalActions(organisationPersonId, Action.DELETE_TASK).contains(Action.DELETE_TASK)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is mising permission [" + Action.DELETE_TASK + "] necessary for deleting tasks.");
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        TaskType taskType = this.taskDAO.getTaskType(taskId);
        if (taskType == TaskType.ATTACHED_REVIEW_TASK) {
            this.taskUtils.deleteAttachedReviewTasks(taskIds);
        } else if (taskType == TaskType.ORIGINAL_DOCUMENT_TASK) {
            this.taskUtils.deleteOriginalDocumentTasks(taskIds);
        } else if (taskType == TaskType.PLOT_ORDER_ACCEPTANCE_TASK) {
            this.taskUtils.deletePlotOrderAcceptanceTasks(taskIds);
        } else if (taskType == TaskType.REVIEW_CYCLE_ENTRY_TASK) {
            this.taskUtils.deleteReviewCycleEntryTasks(taskIds);
        } else if (taskType == TaskType.REVIEW_CYCLE_PLOT_TASK) {
            this.taskUtils.deleteReviewCyclePlotTasks(taskIds);
        } else if (taskType == TaskType.REVIEW_TASK) {
            this.taskUtils.deleteReviewTasks(taskIds);
        } else if (taskType == TaskType.SELECT_CELL_CONNECTION_TASK) {
            this.taskUtils.deleteSelectCellConnectionTask(taskId);
        } else {
            throw new RuntimeException("Unknown taskType [" + taskType + "]");
        }
    }

    public TaskCounts getTaskCounts(Long organisationPersonId) {
        if (this.disableTaskCounts != null && this.disableTaskCounts.booleanValue()) {
            if (perfLog.isDebugEnabled()) {
                perfLog.debug("Disabled calculating TaskCounts by config, will return TaskCounts = null");
            }
            return null;
        }
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!this.actionDAO.getGlobalActions(organisationPersonId, Action.TASKS_OVERVIEW).contains(Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is mising permission [" + Action.TASKS_OVERVIEW + "] for querying review task counts.");
        }
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long loginPersonId = loginPrincipal.getPersonId();
        TaskCounts taskCounts = new TaskCounts();
        long prevMillis = System.currentTimeMillis();
        if (perfLog.isDebugEnabled()) {
            perfLog.debug("Will query TaskCountLines");
        }
        List<TaskCountLine> taskCountLines = this.taskDAO.getTaskCounts(loginPersonId);
        if (perfLog.isDebugEnabled()) {
            long currMillis = System.currentTimeMillis();
            long duration = currMillis - prevMillis;
            perfLog.debug("Queried [" + taskCountLines.size() + "] TaskCountLines in [" + duration + "ms]");
        }
        for (TaskCountLine taskCountLine : taskCountLines) {
            TaskSearchMode taskSearchMode = taskCountLine.getSearchMode();
            TaskDeputyMode taskDeputyMode = taskCountLine.getDeputyMode();
            Integer count = taskCountLine.getCount();
            if (taskSearchMode == TaskSearchMode.OWN) {
                if (taskDeputyMode == null) {
                    taskCounts.setOwnTaskCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
                    taskCounts.setOwnTaskMainCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.DEPUTY) {
                    taskCounts.setOwnTaskDeputyCount(count);
                    continue;
                }
                throw new IllegalArgumentException("Unknown taskDeputyMode [" + taskDeputyMode + "]");
            }
            if (taskSearchMode == TaskSearchMode.BATCH) {
                if (taskDeputyMode == null) {
                    taskCounts.setBatchTaskCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
                    taskCounts.setBatchTaskMainCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.DEPUTY) {
                    taskCounts.setBatchTaskDeputyCount(count);
                    continue;
                }
                throw new IllegalArgumentException("Unknown taskDeputyMode [" + taskDeputyMode + "]");
            }
            if (taskSearchMode == TaskSearchMode.DONE) {
                if (taskDeputyMode == null) {
                    taskCounts.setDoneTaskCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
                    taskCounts.setDoneTaskMainCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.DEPUTY) {
                    taskCounts.setDoneTaskDeputyCount(count);
                    continue;
                }
                throw new IllegalArgumentException("Unknown taskDeputyMode [" + taskDeputyMode + "]");
            }
            if (taskSearchMode == TaskSearchMode.LATE) {
                if (taskDeputyMode == null) {
                    taskCounts.setLateTaskCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
                    taskCounts.setLateTaskMainCount(count);
                    continue;
                }
                if (taskDeputyMode == TaskDeputyMode.DEPUTY) {
                    taskCounts.setLateTaskDeputyCount(count);
                    continue;
                }
                throw new IllegalArgumentException("Unknown taskDeputyMode [" + taskDeputyMode + "]");
            }
            throw new IllegalArgumentException("Unknown taskSearchMode[" + taskSearchMode + "]");
        }
        return taskCounts;
    }

    public ReviewTaskPageInfo getReviewTaskPageInfo(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!this.actionDAO.getGlobalActions(organisationPersonId, Action.TASKS_OVERVIEW).contains(Action.TASKS_OVERVIEW)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is mising permission [" + Action.TASKS_OVERVIEW + "] for getting general information about the task page.");
        }
        Map<Long, Set<Action>> projectIdToActions = this.actionDAO.getActionsForProjects(organisationPersonId, null, Action.MONITOR_LATE_REVIEWS, Action.OVERRIDE_LATE_REVIEWS);
        boolean mayQueryLateReviews = ActionHelper.hasActionForAnyProject(projectIdToActions, Action.MONITOR_LATE_REVIEWS) || ActionHelper.hasActionForAnyProject(projectIdToActions, Action.OVERRIDE_LATE_REVIEWS);
        ReviewTaskPageInfo info = new ReviewTaskPageInfo();
        info.setMayQueryLateReviews(mayQueryLateReviews);
        return info;
    }

    public int checkTasks(Long organisationPersonId, Long subProjectId) {
        return this.doCheckTasks(organisationPersonId, subProjectId, false);
    }

    public int checkAndRestoreTasks(Long organisationPersonId, Long subProjectId) {
        return this.doCheckTasks(organisationPersonId, subProjectId, true);
    }

    private int doCheckTasks(Long organisationPersonId, Long subProjectId, boolean checkAndRestore) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        if (!globalActions.contains(Action.SUPER_ADMIN_RIGHT)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not check actions for subProject [" + subProjectId + "]; permission [" + Action.SUPER_ADMIN_RIGHT + "] is missing.");
        }
        return this.taskUtils.checkAndRestorePlannerEntryTasks(subProjectId, checkAndRestore);
    }

    @FunctionalInterface
    private static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }
}

