/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentDateHistoryPart;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.impl.dao.GenDocumentDateHistoryPartDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcDocumentDateHistoryPartDAO
extends AbstrIdDAO<DocumentDateHistoryPart>
implements GenDocumentDateHistoryPartDAO {
    public AbstractJdbcDocumentDateHistoryPartDAO() {
        super(DocumentDateHistoryPart.class, "id", "document_date_history_part", new String[]{"id", "project_participant_id", "edit_date", "start_date", "end_date", "document_id", "mod_type", "organisation_person_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcDocumentDateHistoryPartDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participant_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "edit_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mod_type") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcDocumentDateHistoryPartDAO.getSelectClauseForDto("document_date_history_part", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcDocumentDateHistoryPartDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".project_participant_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participant_id") + "," + entityLocalName + ".edit_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "edit_date") + "," + entityLocalName + ".start_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_date") + "," + entityLocalName + ".end_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_date") + "," + entityLocalName + ".document_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + "," + entityLocalName + ".mod_type" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mod_type") + "," + entityLocalName + ".organisation_person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + " ";
    }

    protected DocumentDateHistoryPart fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentDateHistoryPart documentDateHistoryPart = new DocumentDateHistoryPart();
        documentDateHistoryPart.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setEditDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setStartDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setEndDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setModType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        documentDateHistoryPart.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentDateHistoryPart;
    }

    public static DocumentDateHistoryPart fillDocumentDateHistoryPartFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentDateHistoryPart documentDateHistoryPart = new DocumentDateHistoryPart();
        documentDateHistoryPart.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setEditDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setStartDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setEndDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setModType(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentDateHistoryPart.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentDateHistoryPart;
    }

    public static DocumentDateHistoryPart fillDocumentDateHistoryPartFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcDocumentDateHistoryPartDAO.fillDocumentDateHistoryPartFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    public int update(DocumentDateHistoryPart dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentDateHistoryPart> dtos) {
        Iterator<DocumentDateHistoryPart> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentDateHistoryPart documentDateHistoryPart) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentDateHistoryPart.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentDateHistoryPart.getProjectParticipantId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)documentDateHistoryPart.getEditDate());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)4, (Double)documentDateHistoryPart.getStartDate());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)5, (Double)documentDateHistoryPart.getEndDate());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)documentDateHistoryPart.getDocumentId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)7, (Number)documentDateHistoryPart.getModType());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)documentDateHistoryPart.getOrganisationPersonId());
    }

    @Override
    public List<DocumentDateHistoryPart> getByProjectParticipant(ProjectParticipant projectParticipant) {
        return this.getByProjectParticipant(projectParticipant.getId());
    }

    @Override
    public List<DocumentDateHistoryPart> getByProjectParticipant(final Long projectParticipantId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participant_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipantId);
            }
        });
    }

    @Override
    public List<DocumentDateHistoryPart> getByDocument(Document document) {
        return this.getByDocument(document.getId());
    }

    @Override
    public List<DocumentDateHistoryPart> getByDocument(final Long documentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentId);
            }
        });
    }

    @Override
    public List<DocumentDateHistoryPart> getByOrganisationPerson(OrganisationPerson organisationPerson) {
        return this.getByOrganisationPerson(organisationPerson.getId());
    }

    @Override
    public List<DocumentDateHistoryPart> getByOrganisationPerson(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<DocumentDateHistoryPart> getByProjectParticipants(Collection<Long> projectParticipantId) {
        if (projectParticipantId.isEmpty()) {
            return new ArrayList<DocumentDateHistoryPart>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipantId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipantId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participant_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentDateHistoryPart> getByDocuments(Collection<Long> documentId) {
        if (documentId.isEmpty()) {
            return new ArrayList<DocumentDateHistoryPart>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentId.size()];
        int n = 0;
        Iterator<Long> it = documentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentDateHistoryPart> getByOrganisationPersons(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<DocumentDateHistoryPart>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

